#version 330

// Input
layout (location =  0) in vec4 in_Position;
layout (location =  4) in vec2 in_TexCoord;
layout (location =  8) in mat4 in_WorldMatrix;
layout (location = 12) in mat4 in_TextureMatrix;

// Output
out vec3 ex_Normal;
out vec2 ex_TexCoord;

// Uniforms
uniform mat4 worldViewProjMatrix;

void main()
{
	gl_Position = worldViewProjMatrix * in_WorldMatrix * in_Position;
	ex_TexCoord = vec2(in_TextureMatrix * vec4(in_TexCoord, 0., 1.));
}
