/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES1;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLException;

public class ImmModeSink {
    public static final boolean DEBUG_BEGIN_END = false;
    public static final boolean DEBUG_DRAW = false;
    public static final int GL_QUAD_STRIP = 8;
    public static final int GL_POLYGON = 9;
    private VBOSet vboSet;
    private ArrayList<VBOSet> vboSetList;
    private static boolean vboUsage = true;

    public static ImmModeSink createFixed(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return new ImmModeSink(gL, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, false);
    }

    public static ImmModeSink createGLSL(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return new ImmModeSink(gL, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, true);
    }

    public static boolean usesVBO() {
        return vboUsage;
    }

    public static void setVBOUsage(boolean bl) {
        vboUsage = bl;
    }

    public void destroy(GL gL) {
        this.destroyList(gL);
        this.vboSet.destroy(gL);
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(GL gL) {
        this.destroyList(gL);
        this.vboSet.reset(gL);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ImmModeSink[");
        stringBuilder.append(",\n\tVBO list: " + this.vboSetList.size() + " [");
        Iterator<VBOSet> iterator = this.vboSetList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("\n\t");
            stringBuilder.append(iterator.next());
        }
        if (this.vboSetList.size() > 0) {
            stringBuilder.append("\n\t],\nVBO current: NOP]");
        } else {
            stringBuilder.append("\n\t],\nVBO current: \n");
            stringBuilder.append(this.vboSet);
            stringBuilder.append("\n]");
        }
        return stringBuilder.toString();
    }

    public void draw(GL gL, boolean bl) {
        int n = 0;
        Iterator<VBOSet> iterator = this.vboSetList.iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(gL, null, bl, n);
            ++n;
        }
    }

    public void draw(GL gL, Buffer buffer, boolean bl) {
        int n = 0;
        Iterator<VBOSet> iterator = this.vboSetList.iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(gL, buffer, bl, n);
            ++n;
        }
    }

    public void glBegin(int n) {
        this.vboSet.modeOrig = n;
        switch (n) {
            case 8: {
                n = 5;
                break;
            }
            case 9: {
                n = 1;
            }
        }
        this.vboSet.mode = n;
        this.vboSet.checkSeal(false);
    }

    public final void glEnd(GL gL) {
        this.glEnd(gL, null, true);
    }

    public void glEnd(GL gL, boolean bl) {
        this.glEnd(gL, null, bl);
    }

    public final void glEnd(GL gL, Buffer buffer) {
        this.glEnd(gL, buffer, true);
    }

    private void glEnd(GL gL, Buffer buffer, boolean bl) {
        if (bl) {
            this.vboSet.seal(gL, true);
            this.vboSet.draw(gL, buffer, true, -1);
            this.reset(gL);
        } else {
            this.vboSet.seal(gL, true);
            this.vboSet.enableBuffer(gL, false);
            this.vboSetList.add(this.vboSet);
            this.vboSet = this.vboSet.regenerate();
        }
    }

    public void glVertexv(Buffer buffer) {
        this.vboSet.glVertexv(buffer);
    }

    public void glNormalv(Buffer buffer) {
        this.vboSet.glNormalv(buffer);
    }

    public void glColorv(Buffer buffer) {
        this.vboSet.glColorv(buffer);
    }

    public void glTexCoordv(Buffer buffer) {
        this.vboSet.glTexCoordv(buffer);
    }

    public final void glVertex2f(float f, float f2) {
        this.vboSet.glVertex2f(f, f2);
    }

    public final void glVertex3f(float f, float f2, float f3) {
        this.vboSet.glVertex3f(f, f2, f3);
    }

    public final void glNormal3f(float f, float f2, float f3) {
        this.vboSet.glNormal3f(f, f2, f3);
    }

    public final void glColor3f(float f, float f2, float f3) {
        this.vboSet.glColor3f(f, f2, f3);
    }

    public final void glColor4f(float f, float f2, float f3, float f4) {
        this.vboSet.glColor4f(f, f2, f3, f4);
    }

    public final void glTexCoord2f(float f, float f2) {
        this.vboSet.glTexCoord2f(f, f2);
    }

    public final void glTexCoord3f(float f, float f2, float f3) {
        this.vboSet.glTexCoord3f(f, f2, f3);
    }

    public final void glVertex2s(short s, short s2) {
        this.vboSet.glVertex2s(s, s2);
    }

    public final void glVertex3s(short s, short s2, short s3) {
        this.vboSet.glVertex3s(s, s2, s3);
    }

    public final void glNormal3s(short s, short s2, short s3) {
        this.vboSet.glNormal3s(s, s2, s3);
    }

    public final void glColor3s(short s, short s2, short s3) {
        this.vboSet.glColor3s(s, s2, s3);
    }

    public final void glColor4s(short s, short s2, short s3, short s4) {
        this.vboSet.glColor4s(s, s2, s3, s4);
    }

    public final void glTexCoord2s(short s, short s2) {
        this.vboSet.glTexCoord2s(s, s2);
    }

    public final void glTexCoord3s(short s, short s2, short s3) {
        this.vboSet.glTexCoord3s(s, s2, s3);
    }

    public final void glVertex2b(byte by, byte by2) {
        this.vboSet.glVertex2b(by, by2);
    }

    public final void glVertex3b(byte by, byte by2, byte by3) {
        this.vboSet.glVertex3b(by, by2, by3);
    }

    public final void glNormal3b(byte by, byte by2, byte by3) {
        this.vboSet.glNormal3b(by, by2, by3);
    }

    public final void glColor3b(byte by, byte by2, byte by3) {
        this.vboSet.glColor3b(by, by2, by3);
    }

    public final void glColor4b(byte by, byte by2, byte by3, byte by4) {
        this.vboSet.glColor4b(by, by2, by3, by4);
    }

    public final void glTexCoord2b(byte by, byte by2) {
        this.vboSet.glTexCoord2b(by, by2);
    }

    public final void glTexCoord3b(byte by, byte by2, byte by3) {
        this.vboSet.glTexCoord3b(by, by2, by3);
    }

    protected ImmModeSink(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        if (bl && !gL.hasGLSL()) {
            throw new GLException("ImmModeSink GLSL usage not supported: " + gL);
        }
        this.vboSet = new VBOSet(gL, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, bl);
        this.vboSetList = new ArrayList();
    }

    private void destroyList(GL gL) {
        Iterator<VBOSet> iterator = this.vboSetList.iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy(gL);
        }
        this.vboSetList.clear();
    }

    protected static class VBOSet {
        protected int mode;
        protected int modeOrig;
        protected int glBufferUsage;
        protected int initialElementCount;
        protected ByteBuffer buffer;
        protected int bSize;
        protected int count;
        protected int vboName;
        public static final int VERTEX = 0;
        public static final int COLOR = 1;
        public static final int NORMAL = 2;
        public static final int TEXTCOORD = 3;
        protected int vOffset;
        protected int cOffset;
        protected int nOffset;
        protected int tOffset;
        protected int vComps;
        protected int cComps;
        protected int nComps;
        protected int tComps;
        protected int vDataType;
        protected int cDataType;
        protected int nDataType;
        protected int tDataType;
        protected Buffer vertexArray;
        protected Buffer colorArray;
        protected Buffer normalArray;
        protected Buffer textCoordArray;
        protected GLArrayDataWrapper vArrayData;
        protected GLArrayDataWrapper cArrayData;
        protected GLArrayDataWrapper nArrayData;
        protected GLArrayDataWrapper tArrayData;
        protected boolean sealed;
        protected boolean sealedGL;
        protected boolean useGLSL;
        protected boolean bufferEnabled;
        protected boolean bufferWritten;
        protected GL gl;

        protected VBOSet(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
            this.gl = gL;
            this.glBufferUsage = n;
            this.initialElementCount = n2;
            this.vDataType = n4;
            this.vComps = n3;
            this.cDataType = n6;
            this.cComps = n5;
            this.nDataType = n8;
            this.nComps = n7;
            this.tDataType = n10;
            this.tComps = n9;
            this.useGLSL = bl;
            this.allocateBuffer(n2);
            this.rewind();
            this.sealed = false;
            this.sealedGL = false;
            this.mode = 0;
            this.modeOrig = 0;
            this.bufferEnabled = false;
            this.bufferWritten = false;
        }

        protected final VBOSet regenerate() {
            return new VBOSet(this.gl, this.glBufferUsage, this.initialElementCount, this.vComps, this.vDataType, this.cComps, this.cDataType, this.nComps, this.nDataType, this.tComps, this.tDataType, this.useGLSL);
        }

        protected void checkSeal(boolean bl) throws GLException {
            if (0 == this.mode) {
                throw new GLException("No mode set yet, call glBegin(mode) first:\n\t" + this);
            }
            if (this.sealed != bl) {
                if (bl) {
                    throw new GLException("Not Sealed yet, call glEnd() first:\n\t" + this);
                }
                throw new GLException("Already Sealed, can't modify VBO after glEnd():\n\t" + this);
            }
        }

        protected void draw(GL gL, Buffer buffer, boolean bl, int n) {
            this.enableBuffer(gL, true);
            if (this.buffer != null) {
                GL2ES1 gL2ES1 = gL.getGL2ES1();
                if (null == buffer) {
                    gL2ES1.glDrawArrays(this.mode, 0, this.count);
                } else {
                    Class<?> clazz = buffer.getClass();
                    int n2 = -1;
                    if (ReflectionUtil.instanceOf(clazz, (String)ByteBuffer.class.getName())) {
                        n2 = 5121;
                    } else if (ReflectionUtil.instanceOf(clazz, (String)ShortBuffer.class.getName())) {
                        n2 = 5123;
                    }
                    if (0 > n2) {
                        throw new GLException("Given Buffer Class not supported: " + clazz + ", should be ubyte or ushort:\n\t" + this);
                    }
                    gL2ES1.glDrawElements(this.mode, buffer.remaining(), n2, buffer);
                }
            }
            if (bl) {
                this.enableBuffer(gL, false);
            }
        }

        public void glVertexv(Buffer buffer) {
            this.checkSeal(false);
            GLBuffers.put((Buffer)this.vertexArray, (Buffer)buffer);
        }

        public void glNormalv(Buffer buffer) {
            this.checkSeal(false);
            GLBuffers.put((Buffer)this.normalArray, (Buffer)buffer);
        }

        public void glColorv(Buffer buffer) {
            this.checkSeal(false);
            GLBuffers.put((Buffer)this.colorArray, (Buffer)buffer);
        }

        public void glTexCoordv(Buffer buffer) {
            this.checkSeal(false);
            GLBuffers.put((Buffer)this.textCoordArray, (Buffer)buffer);
        }

        public void glVertex2b(byte by, byte by2) {
            this.checkSeal(false);
            this.growBufferIfNecessary(0, 2);
            if (this.vComps > 0) {
                GLBuffers.putb((Buffer)this.vertexArray, (byte)by);
            }
            if (this.vComps > 1) {
                GLBuffers.putb((Buffer)this.vertexArray, (byte)by2);
            }
            this.padding(0, this.vComps - 2);
        }

        public void glVertex3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(0, 3);
            if (this.vComps > 0) {
                GLBuffers.putb((Buffer)this.vertexArray, (byte)by);
            }
            if (this.vComps > 1) {
                GLBuffers.putb((Buffer)this.vertexArray, (byte)by2);
            }
            if (this.vComps > 2) {
                GLBuffers.putb((Buffer)this.vertexArray, (byte)by3);
            }
            this.padding(0, this.vComps - 3);
        }

        public void glVertex2s(short s, short s2) {
            this.checkSeal(false);
            this.growBufferIfNecessary(0, 2);
            if (this.vComps > 0) {
                GLBuffers.puts((Buffer)this.vertexArray, (short)s);
            }
            if (this.vComps > 1) {
                GLBuffers.puts((Buffer)this.vertexArray, (short)s2);
            }
            this.padding(0, this.vComps - 2);
        }

        public void glVertex3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(0, 3);
            if (this.vComps > 0) {
                GLBuffers.puts((Buffer)this.vertexArray, (short)s);
            }
            if (this.vComps > 1) {
                GLBuffers.puts((Buffer)this.vertexArray, (short)s2);
            }
            if (this.vComps > 2) {
                GLBuffers.puts((Buffer)this.vertexArray, (short)s3);
            }
            this.padding(0, this.vComps - 3);
        }

        public void glVertex2f(float f, float f2) {
            this.checkSeal(false);
            this.growBufferIfNecessary(0, 2);
            if (this.vComps > 0) {
                GLBuffers.putf((Buffer)this.vertexArray, (float)f);
            }
            if (this.vComps > 1) {
                GLBuffers.putf((Buffer)this.vertexArray, (float)f2);
            }
            this.padding(0, this.vComps - 2);
        }

        public void glVertex3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(0, 3);
            if (this.vComps > 0) {
                GLBuffers.putf((Buffer)this.vertexArray, (float)f);
            }
            if (this.vComps > 1) {
                GLBuffers.putf((Buffer)this.vertexArray, (float)f2);
            }
            if (this.vComps > 2) {
                GLBuffers.putf((Buffer)this.vertexArray, (float)f3);
            }
            this.padding(0, this.vComps - 3);
        }

        public void glNormal3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(2, 3);
            if (this.nComps > 0) {
                GLBuffers.putb((Buffer)this.normalArray, (byte)by);
            }
            if (this.nComps > 1) {
                GLBuffers.putb((Buffer)this.normalArray, (byte)by2);
            }
            if (this.nComps > 2) {
                GLBuffers.putb((Buffer)this.normalArray, (byte)by3);
            }
            this.padding(2, this.nComps - 3);
        }

        public void glNormal3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(2, 3);
            if (this.nComps > 0) {
                GLBuffers.puts((Buffer)this.normalArray, (short)s);
            }
            if (this.nComps > 1) {
                GLBuffers.puts((Buffer)this.normalArray, (short)s2);
            }
            if (this.nComps > 2) {
                GLBuffers.puts((Buffer)this.normalArray, (short)s3);
            }
            this.padding(2, this.nComps - 3);
        }

        public void glNormal3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(2, 3);
            if (this.nComps > 0) {
                GLBuffers.putf((Buffer)this.normalArray, (float)f);
            }
            if (this.nComps > 1) {
                GLBuffers.putf((Buffer)this.normalArray, (float)f2);
            }
            if (this.nComps > 2) {
                GLBuffers.putf((Buffer)this.normalArray, (float)f3);
            }
            this.padding(2, this.nComps - 3);
        }

        public void glColor3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(1, 3);
            if (this.cComps > 0) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by);
            }
            if (this.cComps > 1) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by2);
            }
            if (this.cComps > 2) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by3);
            }
            this.padding(1, this.cComps - 3);
        }

        public void glColor4b(byte by, byte by2, byte by3, byte by4) {
            this.checkSeal(false);
            this.growBufferIfNecessary(1, 4);
            if (this.cComps > 0) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by);
            }
            if (this.cComps > 1) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by2);
            }
            if (this.cComps > 2) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by3);
            }
            if (this.cComps > 3) {
                GLBuffers.putb((Buffer)this.colorArray, (byte)by4);
            }
            this.padding(1, this.cComps - 4);
        }

        public void glColor3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(1, 3);
            if (this.cComps > 0) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s);
            }
            if (this.cComps > 1) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s2);
            }
            if (this.cComps > 2) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s3);
            }
            this.padding(1, this.cComps - 3);
        }

        public void glColor4s(short s, short s2, short s3, short s4) {
            this.checkSeal(false);
            this.growBufferIfNecessary(1, 4);
            if (this.cComps > 0) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s);
            }
            if (this.cComps > 1) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s2);
            }
            if (this.cComps > 2) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s3);
            }
            if (this.cComps > 3) {
                GLBuffers.puts((Buffer)this.colorArray, (short)s4);
            }
            this.padding(1, this.cComps - 4);
        }

        public void glColor3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(1, 3);
            if (this.cComps > 0) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f);
            }
            if (this.cComps > 1) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f2);
            }
            if (this.cComps > 2) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f3);
            }
            this.padding(1, this.cComps - 3);
        }

        public void glColor4f(float f, float f2, float f3, float f4) {
            this.checkSeal(false);
            this.growBufferIfNecessary(1, 4);
            if (this.cComps > 0) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f);
            }
            if (this.cComps > 1) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f2);
            }
            if (this.cComps > 2) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f3);
            }
            if (this.cComps > 3) {
                GLBuffers.putf((Buffer)this.colorArray, (float)f4);
            }
            this.padding(1, this.cComps - 4);
        }

        public void glTexCoord2b(byte by, byte by2) {
            this.checkSeal(false);
            this.growBufferIfNecessary(3, 2);
            if (this.tComps > 0) {
                GLBuffers.putb((Buffer)this.textCoordArray, (byte)by);
            }
            if (this.tComps > 1) {
                GLBuffers.putb((Buffer)this.textCoordArray, (byte)by2);
            }
            this.padding(3, this.tComps - 2);
        }

        public void glTexCoord3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(3, 3);
            if (this.tComps > 0) {
                GLBuffers.putb((Buffer)this.textCoordArray, (byte)by);
            }
            if (this.tComps > 1) {
                GLBuffers.putb((Buffer)this.textCoordArray, (byte)by2);
            }
            if (this.tComps > 2) {
                GLBuffers.putb((Buffer)this.textCoordArray, (byte)by3);
            }
            this.padding(3, this.tComps - 3);
        }

        public void glTexCoord2s(short s, short s2) {
            this.checkSeal(false);
            this.growBufferIfNecessary(3, 2);
            if (this.tComps > 0) {
                GLBuffers.puts((Buffer)this.textCoordArray, (short)s);
            }
            if (this.tComps > 1) {
                GLBuffers.puts((Buffer)this.textCoordArray, (short)s2);
            }
            this.padding(3, this.tComps - 2);
        }

        public void glTexCoord3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(3, 3);
            if (this.tComps > 0) {
                GLBuffers.puts((Buffer)this.textCoordArray, (short)s);
            }
            if (this.tComps > 1) {
                GLBuffers.puts((Buffer)this.textCoordArray, (short)s2);
            }
            if (this.tComps > 2) {
                GLBuffers.puts((Buffer)this.textCoordArray, (short)s3);
            }
            this.padding(3, this.tComps - 3);
        }

        public void glTexCoord2f(float f, float f2) {
            this.checkSeal(false);
            this.growBufferIfNecessary(3, 2);
            if (this.tComps > 0) {
                GLBuffers.putf((Buffer)this.textCoordArray, (float)f);
            }
            if (this.tComps > 1) {
                GLBuffers.putf((Buffer)this.textCoordArray, (float)f2);
            }
            this.padding(3, this.tComps - 2);
        }

        public void glTexCoord3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBufferIfNecessary(3, 3);
            if (this.tComps > 0) {
                GLBuffers.putf((Buffer)this.textCoordArray, (float)f);
            }
            if (this.tComps > 1) {
                GLBuffers.putf((Buffer)this.textCoordArray, (float)f2);
            }
            if (this.tComps > 2) {
                GLBuffers.putf((Buffer)this.textCoordArray, (float)f3);
            }
            this.padding(3, this.tComps - 3);
        }

        public void rewind() {
            if (null != this.vertexArray) {
                this.vertexArray.rewind();
            }
            if (null != this.colorArray) {
                this.colorArray.rewind();
            }
            if (null != this.normalArray) {
                this.normalArray.rewind();
            }
            if (null != this.textCoordArray) {
                this.textCoordArray.rewind();
            }
        }

        public void destroy(GL gL) {
            this.reset(gL);
            this.vertexArray = null;
            this.colorArray = null;
            this.normalArray = null;
            this.textCoordArray = null;
            this.vArrayData = null;
            this.cArrayData = null;
            this.nArrayData = null;
            this.tArrayData = null;
            this.buffer = null;
            this.bSize = 0;
            this.count = 0;
        }

        public void reset(GL gL) {
            this.enableBuffer(gL, false);
            this.reset();
        }

        public void reset() {
            if (this.buffer != null) {
                this.buffer.clear();
            }
            this.rewind();
            this.mode = 0;
            this.modeOrig = 0;
            this.sealed = false;
            this.bufferEnabled = false;
            this.bufferWritten = false;
        }

        public void seal(GL gL, boolean bl) {
            this.seal(bl);
            if (this.sealedGL == bl) {
                return;
            }
            this.sealedGL = bl;
            GL gL2 = gL.getGL();
            if (bl) {
                if (vboUsage && this.vboName == 0) {
                    int[] nArray = new int[1];
                    gL2.glGenBuffers(1, nArray, 0);
                    this.vboName = nArray[0];
                }
                if (null != this.vArrayData) {
                    this.vArrayData.setVBOName(this.vboName);
                }
                if (null != this.cArrayData) {
                    this.cArrayData.setVBOName(this.vboName);
                }
                if (null != this.nArrayData) {
                    this.nArrayData.setVBOName(this.vboName);
                }
                if (null != this.tArrayData) {
                    this.tArrayData.setVBOName(this.vboName);
                }
                this.enableBuffer(gL2, true);
            } else {
                this.enableBuffer(gL2, false);
            }
        }

        public void seal(boolean bl) {
            if (this.sealed == bl) {
                return;
            }
            this.sealed = bl;
            if (bl) {
                this.bufferWritten = false;
            }
        }

        public void enableBuffer(GL gL, boolean bl) {
            if (this.bufferEnabled != bl && this.count > 0) {
                if (bl) {
                    this.checkSeal(true);
                }
                if (this.useGLSL) {
                    this.enableBufferGLSL(gL, bl);
                } else {
                    this.enableBufferFixed(gL, bl);
                }
                this.bufferEnabled = bl;
            }
        }

        public void enableBufferFixed(GL gL, boolean bl) {
            GL2ES1 gL2ES1 = gL.getGL2ES1();
            if (bl) {
                gL.glBindBuffer(34962, this.vboName);
                if (!this.bufferWritten) {
                    gL.glBufferData(34962, this.buffer.limit(), this.buffer, 35044);
                    this.bufferWritten = true;
                }
                if (this.vComps > 0) {
                    gL2ES1.glEnableClientState(32884);
                    gL2ES1.glVertexPointer(this.vArrayData);
                }
                if (this.cComps > 0) {
                    gL2ES1.glEnableClientState(32886);
                    gL2ES1.glColorPointer(this.cArrayData);
                }
                if (this.nComps > 0) {
                    gL2ES1.glEnableClientState(32885);
                    gL2ES1.glNormalPointer(this.nArrayData);
                }
                if (this.tComps > 0) {
                    gL2ES1.glEnableClientState(32888);
                    gL2ES1.glTexCoordPointer(this.tArrayData);
                }
                gL.glBindBuffer(34962, 0);
            } else {
                if (this.vComps > 0) {
                    gL2ES1.glDisableClientState(32884);
                }
                if (this.cComps > 0) {
                    gL2ES1.glDisableClientState(32886);
                }
                if (this.nComps > 0) {
                    gL2ES1.glDisableClientState(32885);
                }
                if (this.tComps > 0) {
                    gL2ES1.glDisableClientState(32888);
                }
            }
        }

        public void enableBufferGLSL(GL gL, boolean bl) {
            ShaderState shaderState = ShaderState.getShaderState(gL);
            if (null == shaderState) {
                throw new GLException("No ShaderState in " + gL);
            }
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            if (bl) {
                gL2ES2.glBindBuffer(34962, this.vboName);
                if (!this.bufferWritten) {
                    gL2ES2.glBufferData(34962, this.buffer.limit(), this.buffer, 35044);
                    this.bufferWritten = true;
                }
                if (this.vComps > 0) {
                    shaderState.enableVertexAttribArray(gL2ES2, this.vArrayData);
                    shaderState.vertexAttribPointer(gL2ES2, this.vArrayData);
                }
                if (this.cComps > 0) {
                    shaderState.enableVertexAttribArray(gL2ES2, this.cArrayData);
                    shaderState.vertexAttribPointer(gL2ES2, this.cArrayData);
                }
                if (this.nComps > 0) {
                    shaderState.enableVertexAttribArray(gL2ES2, this.nArrayData);
                    shaderState.vertexAttribPointer(gL2ES2, this.nArrayData);
                }
                if (this.tComps > 0) {
                    shaderState.enableVertexAttribArray(gL2ES2, this.tArrayData);
                    shaderState.vertexAttribPointer(gL2ES2, this.tArrayData);
                }
                gL2ES2.glBindBuffer(34962, 0);
            } else {
                if (this.vComps > 0) {
                    shaderState.disableVertexAttribArray(gL2ES2, this.vArrayData);
                }
                if (this.cComps > 0) {
                    shaderState.disableVertexAttribArray(gL2ES2, this.cArrayData);
                }
                if (this.nComps > 0) {
                    shaderState.disableVertexAttribArray(gL2ES2, this.nArrayData);
                }
                if (this.tComps > 0) {
                    shaderState.disableVertexAttribArray(gL2ES2, this.tArrayData);
                }
            }
        }

        public String toString() {
            return "VBOSet[mode " + this.mode + ", modeOrig " + this.modeOrig + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ",\n\t" + this.vArrayData + ",\n\t" + this.cArrayData + ",\n\t" + this.nArrayData + ",\n\t" + this.tArrayData + "]";
        }

        protected void allocateBuffer(int n) {
            int n2 = this.vComps * GLBuffers.sizeOfGLType(this.vDataType);
            int n3 = this.cComps * GLBuffers.sizeOfGLType(this.cDataType);
            int n4 = this.nComps * GLBuffers.sizeOfGLType(this.nDataType);
            int n5 = this.tComps * GLBuffers.sizeOfGLType(this.tDataType);
            this.count = n;
            this.bSize = this.count * (n2 + n3 + n4 + n5);
            this.buffer = GLBuffers.newDirectByteBuffer((int)this.bSize);
            int n6 = 0;
            int n7 = this.count * n2;
            this.vertexArray = n7 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, n6, n7, this.vDataType) : null;
            this.vOffset = n6;
            n6 += n7;
            n7 = this.count * n3;
            this.colorArray = n7 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, n6, n7, this.cDataType) : null;
            this.cOffset = n6;
            n6 += n7;
            n7 = this.count * n4;
            this.normalArray = n7 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, n6, n7, this.nDataType) : null;
            this.nOffset = n6;
            n6 += n7;
            n7 = this.count * n5;
            this.textCoordArray = n7 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, n6, n7, this.tDataType) : null;
            this.tOffset = n6;
            this.buffer.position(n6 += n7);
            this.buffer.flip();
            this.vArrayData = this.vComps > 0 ? GLArrayDataWrapper.createFixed(32884, this.vComps, this.vDataType, false, 0, this.vertexArray, 0, this.vOffset, 35044, 34962) : null;
            this.cArrayData = this.cComps > 0 ? GLArrayDataWrapper.createFixed(32886, this.cComps, this.cDataType, false, 0, this.colorArray, 0, this.cOffset, 35044, 34962) : null;
            this.nArrayData = this.nComps > 0 ? GLArrayDataWrapper.createFixed(32885, this.nComps, this.nDataType, false, 0, this.normalArray, 0, this.nOffset, 35044, 34962) : null;
            this.tArrayData = this.tComps > 0 ? GLArrayDataWrapper.createFixed(32888, this.tComps, this.tDataType, false, 0, this.textCoordArray, 0, this.tOffset, 35044, 34962) : null;
        }

        protected final boolean growBufferIfNecessary(int n, int n2) {
            if (this.buffer == null || this.count < n2) {
                this.growBuffer(n, this.initialElementCount);
                return true;
            }
            return false;
        }

        protected final void growBuffer(int n, int n2) {
            if (this.sealed || 0 == n2) {
                return;
            }
            Buffer buffer = this.vertexArray;
            Buffer buffer2 = this.colorArray;
            Buffer buffer3 = this.normalArray;
            Buffer buffer4 = this.textCoordArray;
            this.allocateBuffer(this.count + n2);
            if (null != buffer) {
                buffer.flip();
                GLBuffers.put((Buffer)this.vertexArray, (Buffer)buffer);
            }
            if (null != buffer2) {
                buffer2.flip();
                GLBuffers.put((Buffer)this.colorArray, (Buffer)buffer2);
            }
            if (null != buffer3) {
                buffer3.flip();
                GLBuffers.put((Buffer)this.normalArray, (Buffer)buffer3);
            }
            if (null != buffer4) {
                buffer4.flip();
                GLBuffers.put((Buffer)this.textCoordArray, (Buffer)buffer4);
            }
        }

        protected void padding(int n, int n2) {
            if (this.sealed) {
                return;
            }
            Buffer buffer = null;
            switch (n) {
                case 0: {
                    buffer = this.vertexArray;
                    break;
                }
                case 1: {
                    buffer = this.colorArray;
                    break;
                }
                case 2: {
                    buffer = this.normalArray;
                    break;
                }
                case 3: {
                    buffer = this.textCoordArray;
                }
            }
            if (null == buffer) {
                return;
            }
            while (n2-- > 0) {
                GLBuffers.putb((Buffer)buffer, (byte)0);
            }
        }
    }
}

