/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import java.security.AccessController;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public abstract class WindowsWGLDrawable
extends GLDrawableImpl {
    private static final boolean PROFILING = Debug.isPropertyDefined("jogl.debug.GLDrawable.profiling", true, AccessController.getContext());
    private static final int PROFILING_TICKS = 200;
    private int profilingSwapBuffersTicks;
    private long profilingSwapBuffersTime;

    public WindowsWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        super(gLDrawableFactory, nativeSurface, bl);
    }

    @Override
    protected void setRealizedImpl() {
        if (!this.realized) {
            return;
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeSurface, null);
        if (DEBUG) {
            System.err.println("!!! WindowsWGLDrawable.setRealized(true): " + windowsWGLGraphicsConfiguration);
        }
    }

    @Override
    protected final void swapBuffersImpl() {
        long l = 0L;
        if (PROFILING) {
            l = System.currentTimeMillis();
        }
        if (!GDI.SwapBuffers(this.getHandle()) && GDI.GetLastError() != 0) {
            throw new GLException("Error swapping buffers");
        }
        if (PROFILING) {
            long l2 = System.currentTimeMillis();
            this.profilingSwapBuffersTime += l2 - l;
            int n = 200;
            if (++this.profilingSwapBuffersTicks == n) {
                System.err.println("SwapBuffers calls: " + this.profilingSwapBuffersTime + " ms / " + n + "  calls (" + (float)this.profilingSwapBuffersTime / (float)n + " ms/call)");
                this.profilingSwapBuffersTime = 0L;
                this.profilingSwapBuffersTicks = 0;
            }
        }
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        return this.getFactoryImpl().getGLDynamicLookupHelper(0);
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

