/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.glsl.fixedfunc;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLException;
import javax.media.opengl.GLUniformData;
import javax.media.opengl.fixedfunc.GLPointerFuncUtil;

public class FixedFuncPipeline {
    public static final int MAX_TEXTURE_UNITS = 8;
    public static final int MAX_LIGHTS = 8;
    protected static final boolean DEBUG = false;
    protected boolean verbose = false;
    protected boolean textureEnabled = false;
    protected IntBuffer textureCoordsEnabled = Buffers.newDirectIntBuffer((int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    protected boolean textureCoordsEnabledDirty = false;
    protected int activeTextureUnit = 0;
    protected int cullFace = -2;
    protected boolean lightingEnabled = false;
    protected IntBuffer lightsEnabled = Buffers.newDirectIntBuffer((int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    protected boolean lightsEnabledDirty = false;
    protected PMVMatrix pmvMatrix;
    protected ShaderState shaderState;
    protected ShaderProgram shaderProgramColor;
    protected ShaderProgram shaderProgramColorTexture;
    protected ShaderProgram shaderProgramColorLight;
    protected ShaderProgram shaderProgramColorTextureLight;
    protected static final String mgl_PMVMatrix = "mgl_PMVMatrix";
    protected static final String mgl_ColorEnabled = "mgl_ColorEnabled";
    protected static final String mgl_ColorStatic = "mgl_ColorStatic";
    protected static final String mgl_LightSource = "mgl_LightSource";
    protected static final String mgl_FrontMaterial = "mgl_FrontMaterial";
    protected static final String mgl_LightsEnabled = "mgl_LightsEnabled";
    protected static final String mgl_ShadeModel = "mgl_ShadeModel";
    protected static final String mgl_TexCoordEnabled = "mgl_TexCoordEnabled";
    protected static final String mgl_ActiveTexture = "mgl_ActiveTexture";
    protected static final String mgl_ActiveTextureIdx = "mgl_ActiveTextureIdx";
    protected static final String mgl_CullFace = "mgl_CullFace";
    protected static final FloatBuffer zero4f = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    public static final FloatBuffer defAmbient = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 0.0f, 1.0f});
    public static final FloatBuffer defDiffuse = zero4f;
    public static final FloatBuffer defSpecular = zero4f;
    public static final FloatBuffer defPosition = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 1.0f, 0.0f});
    public static final FloatBuffer defSpotDir = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, -1.0f});
    public static final float defSpotExponent = 0.0f;
    public static final float defSpotCutoff = 180.0f;
    public static final float defConstantAtten = 1.0f;
    public static final float defLinearAtten = 0.0f;
    public static final float defQuadraticAtten = 0.0f;
    public static final FloatBuffer defMatAmbient = Buffers.newDirectFloatBuffer((float[])new float[]{0.2f, 0.2f, 0.2f, 1.0f});
    public static final FloatBuffer defMatDiffuse = Buffers.newDirectFloatBuffer((float[])new float[]{0.8f, 0.8f, 0.8f, 1.0f});
    public static final FloatBuffer defMatSpecular = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 0.0f, 1.0f});
    public static final FloatBuffer defMatEmission = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 0.0f, 1.0f});
    public static final float defMatShininess = 0.0f;
    protected static final String vertexColorFileDef = "FixedFuncColor";
    protected static final String vertexColorLightFileDef = "FixedFuncColorLight";
    protected static final String fragmentColorFileDef = "FixedFuncColor";
    protected static final String fragmentColorTextureFileDef = "FixedFuncColorTexture";
    protected static final String shaderSrcRootDef = "shaders";
    protected static final String shaderBinRootDef = "shaders/bin";

    public FixedFuncPipeline(GL2ES2 gL2ES2, PMVMatrix pMVMatrix) {
        this.init(gL2ES2, pMVMatrix, FixedFuncPipeline.class, shaderSrcRootDef, shaderBinRootDef, "FixedFuncColor", vertexColorLightFileDef, "FixedFuncColor", fragmentColorTextureFileDef);
    }

    public FixedFuncPipeline(GL2ES2 gL2ES2, PMVMatrix pMVMatrix, Class clazz, String string, String string2, String string3, String string4, String string5, String string6) {
        this.init(gL2ES2, pMVMatrix, clazz, string, string2, string3, string4, string5, string6);
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isValid() {
        return this.shaderState.linked();
    }

    public ShaderState getShaderState() {
        return this.shaderState;
    }

    public int getActiveTextureUnit() {
        return this.activeTextureUnit;
    }

    public String getArrayIndexName(int n) {
        String string = GLPointerFuncUtil.getPredefinedArrayIndexName(n);
        switch (n) {
            case 32884: 
            case 32885: 
            case 32886: {
                break;
            }
            case 32888: {
                string = string + this.activeTextureUnit;
            }
        }
        return string;
    }

    public void destroy(GL2ES2 gL2ES2) {
        this.shaderProgramColor.release(gL2ES2, true);
        this.shaderProgramColorLight.release(gL2ES2, true);
        this.shaderProgramColorTexture.release(gL2ES2, true);
        this.shaderProgramColorTextureLight.release(gL2ES2, true);
        this.shaderState.destroy(gL2ES2);
    }

    public void glEnableClientState(GL2ES2 gL2ES2, int n) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.enableVertexAttribArray(gL2ES2, this.getArrayIndexName(n));
        if (this.textureCoordsEnabled.get(this.activeTextureUnit) != 1) {
            this.textureCoordsEnabled.put(this.activeTextureUnit, 1);
            this.textureCoordsEnabledDirty = true;
        }
    }

    public void glDisableClientState(GL2ES2 gL2ES2, int n) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.disableVertexAttribArray(gL2ES2, this.getArrayIndexName(n));
        if (this.textureCoordsEnabled.get(this.activeTextureUnit) != 0) {
            this.textureCoordsEnabled.put(this.activeTextureUnit, 0);
            this.textureCoordsEnabledDirty = true;
        }
    }

    public void glVertexPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glColorPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glColor4fv(GL2ES2 gL2ES2, FloatBuffer floatBuffer) {
        this.shaderState.useProgram(gL2ES2, true);
        GLUniformData gLUniformData = this.shaderState.getUniform(mgl_ColorStatic);
        if (null != gLUniformData) {
            gLUniformData.setData(floatBuffer);
            this.shaderState.uniform(gL2ES2, gLUniformData);
        }
    }

    public void glNormalPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glTexCoordPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        gLArrayData.setName(this.getArrayIndexName(gLArrayData.getIndex()));
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glLightfv(GL2ES2 gL2ES2, int n, int n2, FloatBuffer floatBuffer) {
        this.shaderState.useProgram(gL2ES2, true);
        if (0 <= (n -= 16384) && n < 8) {
            GLUniformData gLUniformData = null;
            switch (n2) {
                case 4608: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].ambient");
                    break;
                }
                case 4609: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].diffuse");
                    break;
                }
                case 4610: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].specular");
                    break;
                }
                case 4611: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].position");
                    break;
                }
                case 4612: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].spotDirection");
                    break;
                }
                case 4613: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].spotExponent");
                    break;
                }
                case 4614: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].spotCutoff");
                    break;
                }
                case 4615: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].constantAttenuation");
                    break;
                }
                case 4616: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].linearAttenuation");
                    break;
                }
                case 4617: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].quadraticAttenuation");
                    break;
                }
                default: {
                    if (this.verbose) {
                        System.err.println("glLightfv pname not within [GL_AMBIENT GL_DIFFUSE GL_SPECULAR GL_POSITION GL_SPOT_DIRECTION]: " + n2);
                    }
                    return;
                }
            }
            if (null != gLUniformData) {
                gLUniformData.setData(floatBuffer);
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
        } else if (this.verbose) {
            System.err.println("glLightfv light not within [0..8]: " + n);
        }
    }

    public void glMaterialfv(GL2ES2 gL2ES2, int n, int n2, FloatBuffer floatBuffer) {
        this.shaderState.useProgram(gL2ES2, true);
        switch (n) {
            case 1028: 
            case 1032: {
                break;
            }
            case 1029: {
                if (!this.verbose) break;
                System.err.println("glMaterialfv face GL_BACK currently not supported");
                break;
            }
        }
        GLUniformData gLUniformData = null;
        switch (n2) {
            case 4608: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.ambient");
                break;
            }
            case 5634: {
                this.glMaterialfv(gL2ES2, n, 4608, floatBuffer);
            }
            case 4609: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.diffuse");
                break;
            }
            case 4610: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.specular");
                break;
            }
            case 5632: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.emission");
                break;
            }
            case 5633: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.shininess");
                break;
            }
            default: {
                if (this.verbose) {
                    System.err.println("glMaterialfv pname not within [GL_AMBIENT GL_DIFFUSE GL_SPECULAR GL_EMISSION GL_SHININESS]: " + n2);
                }
                return;
            }
        }
        if (null != gLUniformData) {
            gLUniformData.setData(floatBuffer);
            this.shaderState.uniform(gL2ES2, gLUniformData);
        }
    }

    public void glShadeModel(GL2ES2 gL2ES2, int n) {
        this.shaderState.useProgram(gL2ES2, true);
        GLUniformData gLUniformData = this.shaderState.getUniform(mgl_ShadeModel);
        if (null != gLUniformData) {
            gLUniformData.setData(n);
            this.shaderState.uniform(gL2ES2, gLUniformData);
        }
    }

    public void glActiveTexture(GL2ES2 gL2ES2, int n) {
        if (0 <= (n -= 33984) && n < 8) {
            this.shaderState.useProgram(gL2ES2, true);
            GLUniformData gLUniformData = this.shaderState.getUniform(mgl_ActiveTexture);
            if (null != gLUniformData) {
                gLUniformData.setData(n);
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
            if (null != (gLUniformData = this.shaderState.getUniform(mgl_ActiveTextureIdx))) {
                gLUniformData.setData(n);
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
        } else {
            throw new GLException("glActivateTexture textureUnit not within GL_TEXTURE0 + [0..8]: " + n);
        }
        this.activeTextureUnit = n;
    }

    public boolean glEnable(GL2ES2 gL2ES2, int n, boolean bl) {
        switch (n) {
            case 3553: {
                this.textureEnabled = bl;
                return true;
            }
            case 2896: {
                this.lightingEnabled = bl;
                return false;
            }
            case 2884: {
                this.cullFace = Math.abs(this.cullFace);
                if (!bl) {
                    this.cullFace *= -1;
                }
                return true;
            }
        }
        int n2 = n - 16384;
        if (0 <= n2 && n2 < 8 && this.lightsEnabled.get(n2) == 1 != bl) {
            this.lightsEnabled.put(n2, bl ? 1 : 0);
            this.lightsEnabledDirty = true;
            return false;
        }
        return true;
    }

    public void glCullFace(GL2ES2 gL2ES2, int n) {
        switch (n) {
            case 1028: {
                n = 1;
                break;
            }
            case 1029: {
                n = 2;
                break;
            }
            case 1032: {
                n = 3;
            }
        }
        if (0 > this.cullFace) {
            n *= -1;
        }
        this.cullFace = n;
    }

    public void validate(GL2ES2 gL2ES2) {
        GLUniformData gLUniformData;
        this.shaderState.useProgram(gL2ES2, true);
        if (this.pmvMatrix.update()) {
            gLUniformData = this.shaderState.getUniform(mgl_PMVMatrix);
            if (null != gLUniformData) {
                this.shaderState.uniform(gL2ES2, gLUniformData);
            } else {
                throw new GLException("Failed to update: mgl_PMVMatrix");
            }
        }
        if (null != (gLUniformData = this.shaderState.getUniform(mgl_ColorEnabled))) {
            int n;
            int n2 = n = this.shaderState.isVertexAttribArrayEnabled("mgl_Color") ? 1 : 0;
            if (n != gLUniformData.intValue()) {
                gLUniformData.setData(n);
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
        }
        if (null != (gLUniformData = this.shaderState.getUniform(mgl_CullFace)) && this.cullFace != gLUniformData.intValue()) {
            gLUniformData.setData(this.cullFace);
            this.shaderState.uniform(gL2ES2, gLUniformData);
        }
        if (this.lightsEnabledDirty) {
            gLUniformData = this.shaderState.getUniform(mgl_LightsEnabled);
            if (null != gLUniformData) {
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
            this.lightsEnabledDirty = false;
        }
        if (this.textureCoordsEnabledDirty) {
            gLUniformData = this.shaderState.getUniform(mgl_TexCoordEnabled);
            if (null != gLUniformData) {
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
            this.textureCoordsEnabledDirty = false;
        }
        if (this.textureEnabled) {
            if (this.lightingEnabled) {
                this.shaderState.attachShaderProgram(gL2ES2, this.shaderProgramColorTextureLight);
            } else {
                this.shaderState.attachShaderProgram(gL2ES2, this.shaderProgramColorTexture);
            }
        } else if (this.lightingEnabled) {
            this.shaderState.attachShaderProgram(gL2ES2, this.shaderProgramColorLight);
        } else {
            this.shaderState.attachShaderProgram(gL2ES2, this.shaderProgramColor);
        }
    }

    public String toString() {
        return "FixedFuncPipeline[pmv: " + this.pmvMatrix + ", textureEnabled: " + this.textureEnabled + ", textureCoordsEnabled: " + this.textureCoordsEnabled + ", lightingEnabled: " + this.lightingEnabled + ", lightsEnabled: " + this.lightsEnabled + "\n\t, shaderProgramColor: " + this.shaderProgramColor + "\n\t, shaderProgramColorTexture: " + this.shaderProgramColorTexture + "\n\t, shaderProgramColorLight: " + this.shaderProgramColorLight + "\n\t, shaderProgramColorTextureLight: " + this.shaderProgramColorTextureLight + "\n\t, ShaderState: " + this.shaderState + "]";
    }

    protected void init(GL2ES2 gL2ES2, PMVMatrix pMVMatrix, Class clazz, String string, String string2, String string3, String string4, String string5, String string6) {
        if (null == pMVMatrix) {
            throw new GLException("PMVMatrix is null");
        }
        this.pmvMatrix = pMVMatrix;
        this.shaderState = new ShaderState();
        this.shaderState.setVerbose(this.verbose);
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, 1, clazz, string, string2, string3);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35633, 1, clazz, string, string2, string4);
        ShaderCode shaderCode3 = ShaderCode.create(gL2ES2, 35632, 1, clazz, string, string2, string5);
        ShaderCode shaderCode4 = ShaderCode.create(gL2ES2, 35632, 1, clazz, string, string2, string6);
        this.shaderProgramColor = new ShaderProgram();
        this.shaderProgramColor.add(shaderCode);
        this.shaderProgramColor.add(shaderCode3);
        if (!this.shaderProgramColor.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link VertexColor program: " + this.shaderProgramColor);
        }
        this.shaderProgramColorTexture = new ShaderProgram();
        this.shaderProgramColorTexture.add(shaderCode);
        this.shaderProgramColorTexture.add(shaderCode4);
        if (!this.shaderProgramColorTexture.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link VertexColorTexture program: " + this.shaderProgramColorTexture);
        }
        this.shaderProgramColorLight = new ShaderProgram();
        this.shaderProgramColorLight.add(shaderCode2);
        this.shaderProgramColorLight.add(shaderCode3);
        if (!this.shaderProgramColorLight.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link VertexColorLight program: " + this.shaderProgramColorLight);
        }
        this.shaderProgramColorTextureLight = new ShaderProgram();
        this.shaderProgramColorTextureLight.add(shaderCode2);
        this.shaderProgramColorTextureLight.add(shaderCode4);
        if (!this.shaderProgramColorTextureLight.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link VertexColorLight program: " + this.shaderProgramColorTextureLight);
        }
        this.shaderState.attachShaderProgram(gL2ES2, this.shaderProgramColor);
        this.shaderState.useProgram(gL2ES2, true);
        if (!this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_PMVMatrix, 4, 4, pMVMatrix.glGetPMvMvitMatrixf()))) {
            throw new GLException("Error setting PMVMatrix in shader: " + this);
        }
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ColorEnabled, 0));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ColorStatic, 4, zero4f));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_TexCoordEnabled, 1, this.textureCoordsEnabled));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ActiveTexture, this.activeTextureUnit));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ActiveTextureIdx, this.activeTextureUnit));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ShadeModel, 0));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_CullFace, this.cullFace));
        for (int i = 0; i < 8; ++i) {
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].ambient", 4, defAmbient));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].diffuse", 4, defDiffuse));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].specular", 4, defSpecular));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].position", 4, defPosition));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].spotDirection", 3, defSpotDir));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].spotExponent", 0.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].spotCutoff", 180.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].constantAttenuation", 1.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].linearAttenuation", 0.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + i + "].quadraticAttenuation", 0.0f));
        }
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_LightsEnabled, 1, this.lightsEnabled));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.ambient", 4, defMatAmbient));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.diffuse", 4, defMatDiffuse));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.specular", 4, defMatSpecular));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.emission", 4, defMatEmission));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.shininess", 0.0f));
        this.shaderState.useProgram(gL2ES2, false);
    }
}

