/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import jogamp.newt.driver.DriverUpdatePosition;

public class AWTParentWindowAdapter
extends AWTWindowAdapter
implements HierarchyListener {
    public AWTParentWindowAdapter(Window window) {
        super(window);
    }

    @Override
    public AWTAdapter addTo(Component component) {
        component.addHierarchyListener(this);
        return super.addTo(component);
    }

    @Override
    public AWTAdapter removeFrom(Component component) {
        component.removeHierarchyListener(this);
        return super.removeFrom(component);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        boolean bl;
        Window window = this.getNewtWindow();
        boolean bl2 = bl = window.isNativeValid() && window.getGraphicsConfiguration().getChosenCapabilities().isOnscreen();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusGained: onscreen " + bl + ", " + focusEvent);
        }
        if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
        window.requestFocus(false);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusLost: " + focusEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        final Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentResized: " + component);
        }
        this.getNewtWindow().runOnEDTIfAvail(false, new Runnable(){

            @Override
            public void run() {
                int n;
                int n2 = component.getWidth();
                if (0 < n2 * (n = component.getHeight())) {
                    if (AWTParentWindowAdapter.this.getNewtWindow().getWidth() != n2 || AWTParentWindowAdapter.this.getNewtWindow().getHeight() != n) {
                        AWTParentWindowAdapter.this.getNewtWindow().setSize(n2, n);
                        if (component.isVisible() != AWTParentWindowAdapter.this.getNewtWindow().isVisible()) {
                            AWTParentWindowAdapter.this.getNewtWindow().setVisible(component.isVisible());
                        }
                    }
                } else if (AWTParentWindowAdapter.this.getNewtWindow().isVisible()) {
                    AWTParentWindowAdapter.this.getNewtWindow().setVisible(false);
                }
            }
        });
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentMoved: " + componentEvent);
        }
        if (this.getNewtWindow().getDelegatedWindow() instanceof DriverUpdatePosition) {
            ((DriverUpdatePosition)((Object)this.getNewtWindow().getDelegatedWindow())).updatePosition();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (null == this.getNewtEventListener()) {
            boolean bl;
            long l = hierarchyEvent.getChangeFlags();
            Component component = hierarchyEvent.getChanged();
            if (0L != (4L & l)) {
                bl = component.isShowing();
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("AWT: hierarchyChanged SHOWING_CHANGED: showing " + bl + ", " + component + ", source " + hierarchyEvent.getComponent());
                }
                this.getNewtWindow().runOnEDTIfAvail(false, new Runnable(){

                    @Override
                    public void run() {
                        if (AWTParentWindowAdapter.this.getNewtWindow().isVisible() != bl) {
                            AWTParentWindowAdapter.this.getNewtWindow().setVisible(bl);
                        }
                    }
                });
            }
            if (DEBUG_IMPLEMENTATION && 0L != (2L & l)) {
                bl = component.isDisplayable();
                System.err.println("AWT: hierarchyChanged DISPLAYABILITY_CHANGED: displayability " + bl + ", " + component);
            }
        }
    }
}

