/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import com.jogamp.common.os.Platform;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTJNILibLoader;
import jogamp.nativewindow.jawt.JAWTToolkitLock;

public class JAWTUtil {
    protected static final boolean DEBUG = Debug.debug("JAWT");
    private static final boolean headlessMode;
    private static final JAWT jawtLockObject;
    private static final Method isQueueFlusherThread;
    private static final boolean j2dExist;
    private static final Method sunToolkitAWTLockMethod;
    private static final Method sunToolkitAWTUnlockMethod;
    private static final boolean hasSunToolkitAWTLock;
    private static final JAWTToolkitLock jawtToolkitLock;

    public static boolean isOffscreenLayerSupported() {
        return Platform.OS_TYPE == Platform.OSType.MACOS && Platform.OS_VERSION_NUMBER.compareTo((Object)JAWT.JAWT_MacOSXCALayerMinVersion) >= 0;
    }

    public static JAWT getJAWT(boolean bl) {
        int n = 65540;
        if (bl) {
            switch (Platform.OS_TYPE) {
                case MACOS: {
                    if (Platform.OS_VERSION_NUMBER.compareTo((Object)JAWT.JAWT_MacOSXCALayerMinVersion) < 0) break;
                    n |= Integer.MIN_VALUE;
                }
            }
        }
        return JAWT.getJAWT(n);
    }

    public static boolean isJAWTUsingOffscreenLayer(JAWT jAWT) {
        return 0 != (jAWT.getCachedVersion() & Integer.MIN_VALUE);
    }

    public static void initSingleton() {
    }

    public static boolean hasJava2D() {
        return j2dExist;
    }

    public static boolean isJava2DQueueFlusherThread() {
        boolean bl = false;
        if (j2dExist) {
            try {
                bl = (Boolean)isQueueFlusherThread.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHeadlessMode() {
        return headlessMode;
    }

    private static void awtLock() {
        if (hasSunToolkitAWTLock) {
            try {
                sunToolkitAWTLockMethod.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                throw new NativeWindowException("SunToolkit.awtLock failed", exception);
            }
        } else {
            jawtLockObject.Lock();
        }
    }

    private static void awtUnlock() {
        if (hasSunToolkitAWTLock) {
            try {
                sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                throw new NativeWindowException("SunToolkit.awtUnlock failed", exception);
            }
        } else {
            jawtLockObject.Unlock();
        }
    }

    public static void lockToolkit() throws NativeWindowException {
        if (!headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            JAWTUtil.awtLock();
        }
    }

    public static void unlockToolkit() {
        if (!headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            JAWTUtil.awtUnlock();
        }
    }

    public static JAWTToolkitLock getJAWTToolkitLock() {
        return jawtToolkitLock;
    }

    static {
        if (DEBUG) {
            System.err.println("JAWTUtil initialization (JAWT/JNI/...");
        }
        JAWTJNILibLoader.initSingleton();
        JAWTJNILibLoader.loadNativeWindow("awt");
        headlessMode = GraphicsEnvironment.isHeadless();
        boolean bl = false;
        Class<?> clazz = null;
        Method method = null;
        if (!headlessMode) {
            jawtLockObject = JAWTUtil.getJAWT(false);
            try {
                clazz = Class.forName("jogamp.opengl.awt.Java2D");
                method = clazz.getMethod("isQueueFlusherThread", null);
                bl = true;
            }
            catch (Exception exception) {}
        } else {
            jawtLockObject = null;
        }
        isQueueFlusherThread = method;
        j2dExist = bl;
        PrivilegedDataBlob1 privilegedDataBlob1 = (PrivilegedDataBlob1)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PrivilegedDataBlob1 privilegedDataBlob1 = new PrivilegedDataBlob1();
                try {
                    Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                    privilegedDataBlob1.sunToolkitAWTLockMethod = clazz.getDeclaredMethod("awtLock", new Class[0]);
                    privilegedDataBlob1.sunToolkitAWTLockMethod.setAccessible(true);
                    privilegedDataBlob1.sunToolkitAWTUnlockMethod = clazz.getDeclaredMethod("awtUnlock", new Class[0]);
                    privilegedDataBlob1.sunToolkitAWTUnlockMethod.setAccessible(true);
                    privilegedDataBlob1.ok = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return privilegedDataBlob1;
            }
        });
        sunToolkitAWTLockMethod = privilegedDataBlob1.sunToolkitAWTLockMethod;
        sunToolkitAWTUnlockMethod = privilegedDataBlob1.sunToolkitAWTUnlockMethod;
        boolean bl2 = false;
        if (privilegedDataBlob1.ok) {
            try {
                sunToolkitAWTLockMethod.invoke(null, (Object[])null);
                sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hasSunToolkitAWTLock = bl2;
        jawtToolkitLock = new JAWTToolkitLock();
        Map map = null;
        try {
            if (EventQueue.isDispatchThread()) {
                map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            } else {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                        if (null != map) {
                            arrayList.add(map);
                        }
                    }
                });
                map = arrayList.size() > 0 ? (Map)arrayList.get(0) : null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("JAWTUtil: Has sun.awt.SunToolkit.awtLock/awtUnlock " + hasSunToolkitAWTLock);
            System.err.println("JAWTUtil: Has Java2D " + j2dExist);
            System.err.println("JAWTUtil: Is headless " + headlessMode);
            int n = null != map ? map.size() : 0;
            System.err.println("JAWTUtil: AWT Desktop hints " + n);
        }
    }

    private static class PrivilegedDataBlob1 {
        Method sunToolkitAWTLockMethod;
        Method sunToolkitAWTUnlockMethod;
        boolean ok = false;

        PrivilegedDataBlob1() {
        }
    }
}

