/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.tt.engine;

import jogamp.graph.font.typecast.ot.Mnemonic;

public class Parser {
    private short[][] instructions = new short[3][];

    public int advanceIP(int n) {
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        ++n;
        if (64 == this.instructions[n2][n3]) {
            short s = this.instructions[n2][++n3];
            n += s + 1;
        } else if (65 == this.instructions[n2][n3]) {
            short s = this.instructions[n2][++n3];
            n += s * 2 + 1;
        } else if (176 == (this.instructions[n2][n3] & 0xF8)) {
            short s = (short)((this.instructions[n2][n3] & 7) + 1);
            n += s;
        } else if (184 == (this.instructions[n2][n3] & 0xF8)) {
            short s = (short)((this.instructions[n2][n3] & 7) + 1);
            n += s * 2;
        }
        return n;
    }

    public int getISLength(int n) {
        return this.instructions[n].length;
    }

    public short getOpcode(int n) {
        return this.instructions[n >> 16][n & 0xFFFF];
    }

    public short getPushCount(int n) {
        short s = this.instructions[n >> 16][n & 0xFFFF];
        if (64 == s || 65 == s) {
            return this.instructions[n >> 16][(n & 0xFFFF) + 1];
        }
        if (176 == (s & 0xF8) || 184 == (s & 0xF8)) {
            return (short)((s & 7) + 1);
        }
        return 0;
    }

    public int[] getPushData(int n) {
        int[] nArray;
        block5: {
            short s;
            int n2;
            int n3;
            int n4;
            block7: {
                block6: {
                    block4: {
                        n4 = this.getPushCount(n);
                        nArray = new int[n4];
                        n3 = n >> 16;
                        n2 = n & 0xFFFF;
                        s = this.instructions[n3][n2];
                        if (64 != s) break block4;
                        for (int i = 0; i < n4; ++i) {
                            nArray[i] = this.instructions[n3][n2 + i + 2];
                        }
                        break block5;
                    }
                    if (176 != (s & 0xF8)) break block6;
                    for (int i = 0; i < n4; ++i) {
                        nArray[i] = this.instructions[n3][n2 + i + 1];
                    }
                    break block5;
                }
                if (65 != s) break block7;
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = this.instructions[n3][n2 + i * 2 + 2] << 8 | this.instructions[n3][n2 + i * 2 + 3];
                }
                break block5;
            }
            if (184 != (s & 0xF8)) break block5;
            for (int i = 0; i < n4; ++i) {
                nArray[i] = this.instructions[n3][n2 + i * 2 + 1] << 8 | this.instructions[n3][n2 + i * 2 + 2];
            }
        }
        return nArray;
    }

    public int handleElse(int n) {
        while (this.instructions[n >> 16][n & 0xFFFF] != 89) {
            n = this.advanceIP(n);
        }
        return n;
    }

    public int handleIf(boolean bl, int n) {
        if (!bl) {
            while (this.instructions[n >> 16][n & 0xFFFF] != 27 && this.instructions[n >> 16][n & 0xFFFF] != 89) {
                n = this.advanceIP(n);
            }
        }
        return n;
    }

    public void setCvtProgram(short[] sArray) {
        this.instructions[1] = sArray;
    }

    public void setFontProgram(short[] sArray) {
        this.instructions[0] = sArray;
    }

    public void setGlyphProgram(short[] sArray) {
        this.instructions[2] = sArray;
    }

    public String toString() {
        int n;
        int[] nArray;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.instructions[0].length) {
            stringBuffer.append(Mnemonic.getMnemonic(this.getOpcode(n2)));
            if (this.getPushCount(n2) > 0) {
                nArray = this.getPushData(n2);
                for (n = 0; n < nArray.length; ++n) {
                    stringBuffer.append(" ").append(nArray[n]);
                }
            }
            stringBuffer.append("\n");
            n2 = this.advanceIP(n2);
        }
        stringBuffer.append("\n");
        n2 = 65536;
        while (n2 < (0x10000 | this.instructions[1].length)) {
            stringBuffer.append(Mnemonic.getMnemonic(this.getOpcode(n2)));
            if (this.getPushCount(n2) > 0) {
                nArray = this.getPushData(n2);
                for (n = 0; n < nArray.length; ++n) {
                    stringBuffer.append(" ").append(nArray[n]);
                }
            }
            stringBuffer.append("\n");
            n2 = this.advanceIP(n2);
        }
        stringBuffer.append("\n");
        n2 = 131072;
        while (n2 < (0x20000 | this.instructions[2].length)) {
            stringBuffer.append(Mnemonic.getMnemonic(this.getOpcode(n2)));
            if (this.getPushCount(n2) > 0) {
                nArray = this.getPushData(n2);
                for (n = 0; n < nArray.length; ++n) {
                    stringBuffer.append(" ").append(nArray[n]);
                }
            }
            stringBuffer.append("\n");
            n2 = this.advanceIP(n2);
        }
        return stringBuffer.toString();
    }
}

