/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.quadtree.generator;

import com.js.test.terra.area.chunks.provider.ChunkProvider;
import com.js.test.terra.area.quadtree.QuadTreeNode;
import com.js.test.terra.math.Vector3;

public class TestGenerator {
    public static QuadTreeNode generateQuadTree(int size, int chunkSize, Vector3 center, ChunkProvider theChunkProvider) {
        QuadTreeNode aReturnNode = new QuadTreeNode();
        int sizeD2 = size / 2;
        int sizeD2TS = sizeD2 * sizeD2;
        aReturnNode.center = center;
        aReturnNode.boundingBox = TestGenerator.getBoundingBox(size / 2, center);
        aReturnNode.boundingSphereRadius = (float)Math.sqrt(sizeD2TS + sizeD2TS + sizeD2TS) + 2.0f;
        if (size == chunkSize) {
            aReturnNode.isLeaf = true;
            aReturnNode.worldCoord = theChunkProvider.fromWorldToMegaChunk((int)center.x, (int)center.y, (int)center.z);
            aReturnNode.chunkCoord = theChunkProvider.fromWorldToChunkCoord((int)center.x, (int)center.y, (int)center.z);
        } else {
            aReturnNode.children = new QuadTreeNode[8];
            int i = 0;
            while (i < 8) {
                Vector3 centerForThisNode = TestGenerator.getCenter(i, center, size / 4);
                aReturnNode.children[i] = TestGenerator.generateQuadTree(size / 2, chunkSize, centerForThisNode, theChunkProvider);
                ++i;
            }
        }
        return aReturnNode;
    }

    public static Vector3 getCenter(int index, Vector3 oldCenter, int offset) {
        Vector3 aReturnVector = new Vector3(0.0, 0.0, 0.0);
        if (index == 0) {
            aReturnVector.x = oldCenter.x - (double)offset;
            aReturnVector.y = oldCenter.y + (double)offset;
            aReturnVector.z = oldCenter.z - (double)offset;
        } else if (index == 1) {
            aReturnVector.x = oldCenter.x + (double)offset;
            aReturnVector.y = oldCenter.y + (double)offset;
            aReturnVector.z = oldCenter.z - (double)offset;
        } else if (index == 2) {
            aReturnVector.x = oldCenter.x + (double)offset;
            aReturnVector.y = oldCenter.y - (double)offset;
            aReturnVector.z = oldCenter.z - (double)offset;
        } else if (index == 3) {
            aReturnVector.x = oldCenter.x - (double)offset;
            aReturnVector.y = oldCenter.y - (double)offset;
            aReturnVector.z = oldCenter.z - (double)offset;
        } else if (index == 4) {
            aReturnVector.x = oldCenter.x - (double)offset;
            aReturnVector.y = oldCenter.y + (double)offset;
            aReturnVector.z = oldCenter.z + (double)offset;
        } else if (index == 5) {
            aReturnVector.x = oldCenter.x + (double)offset;
            aReturnVector.y = oldCenter.y + (double)offset;
            aReturnVector.z = oldCenter.z + (double)offset;
        } else if (index == 6) {
            aReturnVector.x = oldCenter.x + (double)offset;
            aReturnVector.y = oldCenter.y - (double)offset;
            aReturnVector.z = oldCenter.z + (double)offset;
        } else if (index == 7) {
            aReturnVector.x = oldCenter.x - (double)offset;
            aReturnVector.y = oldCenter.y - (double)offset;
            aReturnVector.z = oldCenter.z + (double)offset;
        }
        return aReturnVector;
    }

    public static Vector3[] getBoundingBox(int offset, Vector3 center) {
        Vector3[] aReturnList = new Vector3[8];
        aReturnList[0] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[0].x = center.x - (double)offset;
        aReturnList[0].y = center.y + (double)offset;
        aReturnList[0].z = center.z - (double)offset;
        aReturnList[1] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[1].x = center.x + (double)offset;
        aReturnList[1].y = center.y + (double)offset;
        aReturnList[1].z = center.z - (double)offset;
        aReturnList[2] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[2].x = center.x + (double)offset;
        aReturnList[2].y = center.y - (double)offset;
        aReturnList[2].z = center.z - (double)offset;
        aReturnList[3] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[3].x = center.x - (double)offset;
        aReturnList[3].y = center.y - (double)offset;
        aReturnList[3].z = center.z - (double)offset;
        aReturnList[4] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[4].x = center.x - (double)offset;
        aReturnList[4].y = center.y + (double)offset;
        aReturnList[4].z = center.z + (double)offset;
        aReturnList[5] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[5].x = center.x + (double)offset;
        aReturnList[5].y = center.y + (double)offset;
        aReturnList[5].z = center.z + (double)offset;
        aReturnList[6] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[6].x = center.x + (double)offset;
        aReturnList[6].y = center.y - (double)offset;
        aReturnList[6].z = center.z + (double)offset;
        aReturnList[7] = new Vector3(0.0, 0.0, 0.0);
        aReturnList[7].x = center.x - (double)offset;
        aReturnList[7].y = center.y - (double)offset;
        aReturnList[7].z = center.z + (double)offset;
        return aReturnList;
    }
}

