/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.quadtree;

import com.js.test.engine.camera.Camera;
import com.js.test.terra.area.chunks.provider.impl.Coord;
import com.js.test.terra.math.Vector3;
import java.util.List;

public class QuadTreeNode {
    public boolean isLeaf = false;
    public Vector3 center;
    public Coord worldCoord;
    public Coord chunkCoord;
    public float boundingSphereRadius;
    public Vector3[] boundingBox;
    public QuadTreeNode[] children;
    public QuadTreeNode parent;
    public boolean isVisible = false;
    public boolean isEmpty = false;

    public boolean checkEmpty() {
        if (this.isLeaf) {
            return this.isEmpty;
        }
        QuadTreeNode[] quadTreeNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            QuadTreeNode aNode = quadTreeNodeArray[n2];
            if (!aNode.checkEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean checkVisibility() {
        if (this.isLeaf) {
            return this.isVisible;
        }
        QuadTreeNode[] quadTreeNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            QuadTreeNode aNode = quadTreeNodeArray[n2];
            if (aNode.checkVisibility()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int recursiveSearch(int rendered, Camera aCamera, List<QuadTreeNode> evaluateThese) {
        Vector3 cameraPos = new Vector3(aCamera.getX(), aCamera.getY(), aCamera.getZ());
        boolean evaluateChildren = false;
        if (!this.boundingBoxContainsPoint(cameraPos)) {
            int sphereCheck = aCamera.getFrustrum().containsSphere(this.center, this.boundingSphereRadius, this.isLeaf);
            if (sphereCheck == 0) {
                return rendered;
            }
            if (sphereCheck == 1) {
                evaluateChildren = true;
            }
        } else {
            evaluateChildren = true;
        }
        if (evaluateChildren) {
            int boxCheck = aCamera.getFrustrum().containsBox(this.boundingBox);
            if (boxCheck == 0) {
                return rendered;
            }
            if (boxCheck == 1) {
                evaluateChildren = true;
            }
            if (boxCheck == 2) {
                evaluateChildren = false;
            }
        }
        if ((this.children == null || this.children.length == 0) && this.isLeaf) {
            evaluateChildren = false;
        }
        if (!evaluateChildren) {
            this.render(evaluateThese);
        } else {
            QuadTreeNode[] quadTreeNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                QuadTreeNode aNode = quadTreeNodeArray[n2];
                aNode.recursiveSearch(rendered, aCamera, evaluateThese);
                ++n2;
            }
        }
        return rendered;
    }

    public int render(List<QuadTreeNode> evaluateThese) {
        if (!this.isLeaf) {
            if (this.children != null) {
                QuadTreeNode[] quadTreeNodeArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    QuadTreeNode aNode = quadTreeNodeArray[n2];
                    aNode.render(evaluateThese);
                    ++n2;
                }
            }
        } else {
            evaluateThese.add(this);
        }
        return 0;
    }

    public boolean boundingBoxContainsPoint(Vector3 point) {
        return point.x > this.boundingBox[0].x && point.x < this.boundingBox[1].x && point.y > this.boundingBox[0].y && point.y < this.boundingBox[2].y && point.z > this.boundingBox[0].z && point.z < this.boundingBox[4].z;
    }
}

