/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.item;

import com.js.test.terra.area.item.BaseItem;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BaseItemLoader {
    private static BaseItemLoader myInstance;
    private List<BaseItem> myItems;
    private Map<String, BaseItem> myNameToItemMap;
    private int myAmountOfItems;

    private BaseItemLoader() {
        try {
            Properties someBlockProperties = new Properties();
            FileInputStream fis = new FileInputStream(new File("data/items.properties"));
            someBlockProperties.load(fis);
            fis.close();
            this.myItems = new ArrayList<BaseItem>();
            this.myNameToItemMap = new HashMap<String, BaseItem>();
            boolean noMore = false;
            int count = 0;
            while (!noMore) {
                String aPropertyValue = someBlockProperties.getProperty("item." + count);
                String aPropertyName = "item." + count;
                if (aPropertyValue != null) {
                    String usagesProperty;
                    String name = aPropertyValue;
                    String asset = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".asset");
                    String fancyName = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".fancy_name");
                    String model = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".model");
                    String stackableProperty = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".stackable");
                    boolean isStackable = false;
                    if (stackableProperty != null && stackableProperty.length() > 0) {
                        isStackable = Boolean.parseBoolean(stackableProperty);
                    }
                    int usages = 9999;
                    if (!isStackable && (usagesProperty = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".usages")) != null && usagesProperty.length() > 0) {
                        usages = Integer.parseInt(usagesProperty);
                    }
                    BaseItem aNewItem = new BaseItem(name, fancyName, count, asset, model, usages, isStackable);
                    this.myItems.add(aNewItem);
                    this.myNameToItemMap.put(name, aNewItem);
                    ++count;
                    continue;
                }
                noMore = true;
            }
            this.myAmountOfItems = count;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BaseItemLoader getInstance() {
        if (myInstance == null) {
            myInstance = new BaseItemLoader();
            return myInstance;
        }
        return myInstance;
    }

    public List<BaseItem> getMyItems() {
        return this.myItems;
    }

    public void setMyItems(List<BaseItem> myItems) {
        this.myItems = myItems;
    }

    public Map<String, BaseItem> getMyNameToItemMap() {
        return this.myNameToItemMap;
    }

    public void setMyNameToItemMap(Map<String, BaseItem> myNameToItemMap) {
        this.myNameToItemMap = myNameToItemMap;
    }

    public int getMyAmountOfItems() {
        return this.myAmountOfItems;
    }

    public void setMyAmountOfItems(int myAmountOfItems) {
        this.myAmountOfItems = myAmountOfItems;
    }
}

