/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks.generators;

import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.generators.LightHolder;
import com.js.test.terra.area.chunks.generators.VoxelGenerator;
import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.math.PerlinNoise;
import java.util.List;
import java.util.Random;

public class AstroidGenerator
implements VoxelGenerator {
    @Override
    public void generate(int width, int height, int depth, int[] theData, List<LightHolder> lights) {
        int aMaxRandom = BlockLoader.getInstance().getMyAmountOfBlocksForTerrainGen();
        Block[] blockList = BlockLoader.getInstance().getMyBlocksForTerrainGenAsArray();
        PerlinNoise aNoise = new PerlinNoise();
        Random aRandom = new Random();
        System.out.println("Starting world generation");
        int i = 0;
        while (i < width) {
            System.out.println("World gen: " + (float)i / (float)width * 100.0f + "%");
            int j = height - 1;
            while (j >= 0) {
                int k = 0;
                while (k < depth) {
                    float aMultiplierFade = this.fadeFromCenter(i, j, k, width, height, depth, 1.0f);
                    int index = i + j * width + k * height * height;
                    aNoise.offset(1.0f, 0.0f, 0.0f);
                    double aNoiceVal = 0.0;
                    aNoiceVal = aNoise.turbulentNoise((float)i / (float)width, (float)j / (float)height, (float)k / (float)depth, 7);
                    aNoiceVal *= 10.0;
                    aNoiceVal *= (double)aMultiplierFade;
                    float fadeOfArea = 20.0f;
                    if ((float)j > (float)(height / 2) - fadeOfArea) {
                        float myBlend = 0.0f;
                        if (j < height / 2) {
                            myBlend = (fadeOfArea - ((float)j - ((float)height / 2.0f - fadeOfArea))) / fadeOfArea;
                        }
                        aNoise.offset(0.1f, 0.4f, 0.3f);
                        double aNewNoiceVal = aNoise.turbulentNoise((float)(i * 3) / (float)width, (float)(j * 3) / (float)height, (float)(k * 3) / (float)depth, 4);
                        aNewNoiceVal *= 2.5;
                        aNoiceVal = aNoiceVal * (double)myBlend + (aNewNoiceVal *= (double)aMultiplierFade) * (1.0 - (double)myBlend);
                    }
                    int aBlockId = 0x10000000;
                    if (aNoiceVal > 0.4) {
                        aNoise.offset(0.2f, 0.4f, 0.1f);
                        double aBlockNoise = aNoise.turbulentNoise((float)i / (float)width, (float)j / (float)height, (float)k / (float)depth, 7);
                        int aBlockIndex = Math.abs((int)Math.round(aBlockNoise *= 30.0)) + 1;
                        int aBlockToSet = blockList[aBlockIndex % aMaxRandom].getMyId();
                        if (BlockLoader.getInstance().isLightOrTransparent(aBlockToSet)) {
                            aBlockToSet += 0x10000000;
                        }
                        aBlockId = aBlockToSet;
                        int aRandomVal = aRandom.nextInt(500);
                        if (aRandomVal == 50 && j < height - 4 && theData[index + width] == 0x10000000 && theData[index + (width + width)] == 0x10000000 && theData[index + (width + width + width)] == 0x10000000) {
                            theData[index + width] = 3;
                            theData[index + (width + width)] = 3;
                            theData[index + (width + width + width)] = 0x10000016;
                            lights.add(new LightHolder(i, j + 3, k, BlockLoader.getInstance().getMyBlocksAsArray()[22]));
                        }
                    }
                    theData[index] = aBlockId;
                    ++k;
                }
                --j;
            }
            ++i;
        }
    }

    private float fadeFromCenter(int x, int y, int z, int width, int height, int depth, float threshold) {
        int w2 = width / 2;
        int h2 = height / 2;
        int d2 = depth / 2;
        int distX = x - w2;
        int distY = y - h2;
        int distZ = z - d2;
        double tlength = Math.sqrt(distX * distX + distY * distY + distZ * distZ);
        double flength = Math.sqrt(w2 * w2 + h2 * h2 + d2 * d2);
        double normalized = tlength * 1.5 / flength;
        return 1.0f - (float)normalized;
    }

    @Override
    public void generate(int mcx, int mcy, int mcz, int width, int height, int depth, int offsetW, int offsetH, int offsetD, Chunk theData, long theSeed) {
    }

    @Override
    public void createGenerationJob(Chunk theChunkToDo, int mcx, int mcy, int mcz, int width, int height, int depth, int offsetW, int offsetH, int offsetD, long theSeed) {
    }

    @Override
    public boolean isSpace(int mcx, int mcy, int mcz) {
        return true;
    }
}

