/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.GuiItemContainer;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.player.Player;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class InventoryOverlay
extends Overlay {
    private Player myPlayer;
    private GuiPanel myPanel;
    private GuiItemContainer myItemContainer;

    public InventoryOverlay(int sw, int sh, Player player) {
        super("inventory");
        this.myPlayer = player;
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        int tenOfSw = sw / 10;
        int tenOfSh = sh / 10;
        int itemSize = (sw - 2 * tenOfSw) / this.myPlayer.getMyInventory().getMyW();
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (sw - 2 * tenOfSw - itemSize * this.myPlayer.getMyInventory().getMyW()) / 2;
        this.myPanel = new GuiPanel(tenOfSw + offset, tenOfSh, sw - 2 * tenOfSw - offset * 2, itemSize * this.myPlayer.getMyInventory().getMyH(), new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myItemContainer = new GuiItemContainer(tenOfSw, tenOfSh, sw - 2 * tenOfSw, itemSize * this.myPlayer.getMyInventory().getMyH(), itemSize, offset, this.myPlayer.getMyInventory());
        this.myPanel.addComponent(this.myItemContainer);
    }

    @Override
    public void resize(int newW, int newH) {
        int tenOfSw = newW / 10;
        int tenOfSh = newH / 10;
        int itemSize = (newW - 2 * tenOfSw) / this.myPlayer.getMyInventory().getMyW();
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (newW - 2 * tenOfSw - itemSize * this.myPlayer.getMyInventory().getMyW()) / 2;
        this.myPanel.getBox().x = tenOfSw + offset;
        this.myPanel.getBox().y = tenOfSh;
        this.myPanel.getBox().w = newW - 2 * tenOfSw - offset * 2;
        this.myPanel.getBox().h = itemSize * this.myPlayer.getMyInventory().getMyH();
        this.myItemContainer.getBox().x = tenOfSw;
        this.myItemContainer.getBox().y = tenOfSh;
        this.myItemContainer.getBox().w = newW - 2 * tenOfSw;
        this.myItemContainer.getBox().h = itemSize * this.myPlayer.getMyInventory().getMyH();
        this.myItemContainer.setMyItemSize(itemSize);
        this.myItemContainer.setMyOffset(offset);
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        this.myPanel.render(theGl, theGlu);
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        this.myPanel.mouseMove(e);
    }

    @Override
    public void click(GuiMouseEvent e) {
        this.myPanel.click(e);
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        this.myPanel.mouseOver(e);
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.myPanel.mouseLeave(e);
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        this.myPanel.keyEvent(e);
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        this.myPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        this.myPanel.mouseReleased(e);
    }
}

