/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiBlockIcon;
import com.js.test.engine.gui.GuiButton;
import com.js.test.engine.gui.GuiCheckbox;
import com.js.test.engine.gui.GuiImage;
import com.js.test.engine.gui.GuiItemContainer;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiLabel;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiMouseListener;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.gui.impl.BlockMakerIconListener;
import com.js.test.engine.gui.impl.BlockMakerTabListener;
import com.js.test.engine.machines.BlockMakerConvertion;
import com.js.test.engine.player.BlockMaker;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class BlockMakerOverlay
extends Overlay
implements GuiMouseListener {
    private GuiPanel myPanel;
    private GuiItemContainer myItemContainer;
    private GuiItemContainer myProducedItemContainer;
    private GuiImage myPowerImage;
    private GuiButton myLeft;
    private GuiButton myRight;
    private GuiBlockIcon myBlockIcon;
    private GuiLabel myBlockLabel;
    private GuiButton myActiveToggle;
    private GuiButton myIncreseBlocks;
    private GuiButton myDecreaseBlocks;
    private GuiLabel myMakeAmountLabel;
    private GuiCheckbox myMakeInfiniteBox;
    private GuiPanel myChoosePanel;
    private List<GuiPanel> myChooserTabs;
    private List<GuiButton> myChooserButtons;
    private int myNewW;
    private int myNewH;
    private BlockMaker myBlockMaker;

    public BlockMakerOverlay(int sw, int sh) {
        super("blockmaker");
        this.setzIndex(10);
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        this.myNewW = sw;
        this.myNewH = sh;
        this.myPanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myProducedItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myPowerImage = new GuiImage(0, 0, 0, 0, "power_0");
        this.myLeft = new GuiButton(0, 0, 0, 0, "<", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myRight = new GuiButton(0, 0, 0, 0, ">", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myActiveToggle = new GuiButton(0, 0, 0, 0, "activate", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myBlockIcon = new GuiBlockIcon(0, 0, 0, 0, 0, "none");
        this.myBlockLabel = new GuiLabel(0, 0, 0, 0, "none", new Vector3(0.5, 0.5, 0.5));
        this.myMakeInfiniteBox = new GuiCheckbox(0, 0, 0, 0, false);
        this.myDecreaseBlocks = new GuiButton(0, 0, 0, 0, "<", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myIncreseBlocks = new GuiButton(0, 0, 0, 0, ">", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myMakeAmountLabel = new GuiLabel(0, 0, 0, 0, "0", new Vector3(0.5, 0.5, 0.5));
        this.myLeft.addMouseListener(this);
        this.myRight.addMouseListener(this);
        this.myActiveToggle.addMouseListener(this);
        this.myMakeInfiniteBox.addMouseListener(this);
        this.myDecreaseBlocks.addMouseListener(this);
        this.myIncreseBlocks.addMouseListener(this);
        this.myBlockIcon.addMouseListener(this);
        this.myPanel.addComponent(this.myItemContainer);
        this.myPanel.addComponent(this.myProducedItemContainer);
        this.myPanel.addComponent(this.myPowerImage);
        this.myPanel.addComponent(this.myBlockIcon);
        this.myPanel.addComponent(this.myActiveToggle);
        this.myPanel.addComponent(this.myBlockLabel);
        this.myPanel.addComponent(this.myMakeInfiniteBox);
        this.myPanel.addComponent(this.myDecreaseBlocks);
        this.myPanel.addComponent(this.myIncreseBlocks);
        this.myPanel.addComponent(this.myMakeAmountLabel);
        this.myChoosePanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myChooserButtons = new ArrayList<GuiButton>();
        this.myChooserTabs = new ArrayList<GuiPanel>();
        boolean isFirst = true;
        for (String aGroupName : BlockMakerConvertion.getInstance().getMyGroupConvertions().keySet()) {
            GuiPanel aNewPanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
            if (!isFirst) {
                aNewPanel.setVisible(false);
            } else {
                isFirst = false;
            }
            this.myChooserTabs.add(aNewPanel);
            GuiButton aNewButton = new GuiButton(0, 0, 0, 0, aGroupName, new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
            aNewButton.addMouseListener(new BlockMakerTabListener(aNewPanel, this.myChooserTabs));
            this.myChooserButtons.add(aNewButton);
            this.myChoosePanel.addComponent(aNewButton);
            this.myChoosePanel.addComponent(aNewPanel);
            for (Integer aBlockId : BlockMakerConvertion.getInstance().getMyGroupConvertions().get(aGroupName)) {
                Block aBlockToMake = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockId];
                GuiBlockIcon aBlockIcon = new GuiBlockIcon(0, 0, 0, 0, aBlockId, aBlockToMake.getMyName());
                aBlockIcon.addMouseListener(new BlockMakerIconListener(this, aBlockId));
                aNewPanel.addComponent(aBlockIcon);
            }
        }
    }

    @Override
    public void resize(int newW, int newH) {
        this.myNewW = newW;
        this.myNewH = newH;
    }

    public void newBlockMaker(BlockMaker theBlockMaker) {
        this.myBlockMaker = theBlockMaker;
        int tenOfSw = this.myNewW / 10;
        int tenOfSh = this.myNewH / 10;
        int itemSize = (this.myNewW - 4 * tenOfSw) / (this.myBlockMaker.getMyInventory().getMyW() * 2);
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (this.myNewW - 4 * tenOfSw - itemSize * this.myBlockMaker.getMyInventory().getMyW() * 2) / 2;
        this.myPanel.getBox().x = tenOfSw + offset;
        this.myPanel.getBox().y = tenOfSh * 6;
        this.myPanel.getBox().w = this.myNewW - 2 * tenOfSw - offset * 2;
        this.myPanel.getBox().h = itemSize * this.myBlockMaker.getMyInventory().getMyH();
        this.myPanel.setVisible(true);
        this.myItemContainer.setMyInventory(this.myBlockMaker.getMyInventory());
        this.myItemContainer.getBox().x = tenOfSw + offset;
        this.myItemContainer.getBox().y = tenOfSh * 6;
        this.myItemContainer.getBox().w = itemSize * this.myBlockMaker.getMyInventory().getMyW();
        this.myItemContainer.getBox().h = itemSize * this.myBlockMaker.getMyInventory().getMyH();
        this.myItemContainer.setMyItemSize(itemSize);
        this.myItemContainer.setMyOffset(0);
        this.myProducedItemContainer.setMyInventory(this.myBlockMaker.getMyProducedItems());
        this.myProducedItemContainer.getBox().x = this.myNewW - tenOfSw - offset - itemSize * this.myBlockMaker.getMyInventory().getMyW();
        this.myProducedItemContainer.getBox().y = tenOfSh * 6;
        this.myProducedItemContainer.getBox().w = itemSize * this.myBlockMaker.getMyInventory().getMyW();
        this.myProducedItemContainer.getBox().h = itemSize * this.myBlockMaker.getMyInventory().getMyH();
        this.myProducedItemContainer.setMyItemSize(itemSize);
        this.myProducedItemContainer.setMyOffset(0);
        String asset = "power_0";
        if (this.myBlockMaker.isPowered()) {
            asset = "power_" + this.myBlockMaker.getMyPowerLevel() % 5;
        }
        this.myPowerImage.setMyAsset(asset);
        this.myPowerImage.getBox().x = tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW() + tenOfSw / 2;
        this.myPowerImage.getBox().y = tenOfSh * 6;
        this.myPowerImage.getBox().w = tenOfSw;
        this.myPowerImage.getBox().h = tenOfSw / 4;
        this.myLeft.getBox().x = tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW();
        this.myLeft.getBox().y = (float)tenOfSh * 6.5f;
        this.myLeft.getBox().w = itemSize / 2;
        this.myLeft.getBox().h = itemSize;
        this.myRight.getBox().x = (float)(tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW()) + (float)itemSize * 1.5f;
        this.myRight.getBox().y = (float)tenOfSh * 6.5f;
        this.myRight.getBox().w = itemSize / 2;
        this.myRight.getBox().h = itemSize;
        this.myMakeInfiniteBox.getBox().x = (float)(tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW()) + (float)itemSize * 2.5f;
        this.myMakeInfiniteBox.getBox().y = (float)tenOfSh * 6.5f;
        this.myMakeInfiniteBox.getBox().w = itemSize / 2;
        this.myMakeInfiniteBox.getBox().h = itemSize / 2;
        this.myMakeInfiniteBox.setMyState(this.myBlockMaker.isMyMakeInfinite());
        this.myDecreaseBlocks.getBox().x = (float)(tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW()) + (float)itemSize * 2.5f;
        this.myDecreaseBlocks.getBox().y = (float)tenOfSh * 6.5f + (float)(itemSize / 2) + 6.0f;
        this.myDecreaseBlocks.getBox().w = itemSize / 2;
        this.myDecreaseBlocks.getBox().h = itemSize / 2;
        this.myMakeAmountLabel.getBox().x = (float)(tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW()) + (float)itemSize * 3.0f;
        this.myMakeAmountLabel.getBox().y = (float)tenOfSh * 6.5f + (float)(itemSize / 2) + 6.0f;
        this.myMakeAmountLabel.getBox().w = itemSize / 2;
        this.myMakeAmountLabel.getBox().h = itemSize / 2;
        this.myMakeAmountLabel.setMyText(Integer.toString(this.myBlockMaker.getMyMakeAmount()));
        this.myIncreseBlocks.getBox().x = (float)(tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW()) + (float)itemSize * 3.5f;
        this.myIncreseBlocks.getBox().y = (float)tenOfSh * 6.5f + (float)(itemSize / 2) + 6.0f;
        this.myIncreseBlocks.getBox().w = itemSize / 2;
        this.myIncreseBlocks.getBox().h = itemSize / 2;
        this.myBlockIcon.getBox().x = tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW() + itemSize / 2;
        this.myBlockIcon.getBox().y = (float)tenOfSh * 6.5f;
        this.myBlockIcon.getBox().w = itemSize;
        this.myBlockIcon.getBox().h = itemSize;
        Block aBlockToMake = BlockLoader.getInstance().getMyBlocksAsArray()[this.myBlockMaker.getMyBlockToMake()];
        if (this.myBlockMaker.getMyBlockToMake() != 0) {
            this.myBlockIcon.setMyBlockId(this.myBlockMaker.getMyBlockToMake());
            this.myBlockIcon.setMyName(aBlockToMake.getMyName());
        } else {
            this.myBlockIcon.setMyBlockId(0);
            this.myBlockIcon.setMyName("none");
        }
        this.myActiveToggle.getBox().x = tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW() + 20;
        this.myActiveToggle.getBox().y = tenOfSh * 8;
        this.myActiveToggle.getBox().w = tenOfSw * 2 - 40;
        this.myActiveToggle.getBox().h = tenOfSw / 4;
        if (this.myBlockMaker.isActivated()) {
            this.myActiveToggle.setMyText("stop");
        } else {
            this.myActiveToggle.setMyText("activate");
        }
        this.myBlockLabel.getBox().x = tenOfSw + offset + itemSize * this.myBlockMaker.getMyInventory().getMyW() + 20;
        this.myBlockLabel.getBox().y = (float)tenOfSh * 7.5f;
        this.myBlockLabel.getBox().w = tenOfSw * 2 - 40;
        this.myBlockLabel.getBox().h = tenOfSw / 4;
        if (this.myBlockMaker.getMyBlockToMake() != 0) {
            this.myBlockLabel.setMyText(aBlockToMake.getMyName());
        } else {
            this.myBlockLabel.setMyText("none");
        }
        this.myChoosePanel.getBox().x = tenOfSw + offset;
        this.myChoosePanel.getBox().y = tenOfSh * 6;
        this.myChoosePanel.getBox().w = this.myNewW - 2 * tenOfSw - offset * 2;
        this.myChoosePanel.getBox().h = itemSize * this.myBlockMaker.getMyInventory().getMyH();
        this.myChoosePanel.setVisible(false);
        int offsetW = 0;
        for (GuiButton aButton : this.myChooserButtons) {
            aButton.getBox().x = tenOfSw + offset + offsetW;
            aButton.getBox().y = tenOfSh * 6;
            aButton.getBox().w = aButton.getMyTextW() + 12;
            aButton.getBox().h = (float)tenOfSh * 0.3f;
            offsetW += aButton.getMyTextW() + 12 + 6;
        }
        for (GuiPanel aPanel : this.myChooserTabs) {
            aPanel.getBox().x = tenOfSw + offset;
            aPanel.getBox().y = (float)tenOfSh * 6.4f;
            aPanel.getBox().w = this.myNewW - 2 * tenOfSw - offset * 2;
            aPanel.getBox().h = (float)(itemSize * this.myBlockMaker.getMyInventory().getMyH()) - (float)tenOfSh * 0.4f;
            int index = 0;
            int row = 0;
            for (Component aComponent : aPanel.getMyComponents()) {
                aComponent.getBox().x = (float)(tenOfSw + offset) + (float)index * aPanel.getBox().w / 15.0f;
                aComponent.getBox().y = (float)tenOfSh * 6.4f + (float)row * aPanel.getBox().w / 15.0f;
                aComponent.getBox().w = aPanel.getBox().w / 15.0f;
                aComponent.getBox().h = aPanel.getBox().w / 15.0f;
                if (++index % 15 != 0) continue;
                index = 0;
                ++row;
            }
        }
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.myBlockMaker != null) {
            this.myMakeAmountLabel.setMyText(Integer.toString(this.myBlockMaker.getMyMakeAmount()));
        }
        if (this.myPanel.isVisible()) {
            this.myPanel.render(theGl, theGlu);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.render(theGl, theGlu);
        }
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseMove(e);
            this.myPanel.mouseOver(e);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.mouseMove(e);
            this.myChoosePanel.mouseOver(e);
        }
    }

    @Override
    public void click(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.click(e);
        } else {
            this.myChoosePanel.click(e);
        }
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseOver(e);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.mouseOver(e);
        }
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseLeave(e);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.mouseLeave(e);
        }
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.keyEvent(e);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.keyEvent(e);
        }
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mousePressed(e);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseReleased(e);
        }
        if (this.myChoosePanel.isVisible()) {
            this.myChoosePanel.mouseReleased(e);
        }
    }

    @Override
    public void click(GuiMouseEvent e, Component trigger) {
        if (trigger == this.myActiveToggle) {
            this.myBlockMaker.setActivated(!this.myBlockMaker.isActivated());
            if (this.myBlockMaker.isActivated()) {
                this.myActiveToggle.setMyText("stop");
            } else {
                this.myActiveToggle.setMyText("activate");
            }
        } else if (trigger == this.myLeft) {
            int[] makeableBlocks = BlockMakerConvertion.getInstance().getMakableBlocks();
            int anIndex = this.myBlockMaker.getMyIndex() - 1;
            if (anIndex < 0) {
                anIndex = makeableBlocks.length - 1;
            }
            this.myBlockMaker.setMyIndex(anIndex);
            if (anIndex > 0) {
                Block aBlockToMake = BlockLoader.getInstance().getMyBlocksAsArray()[makeableBlocks[anIndex]];
                this.myBlockMaker.setMyBlockToMake(makeableBlocks[anIndex]);
                this.myBlockIcon.setMyBlockId(aBlockToMake.getMyId());
                this.myBlockLabel.setMyText(aBlockToMake.getMyName());
            } else {
                this.myBlockLabel.setMyText("none");
                this.myBlockMaker.setMyBlockToMake(0);
                this.myBlockIcon.setMyBlockId(0);
            }
        } else if (trigger == this.myRight) {
            int[] makeableBlocks = BlockMakerConvertion.getInstance().getMakableBlocks();
            int anIndex = this.myBlockMaker.getMyIndex() + 1;
            if (anIndex >= makeableBlocks.length) {
                anIndex = 0;
            }
            this.myBlockMaker.setMyIndex(anIndex);
            if (anIndex > 0) {
                Block aBlockToMake = BlockLoader.getInstance().getMyBlocksAsArray()[makeableBlocks[anIndex]];
                this.myBlockMaker.setMyBlockToMake(makeableBlocks[anIndex]);
                this.myBlockIcon.setMyBlockId(makeableBlocks[anIndex]);
                this.myBlockLabel.setMyText(aBlockToMake.getMyName());
            } else {
                this.myBlockLabel.setMyText("none");
                this.myBlockMaker.setMyBlockToMake(0);
                this.myBlockIcon.setMyBlockId(0);
            }
        } else if (trigger == this.myMakeInfiniteBox) {
            this.myBlockMaker.setMyMakeInfinite(!this.myBlockMaker.isMyMakeInfinite());
            if (this.myBlockMaker.isMyMakeInfinite()) {
                this.myMakeInfiniteBox.setMyState(true);
            } else {
                this.myMakeInfiniteBox.setMyState(false);
            }
        } else if (trigger == this.myDecreaseBlocks) {
            if (this.myBlockMaker.getMyMakeAmount() > 0) {
                this.myBlockMaker.setMyMakeAmount(this.myBlockMaker.getMyMakeAmount() - 1);
                this.myMakeAmountLabel.setMyText(Integer.toString(this.myBlockMaker.getMyMakeAmount()));
            }
        } else if (trigger == this.myIncreseBlocks) {
            this.myBlockMaker.setMyMakeAmount(this.myBlockMaker.getMyMakeAmount() + 1);
            this.myMakeAmountLabel.setMyText(Integer.toString(this.myBlockMaker.getMyMakeAmount()));
        } else if (trigger == this.myBlockIcon) {
            this.myPanel.setVisible(false);
            this.myChoosePanel.setVisible(true);
        }
    }

    public void switchToBlock(int blockId) {
        Block aBlockToMake = BlockLoader.getInstance().getMyBlocksAsArray()[blockId];
        this.myBlockMaker.setMyBlockToMake(blockId);
        this.myBlockIcon.setMyBlockId(aBlockToMake.getMyId());
        this.myBlockIcon.setMyName(aBlockToMake.getMyName());
        this.myBlockLabel.setMyText(aBlockToMake.getMyName());
        this.myPanel.setVisible(true);
        this.myChoosePanel.setVisible(false);
    }
}

