/*
 * Decompiled with CFR 0.152.
 */
package com.js.test;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.awt.Screenshot;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.js.test.engine.camera.Camera;
import com.js.test.engine.camera.CameraHandler;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.gui.OverlayHandler;
import com.js.test.engine.gui.impl.BlockMakerOverlay;
import com.js.test.engine.gui.impl.ContainerOverlay;
import com.js.test.engine.gui.impl.GrinderOverlay;
import com.js.test.engine.gui.impl.HotbarOverlay;
import com.js.test.engine.gui.impl.InventoryOverlay;
import com.js.test.engine.gui.impl.ItemMakerOverlay;
import com.js.test.engine.gui.impl.MainMenuOverlay;
import com.js.test.engine.gui.impl.MetaValueOverlay;
import com.js.test.engine.input.Controls;
import com.js.test.engine.input.InputThread;
import com.js.test.engine.machines.MachineHandler;
import com.js.test.engine.material.TextureHandler;
import com.js.test.engine.player.Player;
import com.js.test.engine.text.TextEntry;
import com.js.test.engine.text.TextHandler;
import com.js.test.terra.area.QuadTreeRenderer;
import com.js.test.terra.area.animatedgenerator.AnimatedGeneratorHandler;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.chunks.generators.DemoGenerator;
import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.area.chunks.provider.ChunkProvider;
import com.js.test.terra.area.chunks.provider.MegaChunk;
import com.js.test.terra.area.chunks.provider.impl.ContiniousChunkProvider;
import com.js.test.terra.area.chunks.provider.impl.WorldSaver;
import com.js.test.terra.area.movables.ElevatorMovable;
import com.js.test.terra.area.movables.ExplodeMovable;
import com.js.test.terra.area.movables.GrowMovable;
import com.js.test.terra.area.movables.LightMovable;
import com.js.test.terra.area.movables.MegaGunMovable;
import com.js.test.terra.area.movables.Movable;
import com.js.test.terra.area.movables.MovableHandler;
import com.js.test.terra.area.movables.WormMovable;
import com.js.test.terra.area.quadtree.MegaQuadTreeContainer;
import com.js.test.terra.math.Vector3;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.gl2.GLUgl2;
import jouvieje.bass.Bass;
import jouvieje.bass.BassInit;
import jouvieje.bass.structures.HSTREAM;

public class Game
implements GLEventListener,
KeyListener,
MouseMotionListener,
MouseListener {
    public GLUgl2 glu = new GLUgl2();
    private GLCanvas canvas = new GLCanvas();
    private Frame frame = new Frame("Boxjesus");
    private Animator animator = new Animator((GLAutoDrawable)this.canvas);
    private Robot myRobot = null;
    public ChunkProvider myChunkProvider;
    public MegaQuadTreeContainer myMegaQuadTreeContainer;
    private long myStartTime;
    private long myLastGameTick;
    private Controls myMovement;
    public BigChunkDataGrid myGrid;
    private QuadTreeRenderer myTreeRenderer;
    public Player myPlayer;
    private int myFrameCount = 0;
    private boolean takeScreenshot = false;
    private TextRenderer myTextRenderer;
    private InputThread myInputThread;
    public GL2 gl;
    private int myScreenWidth;
    private int myScreenHeight;
    public boolean createNewGame = false;
    public int createNewGameSize = 256;
    public boolean loadGame = false;
    public String loadGameName = "";
    private HSTREAM str;
    private boolean firedGrowers = false;
    public double previousX;
    public double previousY;

    public Game() {
        this.canvas.addGLEventListener((GLEventListener)this);
        this.frame.add((Component)this.canvas);
        this.frame.setSize(1024, 768);
        this.frame.setUndecorated(true);
        this.frame.setExtendedState(6);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Game.this.exit();
            }
        });
        this.frame.setVisible(true);
        this.animator.start();
        this.canvas.requestFocus();
    }

    public void display(GLAutoDrawable gLDrawable) {
        if (this.myPlayer.isPlaying()) {
            this.doGameTick();
            this.myLastGameTick = System.currentTimeMillis();
            this.render();
            ++this.myFrameCount;
        } else {
            this.renderMainOverlay();
            if (this.createNewGame) {
                this.createNewGame = false;
                this.createNewGame();
            } else if (this.loadGame) {
                this.loadGame = false;
                this.loadGame();
            }
        }
    }

    private void loadGame() {
        HashMap<String, String> anInfoMap = WorldSaver.loadInfoAbout(this.loadGameName);
        int aSize = Integer.parseInt(anInfoMap.get("size"));
        this.myChunkProvider = new ContiniousChunkProvider(aSize, aSize, aSize, 32, new DemoGenerator(aSize), 1, "default");
        this.myChunkProvider.setMyMapName(this.loadGameName);
        this.myChunkProvider.loadMetadataRelated();
        this.myGrid = new BigChunkDataGrid(this.gl, (GLU)this.glu, this.myChunkProvider);
        this.myChunkProvider.addMetaDataRemovedListener(this.myGrid);
        this.myMegaQuadTreeContainer = new MegaQuadTreeContainer((float)CameraHandler.getInstance().getCamera("player").getX(), (float)CameraHandler.getInstance().getCamera("player").getY(), (float)CameraHandler.getInstance().getCamera("player").getZ(), this.myChunkProvider);
        MegaChunk aCenterMegaChunk = this.myChunkProvider.getMegaChunkAt(0, 0, 0);
        Camera aCamera = CameraHandler.getInstance().getCamera("player");
        int i = (int)aCamera.getY();
        while (i > -30) {
            if (this.myChunkProvider.getBlockAt((int)Math.round(aCamera.getX()), i - 2, (int)Math.round(aCamera.getZ())) > 0) {
                aCamera.setY(i);
                break;
            }
            --i;
        }
        OverlayHandler.getInstance().removeActiveOverlay("mainmenu");
        OverlayHandler.getInstance().addActiveOverlay("hotbar");
        this.myPlayer.setPlaying(true);
    }

    private void createNewGame() {
        int k;
        int j;
        this.myChunkProvider = new ContiniousChunkProvider(this.createNewGameSize, this.createNewGameSize, this.createNewGameSize, 16, new DemoGenerator(this.createNewGameSize), 1, "default");
        long seedAndName = System.currentTimeMillis();
        this.myChunkProvider.setMyMapName(Long.toString(seedAndName));
        this.myChunkProvider.setMySeed(seedAndName);
        this.myGrid = new BigChunkDataGrid(this.gl, (GLU)this.glu, this.myChunkProvider);
        this.myChunkProvider.addMetaDataRemovedListener(this.myGrid);
        this.myMegaQuadTreeContainer = new MegaQuadTreeContainer(0.0f, 0.0f, 0.0f, this.myChunkProvider);
        MegaChunk aCenterMegaChunk = this.myChunkProvider.getMegaChunkAt(0, 0, 0);
        int numberOfInited = 0;
        int count = 0;
        int i = 0;
        while (i < aCenterMegaChunk.myChunkListWidth) {
            j = aCenterMegaChunk.myChunkListHeight / 2 - 1;
            while (j < aCenterMegaChunk.myChunkListHeight) {
                k = 0;
                while (k < aCenterMegaChunk.myChunkListDepth) {
                    aCenterMegaChunk.getChunkAt(i, j, k);
                    ++count;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        while (numberOfInited < count) {
            numberOfInited = 0;
            i = 0;
            while (i < aCenterMegaChunk.myChunkListWidth) {
                j = aCenterMegaChunk.myChunkListHeight / 2 - 1;
                while (j < aCenterMegaChunk.myChunkListHeight) {
                    k = 0;
                    while (k < aCenterMegaChunk.myChunkListDepth) {
                        Chunk aChunk = aCenterMegaChunk.getChunkAt(i, j, k);
                        if (aChunk.isInitialized) {
                            ++numberOfInited;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        Camera aCamera = CameraHandler.getInstance().getCamera("player");
        int i2 = (int)aCamera.getY();
        while (i2 > -30) {
            if (this.myChunkProvider.getBlockAt((int)Math.round(aCamera.getX()), i2 - 2, (int)Math.round(aCamera.getZ())) > 0) {
                aCamera.setY(i2);
                break;
            }
            --i2;
        }
        OverlayHandler.getInstance().removeActiveOverlay("mainmenu");
        OverlayHandler.getInstance().addActiveOverlay("hotbar");
        this.myPlayer.setPlaying(true);
        Bass.BASS_ChannelPlay((int)this.str.asInt(), (boolean)false);
    }

    void orthogonalStart() {
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, (float)this.myScreenWidth, 0.0f, (float)this.myScreenHeight);
        this.gl.glScalef(1.0f, -1.0f, 1.0f);
        this.gl.glTranslatef(0.0f, (float)(-this.myScreenHeight), 0.0f);
        this.gl.glMatrixMode(5888);
        this.gl.glDisable(2929);
        this.gl.glDisable(3553);
        this.gl.glDisable(2884);
    }

    void orthogonalEnd() {
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glEnable(2929);
        this.gl.glEnable(3553);
        this.gl.glMatrixMode(5888);
    }

    private void renderGUI() {
        this.orthogonalStart();
        List<Overlay> someOverlays = OverlayHandler.getInstance().getActiveOverlays();
        Collections.sort(someOverlays);
        for (Overlay anOverlay : someOverlays) {
            anOverlay.render(this.gl, (GLU)this.glu);
        }
        this.orthogonalEnd();
    }

    private void render() {
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glClear(16384);
        this.gl.glClear(256);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glColor3f(1.0f, 1.0f, 1.0f);
        this.myTreeRenderer.renderNode(this.myMegaQuadTreeContainer, this.myGrid, (double)(System.currentTimeMillis() - this.myStartTime) / 1000.0, this.gl, (GLU)this.glu, this.myFrameCount);
        this.myTextRenderer.beginRendering(this.myScreenWidth, this.myScreenHeight);
        for (TextEntry anEntry : TextHandler.getInstance().getList()) {
            this.myTextRenderer.draw(anEntry.myText, anEntry.myX, this.myScreenHeight - anEntry.myY);
        }
        TextHandler.getInstance().clearList();
        this.myTextRenderer.endRendering();
        if (this.takeScreenshot) {
            try {
                Screenshot.writeToFile((File)new File("shit.png"), (int)1680, (int)1050);
            }
            catch (GLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.takeScreenshot = false;
        }
    }

    private void renderMainOverlay() {
    }

    private void renderItem(int itemId) {
        this.gl.glPushMatrix();
        this.gl.glDisable(2929);
        this.gl.glDepthMask(false);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glColorMask(true, true, true, true);
        Camera aCamera = CameraHandler.getInstance().getCamera("player");
        this.glu.gluLookAt(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        TextureHandler.getInstance().bindItemTexture(itemId, this.gl);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(0.0f, 1.0f);
        this.gl.glVertex3f(-0.2f, -0.2f, 1.2f);
        this.gl.glTexCoord2f(1.0f, 1.0f);
        this.gl.glVertex3f(-0.2f, -0.2f, 0.4f);
        this.gl.glTexCoord2f(1.0f, 0.0f);
        this.gl.glVertex3f(-0.2f, -0.5f, 0.4f);
        this.gl.glTexCoord2f(0.0f, 0.0f);
        this.gl.glVertex3f(-0.2f, -0.5f, 1.2f);
        this.gl.glEnd();
        TextureHandler.getInstance().unbindItemTexture(itemId, this.gl);
        this.gl.glDepthMask(true);
        this.gl.glEnable(2929);
        this.gl.glPopMatrix();
    }

    private void doGameTick() {
        this.handleAnimatedGenerators();
        long aStart = System.currentTimeMillis();
        this.handleMovables();
        this.handleDemoEffects();
        this.handleDemoCamera();
        this.handleKeys();
        this.myGrid.rebuildVBOsFromList(this.gl, (GLU)this.glu);
    }

    private void handleMachines() {
        MachineHandler.getInstance().handleMachineTick(this.myChunkProvider, this.myGrid, this.myPlayer, this.gl, (GLU)this.glu);
    }

    private void handleGameOverlays() {
        if (this.myPlayer.isInInventoryStateChange()) {
            this.myPlayer.setInInventoryStateChange(false);
            if (this.myPlayer.isInInventory()) {
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                this.showCursor(this.frame);
                this.myRobot.mouseMove(this.frame.getWidth() / 2, this.frame.getHeight() / 2);
            } else {
                OverlayHandler.getInstance().removeActiveOverlay("inventory");
                OverlayHandler.getInstance().removeActiveOverlay("container");
                OverlayHandler.getInstance().removeActiveOverlay("grinder");
                OverlayHandler.getInstance().removeActiveOverlay("blockmaker");
                OverlayHandler.getInstance().removeActiveOverlay("itemmaker");
                OverlayHandler.getInstance().removeActiveOverlay("metavalue");
                this.hideCursor(this.frame);
            }
        }
        if (this.myPlayer.isInMenuStateChange()) {
            this.myPlayer.setInMenuStateChange(false);
            if (this.myPlayer.isInMenu()) {
                MainMenuOverlay anMenu = (MainMenuOverlay)OverlayHandler.getInstance().getOverlay("mainmenu");
                anMenu.reset();
                OverlayHandler.getInstance().addActiveOverlay("mainmenu");
                this.showCursor(this.frame);
                this.myRobot.mouseMove(this.frame.getWidth() / 2, this.frame.getHeight() / 2);
            } else {
                OverlayHandler.getInstance().removeActiveOverlay("mainmenu");
                this.hideCursor(this.frame);
            }
        }
    }

    private void handleMovables() {
        long now = System.currentTimeMillis();
        long timeSinceLastTick = now - this.myLastGameTick;
        double normalized = (float)timeSinceLastTick / 1000.0f;
        float amount = (float)normalized;
        MovableHandler.getInstance().doTicks(amount, this.myGrid, this.gl, (GLU)this.glu);
    }

    private void handleDemoEffects() {
        double random;
        long now = System.currentTimeMillis();
        Camera myCamera = CameraHandler.getInstance().getCamera("emitter");
        Camera myCamera2 = CameraHandler.getInstance().getCamera("emitter2");
        Camera myCamera3 = CameraHandler.getInstance().getCamera("painter");
        long runTime = now - this.myStartTime;
        Random aRandom = new Random();
        if (runTime < 60000L && now - this.myPlayer.getMyLastLeftUsageTime() > 200L) {
            Movable myMovable;
            this.myPlayer.setMyLastLeftUsageTime(now);
            random = aRandom.nextDouble();
            int aType = aRandom.nextInt(100);
            if (aType < 40) {
                myMovable = new MegaGunMovable(new Vector3(myCamera.getX(), myCamera.getY(), myCamera.getZ()), new Vector3(myCamera.getVx() * 50.0, (myCamera.getVy() + (random * 0.8 - 0.4)) * 50.0, myCamera.getVz() * 50.0), 0.0f, 6.0f, true, 0);
                MovableHandler.getInstance().addMovable(myMovable);
            } else if (aType < 60) {
                myMovable = new GrowMovable(new Vector3(myCamera.getX(), myCamera.getY(), myCamera.getZ()), new Vector3(myCamera.getVx() * 50.0, (myCamera.getVy() + (random * 0.8 - 0.4)) * 50.0, myCamera.getVz() * 50.0), 0.0f, 6.0f, true, 0, 12);
                MovableHandler.getInstance().addMovable(myMovable);
            } else if (aType < 90) {
                myMovable = new ElevatorMovable(new Vector3(myCamera.getX(), myCamera.getY(), myCamera.getZ()), new Vector3(myCamera.getVx() * 50.0, (myCamera.getVy() + (random * 0.8 - 0.4)) * 50.0, myCamera.getVz() * 50.0), 0.0f, 6.0f, true, 0, 12);
                MovableHandler.getInstance().addMovable(myMovable);
            } else {
                myMovable = new LightMovable(new Vector3(myCamera.getX(), myCamera.getY(), myCamera.getZ()), new Vector3(myCamera.getVx() * 50.0, (myCamera.getVy() + (random * 0.8 - 0.4)) * 50.0, myCamera.getVz() * 50.0), 0.0f, 6.0f, true, 0);
                MovableHandler.getInstance().addMovable(myMovable);
            }
            aType = aRandom.nextInt(100);
            if (aType < 30) {
                myMovable = new MegaGunMovable(new Vector3(myCamera2.getX(), myCamera2.getY(), myCamera2.getZ()), new Vector3((myCamera2.getVx() + (random - 0.5)) * 50.0, myCamera2.getVy() * 50.0, myCamera2.getVz() * 50.0), 0.0f, 6.0f, true, 0);
                MovableHandler.getInstance().addMovable(myMovable);
            } else if (aType < 50) {
                myMovable = new GrowMovable(new Vector3(myCamera2.getX(), myCamera2.getY(), myCamera2.getZ()), new Vector3((myCamera2.getVx() + (random * 0.8 - 0.4)) * 50.0, myCamera2.getVy() * 50.0, myCamera2.getVz() * 50.0), 0.0f, 6.0f, true, 0, 12);
                MovableHandler.getInstance().addMovable(myMovable);
            } else if (aType < 70) {
                myMovable = new ElevatorMovable(new Vector3(myCamera2.getX(), myCamera2.getY(), myCamera2.getZ()), new Vector3((myCamera2.getVx() + (random - 0.5)) * 50.0, myCamera2.getVy() * 50.0, myCamera2.getVz() * 50.0), 0.0f, 6.0f, true, 0, 12);
                MovableHandler.getInstance().addMovable(myMovable);
            } else {
                myMovable = new LightMovable(new Vector3(myCamera2.getX(), myCamera2.getY(), myCamera2.getZ()), new Vector3((myCamera2.getVx() + (random - 0.5)) * 50.0, myCamera2.getVy() * 50.0, myCamera2.getVz() * 50.0), 0.0f, 6.0f, true, 17);
                MovableHandler.getInstance().addMovable(myMovable);
            }
            myMovable = new MegaGunMovable(new Vector3(myCamera3.getX(), myCamera3.getY(), myCamera3.getZ()), new Vector3(myCamera3.getVx() * 50.0, (myCamera3.getVy() + (random * 0.8 - 0.4)) * 50.0, myCamera3.getVz() * 50.0), 0.0f, 6.0f, true, 0);
            MovableHandler.getInstance().addMovable(myMovable);
        }
        if (runTime > 60000L) {
            if (now - this.myPlayer.getMyLastLeftUsageTime() > 100L) {
                this.myPlayer.setMyLastLeftUsageTime(now);
                random = aRandom.nextDouble();
                double random2 = aRandom.nextDouble();
                int aType = aRandom.nextInt(100);
                if (aType < 80) {
                    ExplodeMovable myMovable = new ExplodeMovable(new Vector3(myCamera2.getX(), myCamera2.getY(), myCamera2.getZ()), new Vector3((myCamera2.getVx() + (random - 0.5)) * 50.0, myCamera2.getVy() * 50.0, (myCamera2.getVz() + (random2 - 0.5)) * 50.0), 0.0f, 6.0f, true, 0);
                    MovableHandler.getInstance().addMovable(myMovable);
                    ExplodeMovable myMovable2 = new ExplodeMovable(new Vector3(myCamera.getX(), myCamera.getY(), myCamera.getZ()), new Vector3((myCamera.getVx() + (random2 - 0.5)) * 50.0, (myCamera.getVy() + (random - 0.5)) * 50.0, myCamera.getVz() * 50.0), 0.0f, 6.0f, true, 0);
                    MovableHandler.getInstance().addMovable(myMovable2);
                } else {
                    LightMovable myMovable = new LightMovable(new Vector3(myCamera.getX(), myCamera.getY(), myCamera.getZ()), new Vector3(myCamera.getVx() * 50.0, (myCamera.getVy() + (random * 0.8 - 0.4)) * 50.0, myCamera.getVz() * 50.0), 0.0f, 6.0f, true, 21);
                    MovableHandler.getInstance().addMovable(myMovable);
                    LightMovable myMovable2 = new LightMovable(new Vector3(myCamera2.getX(), myCamera2.getY(), myCamera2.getZ()), new Vector3((myCamera2.getVx() + (random * 0.8 - 0.4)) * 50.0, myCamera2.getVy() * 50.0, myCamera2.getVz() * 50.0), 0.0f, 6.0f, true, 21);
                    MovableHandler.getInstance().addMovable(myMovable2);
                }
            }
            if (runTime > 60000L && runTime < 80000L) {
                TextHandler.getInstance().addEntry(new TextEntry("Now when these things begin to happen, look up and lift", 50, this.myScreenHeight - 100));
                TextHandler.getInstance().addEntry(new TextEntry("up your heads, because your redemption draws near", 50, this.myScreenHeight - 50));
            }
            if (runTime > 80000L && runTime < 100000L) {
                TextHandler.getInstance().addEntry(new TextEntry("But take heed to yourselves, lest your hearts be weighed", 50, this.myScreenHeight - 150));
                TextHandler.getInstance().addEntry(new TextEntry("down with carousing, drunkenness, and cares of this life,", 50, this.myScreenHeight - 100));
                TextHandler.getInstance().addEntry(new TextEntry("and that Day come on you unexpectedly.", 50, this.myScreenHeight - 50));
            }
            if (runTime > 100000L && runTime < 120000L) {
                TextHandler.getInstance().addEntry(new TextEntry("\"I want to be a horse's full toilet\"", 50, this.myScreenHeight - 100));
                TextHandler.getInstance().addEntry(new TextEntry("-JESUS", 50, this.myScreenHeight - 50));
            }
            if (runTime > 120000L && runTime < 140000L) {
                TextHandler.getInstance().addEntry(new TextEntry("PROOF:", 50, this.myScreenHeight - 150));
                TextHandler.getInstance().addEntry(new TextEntry("The Lord Himself will come partway to the earth to call us.", 50, this.myScreenHeight - 100));
                TextHandler.getInstance().addEntry(new TextEntry("The Lord Himself will airlift us to safety. ", 50, this.myScreenHeight - 50));
            }
            if (runTime > 140000L && runTime < 160000L) {
                TextHandler.getInstance().addEntry(new TextEntry("\"Ronald Reagan is number one best USA president ever\"", 50, this.myScreenHeight - 100));
                TextHandler.getInstance().addEntry(new TextEntry("-Most people", 50, this.myScreenHeight - 50));
            }
            if (runTime > 160000L) {
                TextHandler.getInstance().addEntry(new TextEntry("Timothy 2:12", 100, this.myScreenHeight - 150));
                TextHandler.getInstance().addEntry(new TextEntry("Peter 3", 100, this.myScreenHeight - 100));
                TextHandler.getInstance().addEntry(new TextEntry("AMC", 100, this.myScreenHeight - 50));
            }
        }
        if (runTime > 182000L) {
            System.exit(0);
        }
        if (runTime > 10000L && !this.firedGrowers) {
            WormMovable myMovable1 = new WormMovable(new Vector3(150.0, 0.0, 0.0), new Vector3(-5.0, 0.0, 0.0), 0.0f, 26.0f, true, 0, 1, 0);
            MovableHandler.getInstance().addMovable(myMovable1);
            WormMovable myMovable2 = new WormMovable(new Vector3(-150.0, 0.0, 0.0), new Vector3(5.0, 0.0, 0.0), 0.0f, 26.0f, true, 0, -1, 0);
            MovableHandler.getInstance().addMovable(myMovable2);
            WormMovable myMovable3 = new WormMovable(new Vector3(0.0, 0.0, 150.0), new Vector3(0.0, 0.0, -5.0), 0.0f, 26.0f, true, 0, 0, 1);
            MovableHandler.getInstance().addMovable(myMovable3);
            WormMovable myMovable4 = new WormMovable(new Vector3(0.0, 0.0, -150.0), new Vector3(0.0, 0.0, 5.0), 0.0f, 26.0f, true, 0, 0, -1);
            MovableHandler.getInstance().addMovable(myMovable4);
            this.firedGrowers = true;
        }
        TextHandler.getInstance().addEntry(new TextEntry("BOXJESUS", 100, 100));
    }

    private void handleDemoCamera() {
        long now = System.currentTimeMillis();
        long timeSinceLastTick = now - this.myStartTime;
        double normalized = (float)timeSinceLastTick / 1000.0f;
        double distofs = Math.sin(normalized * 0.2) * 30.0 + 30.0;
        double x = Math.sin(normalized * 0.05) * (220.0 + distofs);
        double z = Math.cos(normalized * 0.05) * (220.0 + distofs);
        double vx = Math.sin(normalized * 0.05 + 3.14159);
        double vz = Math.cos(normalized * 0.05 + 3.14159);
        CameraHandler.getInstance().getCamera("player").setVx(vx);
        CameraHandler.getInstance().getCamera("player").setVy(0.0);
        CameraHandler.getInstance().getCamera("player").setVz(vz);
        CameraHandler.getInstance().getCamera("player").setRotX(normalized * 0.2 * 57.295827908797776 + 180.0);
        CameraHandler.getInstance().getCamera("player").setX(x);
        CameraHandler.getInstance().getCamera("player").setY(0.0);
        CameraHandler.getInstance().getCamera("player").setZ(z);
        double xe = Math.sin((normalized + 2.0) * 0.05) * 220.0;
        double ze = Math.cos((normalized + 2.0) * 0.05) * 220.0;
        double vxe = Math.sin((normalized + 2.0) * 0.05 + 3.14159);
        double vze = Math.cos((normalized + 2.0) * 0.05 + 3.14159);
        CameraHandler.getInstance().getCamera("emitter").setVx(vxe);
        CameraHandler.getInstance().getCamera("emitter").setVy(0.0);
        CameraHandler.getInstance().getCamera("emitter").setVz(vze);
        CameraHandler.getInstance().getCamera("emitter").setX(xe);
        CameraHandler.getInstance().getCamera("emitter").setY(0.0);
        CameraHandler.getInstance().getCamera("emitter").setZ(ze);
        double ye2 = Math.sin((normalized + 2.0) * 0.2) * 220.0;
        double ze2 = Math.cos((normalized + 2.0) * 0.2) * 220.0;
        double vye2 = Math.sin((normalized + 2.0) * 0.2 + 3.14159);
        double vze2 = Math.cos((normalized + 2.0) * 0.2 + 3.14159);
        CameraHandler.getInstance().getCamera("emitter2").setVx(0.0);
        CameraHandler.getInstance().getCamera("emitter2").setVy(vye2);
        CameraHandler.getInstance().getCamera("emitter2").setVz(vze2);
        CameraHandler.getInstance().getCamera("emitter2").setX(0.0);
        CameraHandler.getInstance().getCamera("emitter2").setY(ye2);
        CameraHandler.getInstance().getCamera("emitter2").setZ(ze2);
        double xe3 = Math.sin((normalized + 2.0) * 0.3) * 220.0;
        double ze3 = Math.cos((normalized + 2.0) * 0.3) * 220.0;
        double vxe3 = Math.sin((normalized + 2.0) * 0.3 + 3.14159);
        double vze3 = Math.cos((normalized + 2.0) * 0.3 + 3.14159);
        CameraHandler.getInstance().getCamera("painter").setVx(vxe3);
        CameraHandler.getInstance().getCamera("painter").setVy(0.0);
        CameraHandler.getInstance().getCamera("painter").setVz(vze3);
        CameraHandler.getInstance().getCamera("painter").setX(xe3);
        CameraHandler.getInstance().getCamera("painter").setY(0.0);
        CameraHandler.getInstance().getCamera("painter").setZ(ze3);
    }

    private void handleAnimatedGenerators() {
        long now = System.currentTimeMillis();
        long timeSinceLastTick = now - this.myLastGameTick;
        double normalized = (float)timeSinceLastTick / 1000.0f;
        float amount = (float)normalized;
        AnimatedGeneratorHandler.getInstance().doTicks(this.gl, (GLU)this.glu, amount, this.myGrid);
    }

    private void handleKeys() {
        long now = System.currentTimeMillis();
        long timeSinceLastMove = now - this.myLastGameTick;
        double normalized = (float)timeSinceLastMove / 1000.0f;
        double myMoveSpeed = 5.0;
        if (this.myPlayer.isAllowYMove()) {
            myMoveSpeed = 10.0;
        }
        double withSpeed = normalized * myMoveSpeed;
        float gravityAmount = (float)withSpeed / 5.0f;
        boolean iMoved = false;
        double moveAmount = 0.0;
        double strafeAmount = 0.0;
        if (iMoved) {
            this.myPlayer.move(moveAmount, strafeAmount, this.myGrid, gravityAmount, withSpeed);
        }
        if (!iMoved && !this.myPlayer.isAllowYMove()) {
            this.myPlayer.move(withSpeed, 0.0, this.myGrid, gravityAmount, withSpeed);
        }
        if (this.myMovement.escPressed) {
            System.exit(0);
        }
        this.myPlayer.unsetDirection();
    }

    private void handleCamera() {
        if (!this.myPlayer.isInInventory()) {
            if (this.previousY >= 89.0) {
                this.previousY = 89.0;
            }
            if (this.previousY <= -89.0) {
                this.previousY = -89.0;
            }
            if (this.previousX < 0.0) {
                this.previousX += 360.0;
            }
            if (this.previousX > 360.0) {
                this.previousX -= 360.0;
            }
            Vector3 rotatedX = Vector3.rotateVector(new Vector3(0.0, 0.0, 1.0), new Vector3(1.0, 0.0, 0.0), this.previousY);
            rotatedX.normalize();
            Vector3 rotatedBoth = Vector3.rotateVector(rotatedX, new Vector3(0.0, 1.0, 0.0), -this.previousX);
            rotatedBoth.normalize();
            CameraHandler.getInstance().getCamera("player").setVx(rotatedBoth.x);
            CameraHandler.getInstance().getCamera("player").setVy(rotatedBoth.y);
            CameraHandler.getInstance().getCamera("player").setVz(rotatedBoth.z);
            CameraHandler.getInstance().getCamera("player").setRotX(this.previousX);
            CameraHandler.getInstance().getCamera("player").setRotY(this.previousY);
        }
    }

    public void displayChanged(GLAutoDrawable gLDrawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void init(GLAutoDrawable gLDrawable) {
        this.gl = gLDrawable.getGL().getGL2();
        this.gl.setSwapInterval(1);
        this.gl.glShadeModel(7425);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glClearDepth(1.0);
        this.gl.glEnable(2929);
        this.gl.glDepthFunc(515);
        this.gl.glHint(3152, 4354);
        ((Component)gLDrawable).addKeyListener(this);
        ((Component)gLDrawable).addMouseMotionListener(this);
        ((Component)gLDrawable).addMouseListener(this);
        TextureHandler.getInstance();
        TextureHandler.getInstance().setupTextureDefaultValues(this.gl);
        TextureHandler.getInstance().readTerrainTexturesFromProperties(this.gl, (GLU)this.glu);
        TextureHandler.getInstance().readItemTexturesFromProperties(this.gl, (GLU)this.glu);
        this.myTextRenderer = new TextRenderer(new Font("SansSerif", 0, 38));
        TextHandler.getInstance().setMyTextRenderer(this.myTextRenderer);
        this.myPlayer = new Player(CameraHandler.getInstance().getCamera("player"), true, 256, this.gl, (GLU)this.glu);
        this.myTreeRenderer = new QuadTreeRenderer(this.gl, (GLU)this.glu);
        MainMenuOverlay aMainOverlay = new MainMenuOverlay(600, 500, this.myPlayer, this);
        InventoryOverlay aInvOverlay = new InventoryOverlay(600, 500, this.myPlayer);
        HotbarOverlay aHotOverlay = new HotbarOverlay(600, 500, this.myPlayer);
        GrinderOverlay aGrinderOverlay = new GrinderOverlay(600, 500);
        BlockMakerOverlay aMakerOverlay = new BlockMakerOverlay(600, 500);
        ItemMakerOverlay aItemMakerOverlay = new ItemMakerOverlay(600, 500);
        ContainerOverlay aContainerOverlay = new ContainerOverlay(600, 500);
        MetaValueOverlay aMetaValueOverlay = new MetaValueOverlay(600, 500);
        OverlayHandler.getInstance().addOverlay(aMainOverlay);
        OverlayHandler.getInstance().addOverlay(aInvOverlay);
        OverlayHandler.getInstance().addOverlay(aHotOverlay);
        OverlayHandler.getInstance().addOverlay(aGrinderOverlay);
        OverlayHandler.getInstance().addOverlay(aMakerOverlay);
        OverlayHandler.getInstance().addOverlay(aItemMakerOverlay);
        OverlayHandler.getInstance().addOverlay(aContainerOverlay);
        OverlayHandler.getInstance().addOverlay(aMetaValueOverlay);
        OverlayHandler.getInstance().addActiveOverlay(aMainOverlay.getName());
        this.showCursor(this.frame);
        this.myMovement = new Controls();
        this.myInputThread = new InputThread(this, this.myMovement, this.myPlayer);
        this.myInputThread.start();
        this.myLastGameTick = this.myStartTime = System.currentTimeMillis();
        this.createNewGameSize = 256;
        this.createNewGame = true;
        BassInit.loadLibraries();
        Bass.BASS_Init((int)-1, (int)44100, (int)0, null, null);
        File music = new File("assets/music/invasion.mp3");
        this.str = Bass.BASS_StreamCreateFile((boolean)false, (String)music.getPath(), (long)0L, (long)0L, (int)0);
        try {
            this.myRobot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void reshape(GLAutoDrawable gLDrawable, int x, int y, int width, int height) {
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(50.0, (double)h, (double)0.2f, 256.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.myScreenWidth = width;
        this.myScreenHeight = height;
        OverlayHandler.getInstance().resizeOverlays(this.myScreenWidth, this.myScreenHeight);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void exit() {
        this.animator.stop();
        this.frame.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        new Game();
    }

    public void dispose(GLAutoDrawable gLDrawable) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (Overlay anActiveOverlay : OverlayHandler.getInstance().getActiveOverlays()) {
            if (anActiveOverlay == null) continue;
            GuiMouseEvent aNewEvent = new GuiMouseEvent(e.getX(), e.getY(), "none", 0);
            anActiveOverlay.mouseMove(aNewEvent);
        }
    }

    public void hideCursor(Frame frame) {
        int w = 1;
        int h = 1;
        int[] pix = new int[w * h];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w));
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "custom");
        frame.setCursor(cursor);
    }

    public void showCursor(Frame frame) {
        int w = 1;
        int h = 1;
        int[] pix = new int[w * h];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w));
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "custom");
        frame.setCursor(cursor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (Overlay anActiveOverlay : OverlayHandler.getInstance().getActiveOverlays()) {
            if (anActiveOverlay == null) continue;
            GuiMouseEvent aNewEvent = new GuiMouseEvent(e.getX(), e.getY(), Integer.toString(e.getButton()), 1);
            anActiveOverlay.click(aNewEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (Overlay anActiveOverlay : OverlayHandler.getInstance().getActiveOverlays()) {
            if (anActiveOverlay == null) continue;
            GuiMouseEvent aNewEvent = new GuiMouseEvent(e.getX(), e.getY(), Integer.toString(e.getButton()), 1);
            anActiveOverlay.mousePressed(aNewEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (Overlay anActiveOverlay : OverlayHandler.getInstance().getActiveOverlays()) {
            if (anActiveOverlay == null) continue;
            GuiMouseEvent aNewEvent = new GuiMouseEvent(e.getX(), e.getY(), Integer.toString(e.getButton()), 1);
            anActiveOverlay.mouseReleased(aNewEvent);
        }
        if (OverlayHandler.getInstance().getMyDraggable() != null) {
            OverlayHandler.getInstance().getMyDraggable().notHandeled();
            OverlayHandler.getInstance().setMyDraggable(null);
        }
    }
}

