/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLEventList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MultiQueueBarrier {
    private CountDownLatch latch;
    private final Set<CLCommandQueue> queues;
    private final int count;

    public MultiQueueBarrier(int queueCount) {
        if (queueCount == 0) {
            throw new IllegalArgumentException("queueCount was 0");
        }
        this.latch = new CountDownLatch(queueCount);
        this.queues = null;
        this.count = queueCount;
    }

    public MultiQueueBarrier(CLCommandQueue ... allowedQueues) {
        if (allowedQueues.length == 0) {
            throw new IllegalArgumentException("allowedQueues was empty");
        }
        this.latch = new CountDownLatch(allowedQueues.length);
        this.count = allowedQueues.length;
        HashSet<CLCommandQueue> set = new HashSet<CLCommandQueue>(allowedQueues.length);
        for (CLCommandQueue queue : allowedQueues) {
            set.add(queue);
        }
        this.queues = Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiQueueBarrier waitFor(CLCommandQueue queue) {
        this.checkQueue(queue);
        queue.putBarrier();
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            this.latch.countDown();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiQueueBarrier waitFor(CLCommandQueue queue, CLEventList events) {
        this.checkQueue(queue);
        queue.putWaitForEvents(events, true);
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            this.latch.countDown();
        }
        return this;
    }

    public MultiQueueBarrier await() throws InterruptedException {
        this.latch.await();
        this.rebuildBarrierIfBroken();
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = this.latch.await(timeout, unit);
        this.rebuildBarrierIfBroken();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBarrier() {
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            this.latch = new CountDownLatch(this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildBarrierIfBroken() {
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            if (this.latch.getCount() == 0L) {
                this.latch = new CountDownLatch(this.count);
            }
        }
    }

    public long getCount() {
        return this.latch.getCount();
    }

    private void checkQueue(CLCommandQueue queue) throws IllegalArgumentException {
        if (this.queues != null && !this.queues.contains(queue)) {
            throw new IllegalArgumentException(queue + " is not in the allowedQueues Set: " + this.queues);
        }
    }
}

