//VERTEX

#version 330

in layout(location = 0) vec3 Vertex;
in layout(location = 2) vec2 Uv;

out vec2 uv;
out vec3 vertex;

void main()
{
	uv = Uv;
	vertex = Vertex;
	gl_Position = vec4(Vertex,1.0);
}

//FRAGMENT

#version 330
#extension GL_ARB_shading_language_420pack : enable


layout(binding=0) uniform sampler2D diffuseMap;
layout(binding=1) uniform sampler2D vertexMap;
layout(binding=2) uniform sampler2D normalMap;


uniform float u_Timer;
uniform vec2 u_Resolution;

out vec4 Color;
in vec2 uv;
in vec3 vertex;


#define STEPS 60.0
#define FARZ  1.0
const float totStrength = 1.38;
const float strength = 0.0003;
const float offset = 200.0;
const float falloff = 0.001;
const float rad = 0.02;
#define SAMPLES 10;
const float invSamples = -1.38/10.0;
const float zFar = 5.0;

float noise(vec2 pos,float seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}

float udBox( vec3 p, vec3 b ) {
  return length(max(abs(p)-b,0.0));
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}



float obj(vec3 p) {	
	
	vec3 c = vec3(5.0,5.0,5.0);
	p = mod(p,c)-(0.5*c);
	return udBox(p,vec3(1.0));
}

vec4 castRay(vec3 origin, vec3 dir) {


	float i;
	float totalDistance = 0.0;
	float distance;
	vec3 p;
	float angley = 0;
	float anglez = 0;


	for(i=0.0;i<STEPS;i+=1.0) {

		p = origin + (totalDistance*dir);
		
		distance = obj(p);

		totalDistance += distance;

		if(distance < 0.0)
			break;
	}


	vec3 eps = vec3(.001,0.0,0.0);
	vec3 n = vec3(obj(p+eps.xyy) - obj(p-eps.xyy),obj(p+eps.yxy) - obj(p-eps.yxy),obj(p+eps.yyx) - obj(p-eps.yyx));
	n = normalize(n);
	return vec4(n,1.0-(totalDistance/STEPS));
}

void main()
{
	//lolz big array
	vec3 pSphere[10] = vec3[](vec3(-0.010735935, 0.01647018, 0.0062425877),vec3(-0.06533369, 0.3647007, -0.13746321),vec3(-0.6539235, -0.016726388, -0.53000957),vec3(0.40958285, 0.0052428036, -0.5591124),vec3(-0.1465366, 0.09899267, 0.15571679),vec3(-0.44122112, -0.5458797, 0.04912532),vec3(0.03755566, -0.10961345, -0.33040273),vec3(0.019100213, 0.29652783, 0.066237666),vec3(0.8765323, 0.011236004, 0.28265962),vec3(0.29264435, -0.40794238, 0.15964167));


	vec3 ReflectNormal;

	ReflectNormal.x = noise(uv*180.0,1232.0)*2.0;
	ReflectNormal.y = noise(uv*180.0,12431.0)*2.0;
	ReflectNormal.z = noise(uv*180.0,12122.0)*2.0;

	ReflectNormal = normalize(ReflectNormal);

	vec3 InNormal = texture2D(normalMap,uv).xyz;
	
	float Depth = texture2D(vertexMap,uv).y/zFar;

	float radD = rad/Depth;

	vec3 FragCoord3D = vec3(uv,Depth);


	float OccluderDepth,DepthDifference;
	vec4 OccluderFragment;
	vec3 Ray;
	float bl = 0.0;
	int i;

	for(i=0;i<10;i++)
	{
		Ray = radD*reflect(pSphere[i],ReflectNormal);

		OccluderFragment = texture2D(normalMap,uv + sign(dot(Ray,InNormal))*Ray.xy);
		float OccluderDepth = texture2D(vertexMap,uv + sign(dot(Ray,InNormal))*Ray.xy).y;

		DepthDifference = Depth - (OccluderDepth/zFar);

		bl += step(falloff,DepthDifference)*(1.0-dot(OccluderFragment.xyz,InNormal))*(1.0-smoothstep(falloff,strength,DepthDifference));

	}


	float FadeMult = 0.5*(uv.x*2.0-1.0);
	Color.xyz = vec3(0.88,0.159,0.2416)*0.6 * (1.0-abs(FadeMult));	
	Color.xyz *= 1.0+bl*invSamples;

	Color.a = 1.0;

	//RAYMARCHING!!!
	if(texture2D(diffuseMap,uv).xyz == vec3(0.0))
	{
		vec3 origin,dir;
		vec3 pos = vertex;
		
		origin.x = (vertex.x/2000.0) + u_Timer * 10.0;
		origin.y = (vertex.y/900.0);		
		origin.z = -10.0 - u_Timer;
		
		vec3 ww = normalize(vec3(0.0,0.9,0.0) - origin);
		vec3 uu = normalize(cross(vec3(0.0,1.0,0.0),ww));
		vec3 vv = normalize(cross(ww,uu));
		
		dir.x = 0.0;
		dir.y = 0.0;
		dir.z = 1.0;
		
		dir = normalize(pos.x*uu+pos.y*vv + 1.5*ww);
		
		vec4 n = castRay(origin,dir);
		vec3 lightPos=vec3(0.0,0.0,0.0);
		vec3 lightDir=normalize(vec3(-sin(u_Timer),cos(u_Timer)*2.0,5.0*sin(u_Timer)));
		
		float intensity = dot(n.xyz,lightDir);
		
		Color.xyz = vec3(0.05418,0.0321,0.119);
		//Diffuse		
		Color.xyz += (intensity * vec3(0.5,0.5,0.5));	
		
		Color.xyz *= n.a;
		Color.xyz *= 0.9;
	
		if(n.a < 0.1)
			Color.xyz *= 0.0;
	}


	Color.xyz = vec3(1.0) - Color.xyx;
	Color.z = Color.y;
	Color.xyz *= Color.xyz * 0.8;

	if(texture2D(diffuseMap,uv).xy == vec2(1.0,0.5))
		Color.xyz = vec3(1.0,1.0,1.0);
	
	

	if(u_Timer > 76.5)
	{
		float fade = u_Timer-76.5;
		fade *= 2.0;
		if(uv.y < fade)
			Color.xyz = vec3(0.0);
	}


}

//END
