//VERTEX
#version 330

in layout(location = 0) vec3 Vertex;
in layout(location = 2) vec2 Uv;

out vec2 uv;

void main()
{
	uv = Uv;
	gl_Position = vec4(Vertex,1.0);
}


//FRAGMENT
#version 330

#extension GL_ARB_shading_language_420pack : enable

float noisef(vec2 pos,int seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}

layout(binding=0) uniform sampler2D blurMap;
layout(binding=1) uniform sampler2D colorMap;

const float blurSize = 1.0/1024.0;

out layout(location=0) vec4 Color;

in vec2 uv;

void main(void) {
	float bloomFactor= 2.0;
	float brightMax= 1.0;
	float noise = 1.0;
	float warp = 0.0;
	float exposure = 0.8;

	vec2 offset = vec2(0,0);

	vec4 n;

	//if(noise > 0) {
	//	n.x = noisef(vec2(timer+uv.t,uv.s),32);
	//	n.zy = vec2(n.x,n.x);
	//	n*=noise*0.1;
	//}

	
	if(warp > 0) {
		offset.x = sin(uv.t*10)*0.01*warp;
		offset.y =  sin(uv.s*10)*0.01*warp;
	}
	
	vec2 st = uv.st+offset;
	vec4 color = texture2D(colorMap, st);
	vec4 colorBloom = texture2D(blurMap, st);

	color += colorBloom * bloomFactor;

	float Y = dot(vec4(0.30, 0.59, 0.11, 0.0), color);
	float YD = exposure * (exposure/brightMax + 1.0) / (exposure + 1.0);
	color *= YD;
	Color = color+n;
}
//END
