/*
 * Decompiled with CFR 0.152.
 */
package manakeri.Zombicalypse;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import manakeri.Zombicalypse.City;
import manakeri.Zombicalypse.GameLoopUI;
import manakeri.Zombicalypse.TGame;
import manakeri.Zombicalypse.Zombies;

public class GameLoop
implements Screen,
InputProcessor {
    private static int WIDTH = 21;
    private static int HEIGHT = 22;
    private static final int THRESHOLD = 250;
    private static final int TARGET_TIME = 5500;
    private static final int Z_START = 50;
    private PerspectiveCamera cam;
    private City city;
    private final GameLoopUI UI;
    private final SpriteBatch batch;
    private GL20 gl;
    private long counter_start = System.currentTimeMillis();
    private long target_start = System.currentTimeMillis();
    private long start_time;
    private long ct;
    private boolean targeting = false;
    private static final Plane xzPlane = new Plane(new Vector3(0.0f, 1.0f, 0.0f), 0.0f);
    private final Vector3 intersection = new Vector3();
    private final Vector3 curr = new Vector3();
    private final Vector3 last = new Vector3(-1.0f, -1.0f, -1.0f);
    private final Vector3 delta = new Vector3();
    private final Vector2 target = new Vector2();
    private Boolean running = true;
    private Zombies zombies;
    private final float[] x = new float[360];
    private final float[] z = new float[360];
    private final float[] vertices = new float[1080];
    private final Mesh points = new Mesh(false, 1080, 0, new VertexAttribute(0, 3, "a_position"));
    private float explosion_delta;
    private boolean exploding = false;
    private String s_start_time;
    private String s_target_start;

    public GameLoop() {
        this.UI = new GameLoopUI();
        this.batch = new SpriteBatch();
        int i = 0;
        while (i < 360) {
            this.x[i] = (float)Math.sin((float)i * 0.01745f) * 2.5f;
            this.z[i] = (float)Math.cos((float)i * 0.01745f) * 2.5f;
            ++i;
        }
    }

    private void checkTargeting(float delta2) {
        if (this.targeting && this.ct - this.target_start >= 5500L) {
            this.explosion_delta = 0.0f;
            this.exploding = true;
            if (TGame.prefs.getBoolean("effects")) {
                int expsnd = TGame.rand.nextInt(4);
                TGame.snd_explosion[expsnd].play(TGame.prefs.getFloat("volume"));
                Gdx.input.vibrate(250);
            }
            this.targeting = false;
        }
        if (this.exploding) {
            int vi = 0;
            this.explosion_delta += delta2;
            int i = 0;
            while (i < 360) {
                this.vertices[i] = 0.0f;
                ++i;
            }
            if (this.explosion_delta < 0.75f) {
                i = 0;
                while (i < 360) {
                    float ox = this.target.x + 0.5f + this.explosion_delta * this.x[i];
                    float oz = this.target.y + 0.5f + this.explosion_delta * this.z[i];
                    if (this.city.isRoad(ox / (float)this.city.getWidth(), oz / (float)this.city.getHeight())) {
                        this.zombies.checkHit(this.city, (int)ox, (int)oz);
                        this.vertices[vi++] = ox;
                        this.vertices[vi++] = 0.1f;
                        this.vertices[vi++] = oz;
                    } else {
                        this.vertices[vi++] = 0.0f;
                        this.vertices[vi++] = 0.0f;
                        this.vertices[vi++] = 0.0f;
                    }
                    i += 2;
                }
                this.points.setVertices(this.vertices);
            } else {
                this.exploding = false;
            }
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.UI.dispose();
    }

    private void drawUI(float delta2) {
        this.s_start_time = String.format("%1$TM:%1$TS", this.ct - this.start_time);
        this.s_target_start = "0";
        if (this.targeting) {
            this.s_target_start = Long.toString((5500L - (this.ct - this.target_start)) / 1000L);
        }
        this.UI.draw(this.gl, delta2, this.zombies.amount(), this.s_start_time, this.s_target_start);
    }

    @Override
    public void hide() {
    }

    private void init_city() {
        this.city = new City(WIDTH, HEIGHT);
        this.zombies = new Zombies(this.city, 50);
        this.zombies.init(this.cam);
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 44: {
                this.running = this.running == false;
                break;
            }
            case 4: 
            case 131: {
                TGame.game.setScreen(TGame.mainmenu);
                break;
            }
            case 244: {
                break;
            }
            case 43: 
            case 82: {
                TGame.previous_screen = TGame.gameloop;
                TGame.game.setScreen(TGame.options);
            }
        }
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean mouseMoved(int x, int y) {
        return false;
    }

    @Override
    public void pause() {
        TGame.prefs.flush();
        this.running = false;
    }

    @Override
    public void render(float delta) {
        if (this.running.booleanValue()) {
            this.gl.glClear(16640);
            this.cam.update();
            this.city.draw(this.cam);
            this.zombies.draw(this.cam, delta);
            this.ct = System.currentTimeMillis();
            this.checkTargeting(delta);
            if (this.exploding) {
                TGame.colshader.begin();
                TGame.colshader.setUniformMatrix("u_worldView", this.cam.combined);
                Gdx.gl.glEnable(2929);
                this.points.render(TGame.colshader, 0);
                Gdx.gl.glDisable(2929);
                TGame.colshader.end();
            }
            this.drawUI(delta);
            if (TGame.prefs.getBoolean("effects") && (this.ct - this.start_time) / 1000L % 25L == 0L && TGame.rand.nextInt(20) == 9) {
                TGame.snd_zombie[TGame.rand.nextInt(4)].play(TGame.prefs.getFloat("volume") * 0.25f);
            }
        }
    }

    @Override
    public void resize(int width, int height) {
        this.gl.glViewport(0, 0, width, height);
        float unitsOnX = (float)Math.sqrt(2.0) * (float)width / ((float)width * 0.15f);
        float pixelsOnX = (float)width / unitsOnX;
        float unitsOnY = (float)height / pixelsOnX;
        this.cam = new PerspectiveCamera(45.0f, unitsOnX, unitsOnY);
        this.cam.position.set(0.0f, 15.0f, 0.0f);
        this.cam.near = 1.0f;
        this.cam.far = 100.0f;
        this.cam.lookAt(WIDTH / 2, 0.0f, HEIGHT / 2);
        this.cam.update();
        this.UI.resize(width, height);
        this.init_city();
        this.start_time = System.currentTimeMillis();
    }

    @Override
    public void resume() {
        this.running = true;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public void show() {
        this.gl = Gdx.graphics.getGL20();
        Gdx.input.setInputProcessor(this);
        this.gl.glClearDepthf(1.0f);
        this.gl.glDepthFunc(515);
        switch ((int)TGame.prefs.getFloat("quality")) {
            case 1: {
                this.gl.glDisable(3024);
                break;
            }
        }
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        this.counter_start = System.currentTimeMillis();
        return false;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        Intersector.intersectRayPlane(this.cam.getPickRay(x, y), xzPlane, this.curr);
        if (this.last.x != -1.0f || this.last.y != -1.0f || this.last.z != -1.0f) {
            Intersector.intersectRayPlane(this.cam.getPickRay(this.last.x, this.last.y), xzPlane, this.delta);
            this.delta.sub(this.curr);
            this.cam.position.add(this.delta.x, 0.0f, this.delta.z);
            this.cam.lookAt(WIDTH / 2, 0.0f, HEIGHT / 2);
        }
        if (this.cam.position.x < -8.5f) {
            this.cam.position.x = -8.5f;
        }
        if (this.cam.position.z < -8.5f) {
            this.cam.position.z = -8.5f;
        }
        if (this.cam.position.x > 30.0f) {
            this.cam.position.x = 30.0f;
        }
        if (this.cam.position.z > 30.0f) {
            this.cam.position.z = 30.0f;
        }
        this.cam.update();
        this.last.set(x, y, 0.0f);
        return true;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        this.last.set(-1.0f, -1.0f, -1.0f);
        if (System.currentTimeMillis() - this.counter_start < 250L) {
            Intersector.intersectRayPlane(this.cam.getPickRay(Gdx.input.getX(), Gdx.input.getY()), xzPlane, this.intersection);
            int ix = (int)this.intersection.x;
            int iy = (int)this.intersection.y;
            int iz = (int)this.intersection.z;
            if (ix >= 0 && ix < WIDTH && iz >= 0 && iz < HEIGHT && iy == 0 && !this.exploding && !this.targeting && this.city.getTile(ix, iz) >= 128) {
                this.target_start = System.currentTimeMillis();
                this.targeting = true;
                this.target.x = ix;
                this.target.y = iz;
            }
        }
        this.counter_start = System.currentTimeMillis();
        return true;
    }
}

