/*
 * Decompiled with CFR 0.152.
 */
package manakeri.Zombicalypse;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteCache;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import manakeri.Zombicalypse.TGame;

public class City {
    private int[][] grid;
    private final int _width;
    private final int _height;
    private Mesh houses;
    private final Texture tex;
    private final SpriteCache scache;
    private final int cacheID;
    private static int _numVertices;
    private int road_tiles;
    private boolean _initialized = false;

    public static int getnumVertices() {
        return _numVertices;
    }

    public City(int width, int height) {
        this._width = width;
        this._height = height;
        this.build();
        Sprite[] sprite = new Sprite[]{TGame.atlas.createSprite("road1"), TGame.atlas.createSprite("road2"), TGame.atlas.createSprite("road3")};
        this.scache = new SpriteCache(width * height, true);
        this.scache.beginCache();
        int x = 0;
        while (x < this._width) {
            int y = 0;
            while (y < this._height) {
                int tile = this.grid[x][y];
                if (tile >= 128) {
                    Sprite sp = sprite[tile - 128];
                    sp.setBounds(x, y, 1.0f, 1.0f);
                    this.scache.add(sp);
                }
                ++y;
            }
            ++x;
        }
        this.cacheID = this.scache.endCache();
        Matrix4 matrix = new Matrix4();
        matrix.setToRotation(new Vector3(1.0f, 0.0f, 0.0f), 90.0f);
        this.scache.setTransformMatrix(matrix);
        this.generateVA();
        this.tex = new Texture("data/img/house.png");
        this._initialized = true;
    }

    private void build() {
        this.road_tiles = 0;
        this.grid = new int[this._width][this._height];
        int x = 0;
        while (x < this._width) {
            int y = 0;
            while (y < this._height) {
                if (x == 0 || y == 0 || x == this._width - 1 || y == this._height - 1) {
                    this.grid[x][y] = TGame.rand.nextInt(3);
                } else if (x % 4 == 0 && y % 3 == 0) {
                    this.grid[x][y] = 128;
                    ++this.road_tiles;
                } else if (x % 4 == 0) {
                    this.grid[x][y] = 129;
                    ++this.road_tiles;
                } else if (y % 3 == 0) {
                    this.grid[x][y] = 130;
                    ++this.road_tiles;
                } else {
                    this.grid[x][y] = TGame.rand.nextInt(TGame.house.length);
                }
                ++y;
            }
            ++x;
        }
    }

    public void dispose() {
        this.scache.dispose();
        this.tex.dispose();
    }

    public void draw(Camera cam) {
        Gdx.gl.glEnable(2929);
        Gdx.gl.glEnable(2884);
        this.tex.bind();
        TGame.texshader.begin();
        TGame.texshader.setUniformi("u_texture", 0);
        TGame.texshader.setUniformMatrix("u_worldView", cam.combined);
        this.houses.render(TGame.texshader, 4);
        TGame.texshader.end();
        this.scache.setProjectionMatrix(cam.combined);
        this.scache.begin();
        this.scache.draw(this.cacheID);
        this.scache.end();
        Gdx.gl.glDisable(2929);
        Gdx.gl.glDisable(2884);
    }

    private void generateVA() {
        int house_vertices = 0;
        int x = 0;
        while (x < this._width) {
            int y = 0;
            while (y < this._height) {
                if (this.grid[x][y] < 128) {
                    StillSubMesh[] stillSubMeshArray = TGame.house[this.grid[x][y]].subMeshes;
                    int n = TGame.house[this.grid[x][y]].subMeshes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StillSubMesh mesh = stillSubMeshArray[n2];
                        house_vertices += mesh.mesh.getNumVertices();
                        ++n2;
                    }
                }
                ++y;
            }
            ++x;
        }
        this.houses = new Mesh(true, house_vertices * 8, 0, TGame.house[0].subMeshes[0].mesh.getVertexAttributes());
        float[] vertices = new float[house_vertices * 8];
        int vi = 0;
        int x2 = 0;
        while (x2 < this._width) {
            int z = 0;
            while (z < this._height) {
                if (this.grid[x2][z] < 128) {
                    float[] buf = new float[TGame.house[this.grid[x2][z]].subMeshes[0].mesh.getNumVertices() * 8];
                    TGame.house[this.grid[x2][z]].subMeshes[0].mesh.getVertices(buf);
                    int i = 0;
                    while (i < buf.length) {
                        vertices[vi++] = buf[i++] + (float)x2;
                        vertices[vi++] = buf[i++] + 0.0f;
                        vertices[vi++] = buf[i++] + (float)z + 1.0f;
                        vertices[vi++] = buf[i++];
                        vertices[vi++] = buf[i++];
                        vertices[vi++] = buf[i++];
                        vertices[vi++] = buf[i++];
                        vertices[vi++] = buf[i++];
                    }
                }
                ++z;
            }
            ++x2;
        }
        this.houses.setVertices(vertices);
        _numVertices = house_vertices + this.road_tiles * 6;
    }

    public int getHeight() {
        return this._height;
    }

    public int getTile(float x, float z) {
        return this.getTile((int)(x * (float)this._width), (int)(z * (float)this._height));
    }

    public int getTile(int x, int z) {
        if (x >= this._width) {
            return -1;
        }
        if (z >= this._height) {
            return -1;
        }
        return this.grid[x][z];
    }

    public int getWidth() {
        return this._width;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isRoad(float x, float z) {
        return this.isRoad((int)(x * (float)this._width), (int)(z * (float)this._height));
    }

    public boolean isRoad(int x, int z) {
        return this.getTile(x, z) > 127;
    }
}

