/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Decoder;
import org.cservenak.streams.Coder;

public class CtmInputStream
extends DataInputStream {
    public CtmInputStream(InputStream in) {
        super(in);
    }

    public String readString() throws IOException {
        int len = this.readLittleInt();
        if (len > 0) {
            byte[] values = new byte[len];
            if (this.read(values) == -1) {
                throw new IOException("End of file reached while parsing the file!");
            }
            return new String(values);
        }
        return "";
    }

    public int readLittleInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return ch1 + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    public int[] readLittleIntArray(int count) throws IOException {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this.readLittleInt();
        }
        return array;
    }

    public final float readLittleFloat() throws IOException {
        return Float.intBitsToFloat(this.readLittleInt());
    }

    public float[] readLittleFloatArray(int count) throws IOException {
        float[] array = new float[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this.readLittleFloat();
        }
        return array;
    }

    public int[] readPackedInts(int count, int size, boolean signed) throws IOException {
        int[] data = new int[count * size];
        byte[] tmp = this.readCompressedData(count * size * 4);
        for (int i = 0; i < count; ++i) {
            for (int k = 0; k < size; ++k) {
                int value = CtmInputStream.interleavedRetrive(tmp, i + k * count, count * size);
                if (signed) {
                    long x = (long)value & 0xFFFFFFFFL;
                    value = (x & 1L) != 0L ? -((int)(x + 1L >> 1)) : (int)(x >> 1);
                }
                data[i * size + k] = value;
            }
        }
        return data;
    }

    public float[] readPackedFloats(int count, int size) throws IOException {
        float[] data = new float[count * size];
        byte[] tmp = this.readCompressedData(count * size * 4);
        for (int i = 0; i < count; ++i) {
            for (int k = 0; k < size; ++k) {
                int value = CtmInputStream.interleavedRetrive(tmp, i + k * count, count * size);
                data[i * size + k] = Float.intBitsToFloat(value);
            }
        }
        return data;
    }

    public byte[] readCompressedData(int size) throws IOException {
        int packedSize = this.readLittleInt();
        byte[] packed = new byte[packedSize + 5];
        if (this.read(packed) == -1) {
            throw new IOException("End of file reached while reading!");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(size);
        CustomCoder coder = new CustomCoder(size);
        coder.code(new ByteArrayInputStream(packed), bout);
        byte[] data = bout.toByteArray();
        assert (data.length == size);
        return data;
    }

    public static int interleavedRetrive(byte[] data, int offset, int stride) {
        byte b1 = data[offset + 3 * stride];
        byte b2 = data[offset + 2 * stride];
        byte b3 = data[offset + 1 * stride];
        byte b4 = data[offset];
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        int i3 = b3 & 0xFF;
        int i4 = b4 & 0xFF;
        return i1 | i2 << 8 | i3 << 16 | i4 << 24;
    }

    private static class CustomCoder
    implements Coder {
        private final Decoder d = new Decoder();
        private final int len;

        public CustomCoder(int packedLength) {
            this.len = packedLength;
        }

        public void code(InputStream in, OutputStream out) throws IOException {
            byte[] properties = new byte[5];
            if (in.read(properties) != 5) {
                throw new IOException("LZMA file has no header!");
            }
            if (!this.d.setDecoderProperties(properties)) {
                throw new IOException("Decoder properties cannot be set!");
            }
            if (!this.d.code(in, out, (long)this.len)) {
                throw new IOException("Decoding unsuccessful!");
            }
        }
    }
}

