/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.io;

import darwin.jopenctm.compression.MeshEncoder;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.errorhandling.InvalidDataException;
import darwin.jopenctm.io.CtmFileReader;
import darwin.jopenctm.io.CtmOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CtmFileWriter {
    private final CtmOutputStream out;
    private final MeshEncoder encoder;

    public CtmFileWriter(OutputStream o, MeshEncoder e) {
        this.out = new CtmOutputStream(o);
        this.encoder = e;
    }

    public void encode(Mesh m, String comment) throws IOException, InvalidDataException {
        m.checkIntegrity();
        int flags = 0;
        if (m.normals != null) {
            flags |= 1;
        }
        this.out.writeLittleInt(CtmFileReader.OCTM);
        this.out.writeLittleInt(this.encoder.getFormatVersion());
        this.out.writeLittleInt(this.encoder.getTag());
        this.out.writeLittleInt(m.getVertexCount());
        this.out.writeLittleInt(m.getTriangleCount());
        this.out.writeLittleInt(m.getUVCount());
        this.out.writeLittleInt(m.getAttrCount());
        this.out.writeLittleInt(flags);
        this.out.writeString(comment);
        this.encoder.encode(m, this.out);
    }
}

