/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;

public class Timer {
    public static final Timer instance = new Timer();
    private static final int CANCELLED = -1;
    private static final int FOREVER = -2;
    private final Array<Task> tasks = new Array(false, 8);
    private boolean stopped;
    private boolean posted;
    private final Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            Timer.this.update();
        }
    };

    public void postTask(Task task) {
        this.scheduleTask(task, 0.0f, 0.0f, 0);
    }

    public void scheduleTask(Task task) {
        this.scheduleTask(task, 0.0f, 0.0f, -2);
    }

    public void scheduleTask(Task task, float delaySeconds) {
        this.scheduleTask(task, delaySeconds, 0.0f, 0);
    }

    public void scheduleTask(Task task, float delaySeconds, float intervalSeconds) {
        this.scheduleTask(task, delaySeconds, intervalSeconds, -2);
    }

    public void scheduleTask(Task task, float delaySeconds, float intervalSeconds, int repeatCount) {
        if (task.repeatCount != -1) {
            throw new IllegalArgumentException("The same task may not be scheduled twice.");
        }
        task.delaySeconds = delaySeconds;
        task.intervalSeconds = intervalSeconds;
        task.repeatCount = repeatCount;
        this.tasks.add(task);
        this.postRunnable();
    }

    public void stop() {
        this.stopped = true;
    }

    public void start() {
        this.stopped = false;
        this.postRunnable();
    }

    public void clear() {
        int n = this.tasks.size;
        for (int i = 0; i < n; ++i) {
            this.tasks.get(i).cancel();
        }
        this.tasks.clear();
    }

    private void postRunnable() {
        if (this.stopped || this.posted) {
            return;
        }
        this.posted = true;
        Gdx.app.postRunnable(this.timerRunnable);
    }

    void update() {
        if (this.stopped) {
            this.posted = false;
            return;
        }
        float delta = Gdx.graphics.getDeltaTime();
        int n = this.tasks.size;
        for (int i = 0; i < n; ++i) {
            Task task = this.tasks.get(i);
            task.delaySeconds -= delta;
            if (task.delaySeconds > 0.0f) continue;
            if (task.repeatCount != -1) {
                if (task.repeatCount == 0) {
                    task.repeatCount = -1;
                }
                task.run();
            }
            if (task.repeatCount == -1) {
                this.tasks.removeIndex(i);
                --i;
                --n;
                continue;
            }
            task.delaySeconds = task.intervalSeconds;
            if (task.repeatCount <= 0) continue;
            --task.repeatCount;
        }
        if (this.tasks.size == 0) {
            this.posted = false;
        } else {
            Gdx.app.postRunnable(this.timerRunnable);
        }
    }

    public static void post(Task task) {
        instance.postTask(task);
    }

    public static void schedule(Task task) {
        instance.scheduleTask(task);
    }

    public static void schedule(Task task, float delaySeconds) {
        instance.scheduleTask(task, delaySeconds);
    }

    public static void schedule(Task task, float delaySeconds, float intervalSeconds) {
        instance.scheduleTask(task, delaySeconds, intervalSeconds);
    }

    public static void schedule(Task task, float delaySeconds, float intervalSeconds, int repeatCount) {
        instance.scheduleTask(task, delaySeconds, intervalSeconds, repeatCount);
    }

    public static abstract class Task
    implements Runnable {
        float delaySeconds;
        float intervalSeconds;
        int repeatCount = -1;

        @Override
        public abstract void run();

        public void cancel() {
            this.delaySeconds = 0.0f;
            this.repeatCount = -1;
        }

        public boolean isScheduled() {
            return this.repeatCount != -1;
        }
    }
}

