/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import java.lang.reflect.Constructor;

public class ReflectionPool<T>
extends Pool<T> {
    private final Class<T> type;

    public ReflectionPool(Class<T> type) {
        this.type = type;
    }

    public ReflectionPool(Class<T> type, int initialCapacity, int max) {
        super(initialCapacity, max);
        this.type = type;
    }

    public ReflectionPool(Class<T> type, int initialCapacity) {
        super(initialCapacity);
        this.type = type;
    }

    @Override
    protected T newObject() {
        try {
            return this.type.newInstance();
        }
        catch (Exception ex) {
            Constructor<T> ctor;
            try {
                ctor = this.type.getConstructor(null);
            }
            catch (Exception ex2) {
                try {
                    ctor = this.type.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                }
                catch (NoSuchMethodException ex3) {
                    throw new RuntimeException("Class cannot be created (missing no-arg constructor): " + this.type.getName());
                }
            }
            try {
                return ctor.newInstance(new Object[0]);
            }
            catch (Exception ex3) {
                throw new GdxRuntimeException("Unable to create new instance: " + this.type.getName(), ex);
            }
        }
    }
}

