/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;

public abstract class Pool<T> {
    public final int max;
    private final Array<T> freeObjects;

    public Pool() {
        this(16, Integer.MAX_VALUE);
    }

    public Pool(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    public Pool(int initialCapacity, int max) {
        this.freeObjects = new Array(false, initialCapacity);
        this.max = max;
    }

    protected abstract T newObject();

    public T obtain() {
        return this.freeObjects.size == 0 ? this.newObject() : this.freeObjects.pop();
    }

    public void free(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (this.freeObjects.size < this.max) {
            this.freeObjects.add(object);
        }
        if (object instanceof Poolable) {
            ((Poolable)object).reset();
        }
    }

    public void free(Array<T> objects) {
        int n = Math.min(objects.size, this.max - this.freeObjects.size);
        for (int i = 0; i < n; ++i) {
            T object = objects.get(i);
            this.freeObjects.add(object);
            if (!(object instanceof Poolable)) continue;
            ((Poolable)object).reset();
        }
    }

    public void clear() {
        this.freeObjects.clear();
    }

    public static interface Poolable {
        public void reset();
    }
}

