/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class SelectBox
extends Widget {
    SelectBoxStyle style;
    String[] items;
    int selectedIndex = 0;
    private final BitmapFont.TextBounds bounds = new BitmapFont.TextBounds();
    final Vector2 screenCoords = new Vector2();
    SelectList list;
    private float prefWidth;
    private float prefHeight;
    private ClickListener clickListener;

    public SelectBox(Object[] items, Skin skin) {
        this(items, skin.get(SelectBoxStyle.class));
    }

    public SelectBox(Object[] items, Skin skin, String styleName) {
        this(items, skin.get(styleName, SelectBoxStyle.class));
    }

    public SelectBox(Object[] items, SelectBoxStyle style) {
        this.setStyle(style);
        this.setItems(items);
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (SelectBox.this.list != null && SelectBox.this.list.getParent() != null) {
                    SelectBox.this.hideList();
                    return true;
                }
                Stage stage = SelectBox.this.getStage();
                Vector2 stageCoords = Vector2.tmp;
                stage.screenToStageCoordinates(stageCoords.set(SelectBox.this.screenCoords.x, SelectBox.this.screenCoords.y));
                SelectBox.this.list = new SelectList(stageCoords.x, stageCoords.y);
                stage.addActor(SelectBox.this.list);
                return true;
            }
        };
        this.addListener(this.clickListener);
    }

    public void setStyle(SelectBoxStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        if (this.items != null) {
            this.setItems(this.items);
        } else {
            this.invalidateHierarchy();
        }
    }

    public SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItems(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        if (!(objects instanceof String[])) {
            String[] strings = new String[objects.length];
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                strings[i] = String.valueOf(objects[i]);
            }
            objects = strings;
        }
        this.items = (String[])objects;
        this.selectedIndex = 0;
        Drawable bg = this.style.background;
        BitmapFont font = this.style.font;
        this.prefHeight = Math.max(bg.getTopHeight() + bg.getBottomHeight() + font.getCapHeight() - font.getDescent() * 2.0f, bg.getMinHeight());
        float max = 0.0f;
        for (int i = 0; i < this.items.length; ++i) {
            max = Math.max(font.getBounds((CharSequence)this.items[i]).width, max);
        }
        this.prefWidth = bg.getLeftWidth() + bg.getRightWidth() + max;
        this.prefWidth = Math.max(this.prefWidth, max + this.style.listBackground.getLeftWidth() + this.style.listBackground.getRightWidth() + 2.0f * this.style.itemSpacing);
        this.invalidateHierarchy();
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        Drawable background = this.list != null && this.list.getParent() != null && this.style.backgroundOpen != null ? this.style.backgroundOpen : (this.clickListener.isOver() && this.style.backgroundOver != null ? this.style.backgroundOver : this.style.background);
        BitmapFont font = this.style.font;
        Color fontColor = this.style.fontColor;
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        background.draw(batch, x, y, width, height);
        if (this.items.length > 0) {
            float availableWidth = width - background.getLeftWidth() - background.getRightWidth();
            int numGlyphs = font.computeVisibleGlyphs(this.items[this.selectedIndex], 0, this.items[this.selectedIndex].length(), availableWidth);
            this.bounds.set(font.getBounds(this.items[this.selectedIndex]));
            float textY = (int)((height -= background.getBottomHeight() + background.getTopHeight()) / 2.0f + background.getBottomHeight() + this.bounds.height / 2.0f);
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            font.draw(batch, this.items[this.selectedIndex], x + background.getLeftWidth(), y + textY, 0, numGlyphs);
        }
        this.getStage().toScreenCoordinates(this.screenCoords.set(x, y), batch.getTransformMatrix());
    }

    public void setSelection(int selection) {
        this.selectedIndex = selection;
    }

    public void setSelection(String item) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].equals(item)) continue;
            this.selectedIndex = i;
        }
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public String getSelection() {
        return this.items[this.selectedIndex];
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    public void hideList() {
        if (this.list.getParent() == null) {
            return;
        }
        this.list.addAction(Actions.sequence((Action)Actions.fadeOut(0.15f, Interpolation.fade), (Action)Actions.removeActor()));
    }

    public static class SelectBoxStyle {
        public Drawable background;
        public Drawable backgroundOver;
        public Drawable backgroundOpen;
        public Drawable listBackground;
        public Drawable listSelection;
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public float itemSpacing = 10.0f;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(BitmapFont font, Color fontColor, Drawable background, Drawable listBackground, Drawable listSelection) {
            this.background = background;
            this.listBackground = listBackground;
            this.listSelection = listSelection;
            this.font = font;
            this.fontColor.set(fontColor);
        }

        public SelectBoxStyle(SelectBoxStyle style) {
            this.background = style.background;
            this.listBackground = style.listBackground;
            this.listSelection = style.listSelection;
            this.font = style.font;
            this.fontColor.set(style.fontColor);
        }
    }

    class SelectList
    extends Actor {
        Vector2 oldScreenCoords = new Vector2();
        float itemHeight;
        float textOffsetX;
        float textOffsetY;
        int listSelectedIndex;
        InputListener stageListener;

        public SelectList(float x, float y) {
            this.listSelectedIndex = SelectBox.this.selectedIndex;
            this.stageListener = new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (pointer == 0 && button != 0) {
                        return false;
                    }
                    SelectList.this.stageToLocalCoordinates(Vector2.tmp);
                    x = Vector2.tmp.x;
                    y = Vector2.tmp.y;
                    if (x > 0.0f && x < SelectList.this.getWidth() && y > 0.0f && y < SelectList.this.getHeight()) {
                        SelectList.this.listSelectedIndex = (int)((SelectList.this.getHeight() - y) / SelectList.this.itemHeight);
                        SelectList.this.listSelectedIndex = Math.max(0, SelectList.this.listSelectedIndex);
                        SelectBox.this.selectedIndex = SelectList.this.listSelectedIndex = Math.min(SelectBox.this.items.length - 1, SelectList.this.listSelectedIndex);
                        if (SelectBox.this.items.length > 0) {
                            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                            SelectBox.this.fire(changeEvent);
                            Pools.free(changeEvent);
                        }
                    }
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    SelectBox.this.hideList();
                    event.getStage().removeCaptureListener(SelectList.this.stageListener);
                }

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    SelectList.this.stageToLocalCoordinates(Vector2.tmp);
                    x = Vector2.tmp.x;
                    y = Vector2.tmp.y;
                    if (x > 0.0f && x < SelectList.this.getWidth() && y > 0.0f && y < SelectList.this.getHeight()) {
                        SelectList.this.listSelectedIndex = (int)((SelectList.this.getHeight() - SelectBox.this.style.listBackground.getTopHeight() - y) / SelectList.this.itemHeight);
                        SelectList.this.listSelectedIndex = Math.max(0, SelectList.this.listSelectedIndex);
                        SelectList.this.listSelectedIndex = Math.min(SelectBox.this.items.length - 1, SelectList.this.listSelectedIndex);
                    }
                    return true;
                }
            };
            this.setBounds(x, 0.0f, SelectBox.this.getWidth(), 100.0f);
            this.oldScreenCoords.set(SelectBox.this.screenCoords);
            this.layout();
            Stage stage = SelectBox.this.getStage();
            float height = this.getHeight();
            if (y - height < 0.0f && y + SelectBox.this.getHeight() + height < stage.getCamera().viewportHeight) {
                this.setY(y + SelectBox.this.getHeight());
            } else {
                this.setY(y - height);
            }
            stage.addCaptureListener(this.stageListener);
            this.getColor().a = 0.0f;
            this.addAction(Actions.fadeIn(0.3f, Interpolation.fade));
        }

        private void layout() {
            BitmapFont font = SelectBox.this.style.font;
            Drawable listSelection = SelectBox.this.style.listSelection;
            Drawable listBackground = SelectBox.this.style.listBackground;
            this.itemHeight = font.getCapHeight() + -font.getDescent() * 2.0f + SelectBox.this.style.itemSpacing;
            this.itemHeight += listSelection.getTopHeight() + listSelection.getBottomHeight();
            this.textOffsetX = listSelection.getLeftWidth() + SelectBox.this.style.itemSpacing;
            this.textOffsetY = listSelection.getTopHeight() + -font.getDescent() + SelectBox.this.style.itemSpacing / 2.0f;
            this.setWidth(SelectBox.this.getWidth());
            this.setHeight((float)SelectBox.this.items.length * this.itemHeight + listBackground.getTopHeight() + listBackground.getBottomHeight());
        }

        @Override
        public void draw(SpriteBatch batch, float parentAlpha) {
            Drawable listBackground = SelectBox.this.style.listBackground;
            Drawable listSelection = SelectBox.this.style.listSelection;
            BitmapFont font = SelectBox.this.style.font;
            Color fontColor = SelectBox.this.style.fontColor;
            float x = this.getX();
            float y = this.getY();
            float width = this.getWidth();
            float height = this.getHeight();
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            listBackground.draw(batch, x, y, width, height);
            width -= listBackground.getLeftWidth() + listBackground.getRightWidth();
            x += listBackground.getLeftWidth();
            float posY = height - listBackground.getTopHeight();
            for (int i = 0; i < SelectBox.this.items.length; ++i) {
                if (this.listSelectedIndex == i) {
                    listSelection.draw(batch, x, y + posY - this.itemHeight, width, this.itemHeight);
                }
                font.setColor(fontColor.r, fontColor.g, fontColor.b, color.a * fontColor.a * parentAlpha);
                font.draw(batch, SelectBox.this.items[i], x + this.textOffsetX, y + posY - this.textOffsetY);
                posY -= this.itemHeight;
            }
        }

        @Override
        public Actor hit(float x, float y, boolean touchable) {
            return this;
        }

        @Override
        public void act(float delta) {
            super.act(delta);
            if (SelectBox.this.screenCoords.x != this.oldScreenCoords.x || SelectBox.this.screenCoords.y != this.oldScreenCoords.y) {
                SelectBox.this.hideList();
            }
        }
    }
}

