/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.test;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoaderRegistry;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.G3dLoader;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks.G3dExporter;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.math.collision.BoundingBox;

public class StillModelViewer
implements ApplicationListener {
    PerspectiveCamera cam;
    StillModel model;
    Texture[] textures = null;
    boolean hasNormals = false;
    BoundingBox bounds = new BoundingBox();
    ImmediateModeRenderer10 renderer;
    float angle = 0.0f;
    String fileName;
    String[] textureFileNames;
    FPSLogger fps = new FPSLogger();
    SpriteBatch batch;
    BitmapFont font;
    float[] lightColor = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    float[] lightPosition = new float[]{2.0f, 5.0f, 10.0f, 0.0f};

    public StillModelViewer(String fileName, String ... textureFileNames) {
        this.fileName = fileName;
        this.textureFileNames = textureFileNames;
    }

    @Override
    public void create() {
        long start = System.nanoTime();
        this.model = ModelLoaderRegistry.loadStillModel(Gdx.files.internal(this.fileName));
        Gdx.app.log("StillModelViewer", "loading took: " + (float)(System.nanoTime() - start) / 1.0E9f);
        StillSubMesh[] stillSubMeshArray = this.model.subMeshes;
        int n = this.model.subMeshes.length;
        int n2 = 0;
        while (n2 < n) {
            StillSubMesh mesh = stillSubMeshArray[n2];
            mesh.mesh.scale(0.1f, 0.1f, 0.1f);
            ++n2;
        }
        if (!this.fileName.endsWith(".g3d")) {
            G3dExporter.export(this.model, Gdx.files.absolute(String.valueOf(this.fileName) + ".g3d"));
            start = System.nanoTime();
            this.model = G3dLoader.loadStillModel(Gdx.files.absolute(String.valueOf(this.fileName) + ".g3d"));
            Gdx.app.log("StillModelViewer", "loading binary took: " + (float)(System.nanoTime() - start) / 1.0E9f);
        }
        if (this.textureFileNames.length != 0) {
            this.textures = new Texture[this.textureFileNames.length];
            int i = 0;
            while (i < this.textureFileNames.length) {
                this.textures[i] = new Texture(Gdx.files.internal(this.textureFileNames[i]), i <= 0);
                ++i;
            }
        }
        this.hasNormals = this.hasNormals();
        this.model.getBoundingBox(this.bounds);
        float len = this.bounds.getDimensions().len();
        System.out.println("bounds: " + this.bounds);
        this.cam = new PerspectiveCamera(60.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.position.set(this.bounds.getCenter().cpy().add(len / 2.0f, len / 2.0f, len / 2.0f));
        this.cam.lookAt(this.bounds.getCenter().x, this.bounds.getCenter().y, this.bounds.getCenter().z);
        this.cam.near = 0.1f;
        this.cam.far = 1000.0f;
        this.renderer = new ImmediateModeRenderer10();
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
    }

    private boolean hasNormals() {
        StillSubMesh[] stillSubMeshArray = this.model.subMeshes;
        int n = this.model.subMeshes.length;
        int n2 = 0;
        while (n2 < n) {
            StillSubMesh mesh = stillSubMeshArray[n2];
            if (mesh.mesh.getVertexAttribute(2) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void resume() {
    }

    @Override
    public void render() {
        int i;
        Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(2929);
        this.cam.update();
        this.cam.apply(Gdx.gl10);
        this.drawAxes();
        if (this.hasNormals) {
            Gdx.gl.glEnable(2896);
            Gdx.gl.glEnable(2903);
            Gdx.gl.glEnable(16384);
            Gdx.gl10.glLightfv(16384, 4609, this.lightColor, 0);
            Gdx.gl10.glLightfv(16384, 4611, this.lightPosition, 0);
        }
        if (this.textures != null) {
            i = 0;
            while (i < this.textures.length) {
                Gdx.gl.glActiveTexture(33984 + i);
                Gdx.gl.glEnable(3553);
                this.textures[i].bind();
                if (i > 0) {
                    switch (i) {
                        case 1: {
                            this.setCombiners(34164);
                            break;
                        }
                        case 2: {
                            this.setCombiners(8448);
                            break;
                        }
                        default: {
                            this.setCombiners(8448);
                        }
                    }
                }
                ++i;
            }
        }
        this.angle += 45.0f * Gdx.graphics.getDeltaTime();
        Gdx.gl10.glRotatef(this.angle, 0.0f, 1.0f, 0.0f);
        this.model.render();
        if (this.textures != null) {
            i = 0;
            while (i < this.textures.length) {
                Gdx.gl.glActiveTexture(33984 + i);
                Gdx.gl.glDisable(3553);
                ++i;
            }
        }
        if (this.hasNormals) {
            Gdx.gl.glDisable(2896);
        }
        this.batch.begin();
        this.font.draw(this.batch, "fps: " + Gdx.graphics.getFramesPerSecond(), 20.0f, 30.0f);
        this.batch.end();
        this.fps.log();
    }

    private void setCombiners(int mod) {
        Gdx.gl11.glTexEnvi(8960, 8704, 34160);
        Gdx.gl11.glTexEnvi(8960, 34161, mod);
        Gdx.gl11.glTexEnvi(8960, 34176, 34168);
        Gdx.gl11.glTexEnvi(8960, 34177, 5890);
    }

    private void drawAxes() {
        float len = this.bounds.getDimensions().len();
        this.renderer.begin(1);
        this.renderer.color(1.0f, 0.0f, 0.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, 0.0f);
        this.renderer.color(1.0f, 0.0f, 0.0f, 1.0f);
        this.renderer.vertex(len, 0.0f, 0.0f);
        this.renderer.color(0.0f, 1.0f, 0.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, 0.0f);
        this.renderer.color(0.0f, 1.0f, 0.0f, 1.0f);
        this.renderer.vertex(0.0f, len, 0.0f);
        this.renderer.color(0.0f, 0.0f, 1.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, 0.0f);
        this.renderer.color(0.0f, 0.0f, 1.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, len);
        this.renderer.end();
        Gdx.gl10.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void dispose() {
    }

    public static void main(String[] argv) {
        new LwjglApplication(new StillModelViewer("data/models/multipleuvs.g3d", "data/multipleuvs_1.png", "data/multipleuvs_2.png"), "StillModel Viewer", 800, 480, false);
    }
}

