/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingDataInputStream
implements DataInput {
    int readBytes = 0;
    DataInputStream in;

    public CountingDataInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    public int getReadBytes() {
        return this.readBytes;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readBytes += b.length;
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.readBytes += len;
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skipped = this.in.skipBytes(n);
        this.readBytes += skipped;
        return skipped;
    }

    @Override
    public boolean readBoolean() throws IOException {
        ++this.readBytes;
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        ++this.readBytes;
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        ++this.readBytes;
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.readBytes += 2;
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.readBytes += 2;
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.readBytes += 2;
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.readBytes += 4;
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.readBytes += 8;
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.readBytes += 4;
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.readBytes += 8;
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

