/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.g3d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.KeyframedModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.SkeletonModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.StillModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks.ChunkReader;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.keyframe.Keyframe;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedAnimation;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedSubMesh;
import com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonJoint;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonKeyframe;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.IOException;
import java.io.InputStream;

public class G3dLoader {
    public static StillModel loadStillModel(FileHandle handle) {
        ChunkReader.Chunk root = null;
        InputStream in = null;
        try {
            in = handle.read();
            root = ChunkReader.readChunks(in);
            if (root.getId() != 1194542106) {
                throw new GdxRuntimeException("Invalid root tag id: " + root.getId());
            }
            ChunkReader.Chunk version = root.getChild(1);
            if (version == null) {
                throw new GdxRuntimeException("No version chunk found");
            }
            int major = version.readByte();
            int minor = version.readByte();
            if (major != 0 || minor != 1) {
                throw new GdxRuntimeException("Invalid version, required 0.1, got " + major + "." + minor);
            }
            ChunkReader.Chunk stillModel = root.getChild(4096);
            if (stillModel == null) {
                throw new GdxRuntimeException("No stillmodel chunk found");
            }
            int numSubMeshes = stillModel.readInt();
            SubMesh[] meshes = new StillSubMesh[numSubMeshes];
            ChunkReader.Chunk[] meshChunks = stillModel.getChildren(4352);
            if (meshChunks.length != numSubMeshes) {
                throw new GdxRuntimeException("Number of submeshes not equal to number specified in still model chunk, expected " + numSubMeshes + ", got " + meshChunks.length);
            }
            int i = 0;
            while (i < numSubMeshes) {
                ChunkReader.Chunk subMesh = meshChunks[i];
                String name = subMesh.readString();
                int primitiveType = subMesh.readInt();
                ChunkReader.Chunk attributes = subMesh.getChild(4384);
                if (attributes == null) {
                    throw new GdxRuntimeException("No vertex attribute chunk given");
                }
                int numAttributes = attributes.readInt();
                ChunkReader.Chunk[] attributeChunks = attributes.getChildren(4385);
                if (attributeChunks.length != numAttributes) {
                    new GdxRuntimeException("Number of attributes not equal to number specified in attributes chunk, expected " + numAttributes + ", got " + attributeChunks.length);
                }
                VertexAttribute[] vertAttribs = new VertexAttribute[numAttributes];
                int j = 0;
                while (j < numAttributes) {
                    vertAttribs[j] = new VertexAttribute(attributeChunks[j].readInt(), attributeChunks[j].readInt(), attributeChunks[j].readString());
                    ++j;
                }
                ChunkReader.Chunk vertices = subMesh.getChild(4368);
                int numVertices = vertices.readInt();
                float[] vertexData = vertices.readFloats();
                ChunkReader.Chunk indices = subMesh.getChild(4369);
                int numIndices = indices.readInt();
                short[] indexData = indices.readShorts();
                StillSubMesh mesh = new StillSubMesh(name, new Mesh(true, numVertices, numIndices, vertAttribs), primitiveType);
                mesh.mesh.setVertices(vertexData);
                mesh.mesh.setIndices(indexData);
                mesh.material = new Material("default", new MaterialAttribute[0]);
                meshes[i] = mesh;
                ++i;
            }
            StillModel model = new StillModel(meshes);
            model.setMaterial(new Material("default", new MaterialAttribute[0]));
            StillModel stillModel2 = model;
            return stillModel2;
        }
        catch (IOException e) {
            throw new GdxRuntimeException("Couldn't load still model from '" + handle.name() + "', " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static KeyframedModel loadKeyframedModel(FileHandle handle) {
        ChunkReader.Chunk root = null;
        InputStream in = null;
        try {
            in = handle.read();
            root = ChunkReader.readChunks(in);
            if (root.getId() != 1194542106) {
                throw new GdxRuntimeException("Invalid root tag id: " + root.getId());
            }
            ChunkReader.Chunk version = root.getChild(1);
            if (version == null) {
                throw new GdxRuntimeException("No version chunk found");
            }
            int major = version.readByte();
            int minor = version.readByte();
            if (major != 0 || minor != 1) {
                throw new GdxRuntimeException("Invalid version, required 0.1, got " + major + "." + minor);
            }
            ChunkReader.Chunk stillModel = root.getChild(8192);
            if (stillModel == null) {
                throw new GdxRuntimeException("No stillmodel chunk found");
            }
            int numSubMeshes = stillModel.readInt();
            KeyframedSubMesh[] meshes = new KeyframedSubMesh[numSubMeshes];
            ChunkReader.Chunk[] meshChunks = stillModel.getChildren(8704);
            if (meshChunks.length != numSubMeshes) {
                throw new GdxRuntimeException("Number of submeshes not equal to number specified in still model chunk, expected " + numSubMeshes + ", got " + meshChunks.length);
            }
            int i = 0;
            while (i < numSubMeshes) {
                ChunkReader.Chunk subMesh = meshChunks[i];
                String meshName = subMesh.readString();
                int primitiveType = subMesh.readInt();
                int animatedComponents = subMesh.readInt();
                int numAnimations = subMesh.readInt();
                ChunkReader.Chunk attributes = subMesh.getChild(4384);
                if (attributes == null) {
                    throw new GdxRuntimeException("No vertex attribute chunk given");
                }
                int numAttributes = attributes.readInt();
                ChunkReader.Chunk[] attributeChunks = attributes.getChildren(4385);
                if (attributeChunks.length != numAttributes) {
                    new GdxRuntimeException("Number of attributes not equal to number specified in attributes chunk, expected " + numAttributes + ", got " + attributeChunks.length);
                }
                VertexAttribute[] vertAttribs = new VertexAttribute[numAttributes];
                int j = 0;
                while (j < numAttributes) {
                    vertAttribs[j] = new VertexAttribute(attributeChunks[j].readInt(), attributeChunks[j].readInt(), attributeChunks[j].readString());
                    ++j;
                }
                ChunkReader.Chunk vertices = subMesh.getChild(4368);
                int numVertices = vertices.readInt();
                float[] vertexData = vertices.readFloats();
                ChunkReader.Chunk indices = subMesh.getChild(4369);
                int numIndices = indices.readInt();
                short[] indexData = indices.readShorts();
                ObjectMap<String, KeyframedAnimation> animations = new ObjectMap<String, KeyframedAnimation>();
                ChunkReader.Chunk[] animationChunks = subMesh.getChildren(8960);
                if (numAnimations != animationChunks.length) {
                    throw new GdxRuntimeException("number of keyframed animations not equal to number specified in keyframed submesh chunk, was " + animationChunks.length + ", expected " + numAnimations);
                }
                int j2 = 0;
                while (j2 < numAnimations) {
                    ChunkReader.Chunk animationChunk = animationChunks[j2];
                    String animationName = animationChunk.readString();
                    float frameDuration = animationChunk.readFloat();
                    int numKeyframes = animationChunk.readInt();
                    Keyframe[] keyframes = new Keyframe[numKeyframes];
                    ChunkReader.Chunk[] keyframeChunks = animationChunk.getChildren(9216);
                    if (numKeyframes != keyframeChunks.length) {
                        throw new GdxRuntimeException("number of keyframes not equal to number specified in keyframed animation, was " + keyframeChunks.length + ", expected " + numKeyframes);
                    }
                    int k = 0;
                    while (k < numKeyframes) {
                        ChunkReader.Chunk keyframeChunk = keyframeChunks[k];
                        float timeStamp = keyframeChunk.readFloat();
                        float[] keyframeVertices = keyframeChunk.readFloats();
                        keyframes[k] = new Keyframe(timeStamp, keyframeVertices);
                        ++k;
                    }
                    animations.put(animationName, new KeyframedAnimation(animationName, frameDuration, keyframes));
                    ++j2;
                }
                Mesh mesh = new Mesh(Mesh.VertexDataType.VertexArray, false, numVertices, numIndices, vertAttribs);
                meshes[i] = new KeyframedSubMesh(meshName, mesh, vertexData, animations, animatedComponents, primitiveType);
                mesh.setVertices(vertexData);
                mesh.setIndices(indexData);
                ++i;
            }
            KeyframedModel model = new KeyframedModel(meshes);
            model.setMaterial(new Material("default", new MaterialAttribute[0]));
            KeyframedModel keyframedModel = model;
            return keyframedModel;
        }
        catch (IOException e) {
            throw new GdxRuntimeException("Couldn't load still model from '" + handle.name() + "', " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static SkeletonModel loadSkeletonModel(FileHandle handle) {
        ChunkReader.Chunk root = null;
        InputStream in = null;
        try {
            in = handle.read();
            root = ChunkReader.readChunks(in);
            if (root.getId() != 1194542106) {
                throw new GdxRuntimeException("Invalid root tag id: " + root.getId());
            }
            ChunkReader.Chunk version = root.getChild(1);
            if (version == null) {
                throw new GdxRuntimeException("No version chunk found");
            }
            int major = version.readByte();
            int minor = version.readByte();
            if (major != 0 || minor != 1) {
                throw new GdxRuntimeException("Invalid version, required 0.1, got " + major + "." + minor);
            }
            ChunkReader.Chunk skeletonModel = root.getChild(16384);
            if (skeletonModel == null) {
                throw new GdxRuntimeException("No skeletonModel chunk found");
            }
            int numSubMeshes = skeletonModel.readInt();
            SubMesh[] meshes = new SkeletonSubMesh[numSubMeshes];
            ChunkReader.Chunk[] meshChunks = skeletonModel.getChildren(16896);
            if (meshChunks.length != numSubMeshes) {
                throw new GdxRuntimeException("Number of submeshes not equal to number specified in still model chunk, expected " + numSubMeshes + ", got " + meshChunks.length);
            }
            int i = 0;
            while (i < numSubMeshes) {
                ChunkReader.Chunk subMeshChunk = meshChunks[i];
                ChunkReader.Chunk attributes = subMeshChunk.getChild(4384);
                if (attributes == null) {
                    throw new GdxRuntimeException("No vertex attribute chunk given");
                }
                int numAttributes = attributes.readInt();
                ChunkReader.Chunk[] attributeChunks = attributes.getChildren(4385);
                if (attributeChunks.length != numAttributes) {
                    new GdxRuntimeException("Number of attributes not equal to number specified in attributes chunk, expected " + numAttributes + ", got " + attributeChunks.length);
                }
                VertexAttribute[] vertAttribs = new VertexAttribute[numAttributes];
                int j = 0;
                while (j < numAttributes) {
                    vertAttribs[j] = new VertexAttribute(attributeChunks[j].readInt(), attributeChunks[j].readInt(), attributeChunks[j].readString());
                    ++j;
                }
                ChunkReader.Chunk vertices = subMeshChunk.getChild(4368);
                int numVertices = vertices.readInt();
                float[] meshVertices = vertices.readFloats();
                ChunkReader.Chunk indices = subMeshChunk.getChild(4369);
                int numIndices = indices.readInt();
                short[] meshIndices = indices.readShorts();
                ChunkReader.Chunk boneWeights = subMeshChunk.getChild(4400);
                int numBonesWeights = boneWeights.readInt();
                ChunkReader.Chunk[] boneWeightChunks = boneWeights.getChildren(4401);
                if (attributeChunks.length != numAttributes) {
                    new GdxRuntimeException("Number of bone weights not equal to number specified in bone weights chunk, expected " + numBonesWeights + ", got " + boneWeightChunks.length);
                }
                float[][] meshBoneWeights = new float[numBonesWeights][];
                int j2 = 0;
                while (j2 < numBonesWeights) {
                    int count = boneWeightChunks[j2].readInt();
                    meshBoneWeights[j2] = boneWeightChunks[j2].readFloats();
                    ++j2;
                }
                ChunkReader.Chunk boneAssignments = subMeshChunk.getChild(4416);
                int numBoneAssignments = boneAssignments.readInt();
                ChunkReader.Chunk[] boneAssignmentChunks = boneAssignments.getChildren(4417);
                if (boneAssignmentChunks.length != numBoneAssignments) {
                    new GdxRuntimeException("Number of bone assignment not equal to number specified in bone assignment chunk, expected " + numBoneAssignments + ", got " + boneAssignmentChunks.length);
                }
                int[][] meshBoneAssignments = new int[numBoneAssignments][];
                int j3 = 0;
                while (j3 < numBoneAssignments) {
                    int count = boneAssignmentChunks[j3].readInt();
                    meshBoneAssignments[j3] = boneAssignmentChunks[j3].readInts();
                    ++j3;
                }
                SkeletonSubMesh subMesh = new SkeletonSubMesh(subMeshChunk.readString(), new Mesh(false, numVertices, numIndices, vertAttribs), subMeshChunk.readInt());
                subMesh.indices = meshIndices;
                subMesh.boneAssignments = meshBoneAssignments;
                subMesh.boneWeights = meshBoneWeights;
                subMesh.vertices = meshVertices;
                subMesh.mesh.setVertices(subMesh.vertices);
                subMesh.mesh.setIndices(subMesh.indices);
                subMesh.skinnedVertices = new float[subMesh.vertices.length];
                System.arraycopy(subMesh.vertices, 0, subMesh.skinnedVertices, 0, subMesh.vertices.length);
                meshes[i] = subMesh;
                ++i;
            }
            Skeleton skeleton = new Skeleton();
            ChunkReader.Chunk skeletonChunk = skeletonModel.getChild(17664);
            ChunkReader.Chunk hierarchy = skeletonChunk.getChild(17920);
            int numHierarchyJoints = hierarchy.readInt();
            int i2 = 0;
            while (i2 < numHierarchyJoints) {
                skeleton.hierarchy.add(G3dLoader.readSkeletonJoint(hierarchy));
                ++i2;
            }
            ChunkReader.Chunk animations = skeletonChunk.getChild(17152);
            int numAnimations = animations.readInt();
            ChunkReader.Chunk[] animationChunks = animations.getChildren(17408);
            if (animationChunks.length != numAnimations) {
                new GdxRuntimeException("Number of animations not equal to number specified in animations chunk, expected " + numAnimations + ", got " + animationChunks.length);
            }
            int i3 = 0;
            while (i3 < numAnimations) {
                ChunkReader.Chunk animation = animationChunks[i3];
                String name = animation.readString();
                float totalDuration = animation.readFloat();
                int numJoints = animation.readInt();
                SkeletonKeyframe[][] perJointKeyFrames = new SkeletonKeyframe[numJoints][];
                int j = 0;
                while (j < numJoints) {
                    int numFrames = animation.readInt();
                    perJointKeyFrames[j] = new SkeletonKeyframe[numFrames];
                    int k = 0;
                    while (k < numFrames) {
                        SkeletonKeyframe frame = new SkeletonKeyframe();
                        frame.timeStamp = animation.readFloat();
                        frame.parentIndex = animation.readInt();
                        frame.position.x = animation.readFloat();
                        frame.position.y = animation.readFloat();
                        frame.position.z = animation.readFloat();
                        frame.rotation.w = animation.readFloat();
                        frame.rotation.x = animation.readFloat();
                        frame.rotation.y = animation.readFloat();
                        frame.rotation.z = animation.readFloat();
                        frame.scale.x = animation.readFloat();
                        frame.scale.y = animation.readFloat();
                        frame.scale.z = animation.readFloat();
                        perJointKeyFrames[j][k] = frame;
                        ++k;
                    }
                    ++j;
                }
                skeleton.animations.put(name, new SkeletonAnimation(name, totalDuration, perJointKeyFrames));
                ++i3;
            }
            skeleton.buildFromHierarchy();
            SkeletonModel model = new SkeletonModel(skeleton, meshes);
            model.setMaterial(new Material("default", new MaterialAttribute[0]));
            SkeletonModel skeletonModel2 = model;
            return skeletonModel2;
        }
        catch (IOException e) {
            throw new GdxRuntimeException("Couldn't load skeleton model from '" + handle.name() + "', " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static SkeletonJoint readSkeletonJoint(ChunkReader.Chunk jointChunk) {
        SkeletonJoint joint = new SkeletonJoint();
        joint.name = jointChunk.readString();
        joint.position.x = jointChunk.readFloat();
        joint.position.y = jointChunk.readFloat();
        joint.position.z = jointChunk.readFloat();
        joint.rotation.w = jointChunk.readFloat();
        joint.rotation.x = jointChunk.readFloat();
        joint.rotation.y = jointChunk.readFloat();
        joint.rotation.z = jointChunk.readFloat();
        joint.scale.x = jointChunk.readFloat();
        joint.scale.y = jointChunk.readFloat();
        joint.scale.z = jointChunk.readFloat();
        int count = jointChunk.readInt();
        int i = 0;
        while (i < count) {
            SkeletonJoint child = G3dLoader.readSkeletonJoint(jointChunk);
            child.parent = joint;
            joint.children.add(child);
            ++i;
        }
        return joint;
    }

    public static class G3dKeyframedModelLoader
    implements KeyframedModelLoader {
        @Override
        public KeyframedModel load(FileHandle handle, ModelLoaderHints hints) {
            return G3dLoader.loadKeyframedModel(handle);
        }
    }

    public static class G3dSkeletonModelLoader
    implements SkeletonModelLoader {
        @Override
        public SkeletonModel load(FileHandle handle, ModelLoaderHints hints) {
            return G3dLoader.loadSkeletonModel(handle);
        }
    }

    public static class G3dStillModelLoader
    implements StillModelLoader {
        @Override
        public StillModel load(FileHandle handle, ModelLoaderHints hints) {
            return G3dLoader.loadStillModel(handle);
        }
    }
}

