/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.graphics.g3d.loaders.collada.Source;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.util.HashMap;

public class Skin {
    public float[][] boneWeight;
    public int[][] boneIndex;

    public Skin(XmlReader.Element skinElement) {
        Array<XmlReader.Element> colladaSources = skinElement.getChildrenByName("source");
        HashMap<String, Source> sources = new HashMap<String, Source>();
        int j = 0;
        while (j < colladaSources.size) {
            XmlReader.Element colladaSource = colladaSources.get(j);
            if (colladaSource.getChildrenByName((String)"float_array").size != 0) {
                sources.put(colladaSource.getAttribute("id"), new Source(colladaSource));
            }
            ++j;
        }
        XmlReader.Element vertexWeights = skinElement.getChildByName("vertex_weights");
        String[] countTokens = vertexWeights.getChildByName("vcount").getText().split("\\s+");
        int[] vertexCount = new int[countTokens.length];
        int i = 0;
        while (i < countTokens.length) {
            vertexCount[i] = Integer.parseInt(countTokens[i]);
            ++i;
        }
        String[] indexTokens = vertexWeights.getChildByName("v").getText().split("\\s+");
        int[] vertexWeightIndex = new int[indexTokens.length];
        int i2 = 0;
        while (i2 < indexTokens.length) {
            vertexWeightIndex[i2] = Integer.parseInt(indexTokens[i2]);
            ++i2;
        }
        ObjectMap<String, String> mapping = new ObjectMap<String, String>();
        Array<XmlReader.Element> inputs = vertexWeights.getChildrenByName("input");
        int i3 = 0;
        while (i3 < inputs.size) {
            mapping.put(inputs.get(i3).getAttribute("semantic"), inputs.get(i3).getAttribute("source").replaceFirst("#", ""));
            ++i3;
        }
        this.boneWeight = new float[vertexCount.length][];
        this.boneIndex = new int[vertexCount.length][];
        int index = 0;
        int i4 = 0;
        while (i4 < vertexCount.length) {
            int count = vertexCount[i4];
            this.boneWeight[i4] = new float[count];
            this.boneIndex[i4] = new int[count];
            float[] weights = ((Source)sources.get(mapping.get("WEIGHT"))).data;
            int k = 0;
            while (k < count) {
                this.boneIndex[i4][k] = vertexWeightIndex[index++];
                this.boneWeight[i4][k] = weights[vertexWeightIndex[index++]];
                ++k;
            }
            ++i4;
        }
    }
}

