/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonJoint;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;

public class Joint {
    SkeletonJoint joint;

    public Joint(XmlReader.Element animationElement) {
        Array<XmlReader.Element> nodes = animationElement.getChildrenByName("node");
        XmlReader.Element jointNode = null;
        int i = 0;
        while (i < nodes.size) {
            XmlReader.Element e = nodes.get(i);
            Array<XmlReader.Element> subNodes = e.getChildrenByName("node");
            if (subNodes.size > 0 && subNodes.get(0).getAttribute("type").equalsIgnoreCase("JOINT")) {
                jointNode = e;
                break;
            }
            ++i;
        }
        if (jointNode == null) {
            throw new GdxRuntimeException("no Joint element in scene");
        }
        this.joint = this.getJoint(jointNode, true);
    }

    SkeletonJoint getJoint(XmlReader.Element jointNode, boolean isRootNode) {
        XmlReader.Element matrixElement;
        SkeletonJoint joint = new SkeletonJoint();
        joint.name = jointNode.getAttribute("id");
        if (!isRootNode && (matrixElement = jointNode.getChildByName("matrix")) != null) {
            Matrix4 m = this.getMatrix(matrixElement);
            m.getTranslation(joint.position);
            m.getRotation(joint.rotation);
        }
        Array<XmlReader.Element> nodes = jointNode.getChildrenByName("node");
        int i = 0;
        while (i < nodes.size) {
            SkeletonJoint child = this.getJoint(nodes.get(i), false);
            if (!isRootNode) {
                child.parent = joint;
            }
            joint.children.add(child);
            ++i;
        }
        return joint;
    }

    public Matrix4 getMatrix(XmlReader.Element matrix) {
        Matrix4 m = new Matrix4();
        String[] tokens = matrix.getText().split("\\s+");
        int i = 0;
        while (i < tokens.length) {
            m.val[i] = Float.parseFloat(tokens[i]);
            ++i;
        }
        m.tra();
        return m;
    }
}

