/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.graphics.g3d.loaders.collada.Source;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonKeyframe;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.util.HashMap;

public class Animation {
    ObjectMap<String, float[]> inputMap = new ObjectMap();
    ObjectMap<String, float[]> outputMap = new ObjectMap();
    Array<String> channels = new Array();
    SkeletonKeyframe[][] keyFrames;

    public Animation(XmlReader.Element libAnimElement) {
        Array<XmlReader.Element> animElements = libAnimElement.getChildrenByName("animation");
        int i = 0;
        while (i < animElements.size) {
            XmlReader.Element animElement = animElements.get(i);
            Array<XmlReader.Element> colladaSources = animElement.getChildrenByName("source");
            HashMap<String, Source> sources = new HashMap<String, Source>();
            int j = 0;
            while (j < colladaSources.size) {
                XmlReader.Element colladaSource = colladaSources.get(j);
                if (colladaSource.getChildrenByName((String)"float_array").size != 0) {
                    sources.put(colladaSource.getAttribute("id"), new Source(colladaSource));
                }
                ++j;
            }
            ObjectMap<String, String> mapping = new ObjectMap<String, String>();
            XmlReader.Element samplerElement = animElement.getChildByName("sampler");
            if (samplerElement == null) {
                throw new GdxRuntimeException("no sampler in animation element in scene");
            }
            Array<XmlReader.Element> inputs = samplerElement.getChildrenByName("input");
            int k = 0;
            while (k < inputs.size) {
                mapping.put(inputs.get(k).getAttribute("semantic"), inputs.get(k).getAttribute("source").replaceFirst("#", ""));
                ++k;
            }
            XmlReader.Element channelElement = animElement.getChildByName("channel");
            if (channelElement == null) {
                throw new GdxRuntimeException("no sampler in animation element in scene");
            }
            String channelName = channelElement.getAttribute("target");
            this.channels.add(channelName);
            this.inputMap.put(channelName, ((Source)sources.get(mapping.get("INPUT"))).data);
            this.outputMap.put(channelName, ((Source)sources.get(mapping.get("OUTPUT"))).data);
            ++i;
        }
        this.keyFrames = new SkeletonKeyframe[this.channels.size][];
        i = 0;
        while (i < this.channels.size) {
            String channel = this.channels.get(i);
            float[] input = this.inputMap.get(channel);
            float[] output = this.outputMap.get(channel);
            this.keyFrames[i] = new SkeletonKeyframe[input.length];
            int j = 0;
            while (j < input.length) {
                SkeletonKeyframe frame;
                this.keyFrames[i][j] = frame = new SkeletonKeyframe();
                Matrix4 m = this.getMatrix(output, j * 16);
                m.getTranslation(frame.position);
                m.getRotation(frame.rotation);
                frame.timeStamp = input[j];
                ++j;
            }
            ++i;
        }
    }

    private Matrix4 getMatrix(float[] val, int offset) {
        Matrix4 m = new Matrix4();
        int i = 0;
        while (i < 16) {
            m.val[i] = val[i + offset];
            ++i;
        }
        m.tra();
        return m;
    }
}

