/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.experimental;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.lights.LightManager;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class ShaderFactory {
    static final String define = "#define ";
    static final String lightsNum = "#define LIGHTS_NUM ";

    public static ShaderProgram createShader(Material material, LightManager lights) {
        StringBuilder flags = new StringBuilder(128);
        flags.append(lightsNum);
        flags.append(lights.maxLightsPerModel);
        flags.append("\n");
        if (material != null) {
            int i = 0;
            while (i < material.attributes.size) {
                flags.append(define);
                flags.append(material.attributes.get(i).getShaderFlag());
                flags.append("\n");
                ++i;
            }
        }
        String fileName = lights.quality == LightManager.LightQuality.FRAGMENT ? "light" : "vertexpath";
        String vertexShader = Gdx.files.internal("data/shaders/" + fileName + ".vertex.glsl").readString();
        String fragmentShader = Gdx.files.internal("data/shaders/" + fileName + ".fragment.glsl").readString();
        ShaderProgram.pedantic = false;
        ShaderProgram shader = new ShaderProgram(flags + vertexShader, flags + fragmentShader);
        return shader;
    }
}

