/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.experimental;

import com.badlogic.gdx.graphics.g3d.experimental.ShaderFactory;
import com.badlogic.gdx.graphics.g3d.lights.LightManager;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;

public class MaterialShaderHandler {
    private LightManager lightManager;
    private final Array<Material> materialsWithShader = new Array(false, 64);

    public MaterialShaderHandler(LightManager lightManager) {
        this.lightManager = lightManager;
    }

    public ShaderProgram getShader(Material material) {
        int i = 0;
        while (i < this.materialsWithShader.size) {
            if (material.shaderEquals(this.materialsWithShader.get(i))) {
                return this.materialsWithShader.get(i).getShader();
            }
            ++i;
        }
        this.materialsWithShader.add(material);
        return ShaderFactory.createShader(material, this.lightManager);
    }

    public void dispose() {
        int i = 0;
        while (i < this.materialsWithShader.size) {
            if (this.materialsWithShader.get(i).getShader() != null) {
                this.materialsWithShader.get(i).getShader().dispose();
                this.materialsWithShader.get(i).resetShader();
            }
            ++i;
        }
    }
}

