/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.experimental;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.AnimatedModelNode;
import com.badlogic.gdx.graphics.g3d.StillModelNode;
import com.badlogic.gdx.graphics.g3d.experimental.PerspectiveCamController;
import com.badlogic.gdx.graphics.g3d.lights.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.lights.LightManager;
import com.badlogic.gdx.graphics.g3d.lights.PointLight;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoaderRegistry;
import com.badlogic.gdx.graphics.g3d.materials.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.materials.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.test.PrototypeRendererGL20;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

public class HybridLightTest
implements ApplicationListener {
    static final int LIGHTS_NUM = 4;
    static final float LIGHT_INTESITY = 3.0f;
    LightManager lightManager;
    PerspectiveCamController camController;
    PerspectiveCamera cam;
    StillModel model;
    StillModel model2;
    private Texture texture;
    FPSLogger logger = new FPSLogger();
    private Matrix4 modelMatrix = new Matrix4();
    private Matrix4 modelMatrix2 = new Matrix4();
    private final Matrix3 normalMatrix = new Matrix3();
    float timer;
    private PrototypeRendererGL20 protoRenderer;
    private StillModelNode instance;
    private StillModelNode instance2;
    private Texture texture2;
    private KeyframedModel model3;
    private int currAnimIdx;
    private AnimatedModelNode animInstance;
    private Texture texture3;

    @Override
    public void render() {
        this.logger.log();
        float delta = Gdx.graphics.getDeltaTime();
        this.camController.update(delta);
        this.timer += delta;
        int i = 0;
        while (i < 1 && i < this.lightManager.pointLights.size) {
            Vector3 v = this.lightManager.pointLights.get((int)i).position;
            v.set(this.animInstance.getSortCenter());
            v.x += MathUtils.sin(this.timer);
            v.z += MathUtils.cos(this.timer);
            ++i;
        }
        this.animInstance.time += delta;
        if (Gdx.input.justTouched()) {
            ++this.currAnimIdx;
            if (this.currAnimIdx == this.model3.getAnimations().length) {
                this.currAnimIdx = 0;
            }
            this.animInstance.animation = this.model3.getAnimations()[this.currAnimIdx].name;
            this.animInstance.time = 0.0f;
        }
        if (this.animInstance.time > this.model3.getAnimations()[this.currAnimIdx].totalDuration) {
            this.animInstance.time = 0.0f;
        }
        Gdx.gl.glEnable(2884);
        Gdx.gl.glFrontFace(2305);
        Gdx.gl.glCullFace(1028);
        Gdx.gl.glEnable(2929);
        Gdx.gl.glDepthMask(true);
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        this.protoRenderer.begin();
        float tim = this.animInstance.time;
        int i2 = 1;
        while (i2 < 7) {
            int j = 1;
            while (j < 7) {
                this.animInstance.matrix.val[12] = -i2 * 2 + 8;
                this.animInstance.matrix.val[14] = -j * 2 - 4;
                this.protoRenderer.draw(this.model3, this.animInstance);
                ++j;
            }
            ++i2;
        }
        this.protoRenderer.end();
        Gdx.gl.glCullFace(1029);
        this.protoRenderer.begin();
        this.protoRenderer.draw(this.model2, this.instance2);
        this.protoRenderer.draw(this.model, this.instance2);
        this.protoRenderer.draw(this.model, this.instance);
        this.protoRenderer.end();
    }

    @Override
    public void create() {
        this.lightManager = new LightManager(4, LightManager.LightQuality.FRAGMENT);
        int i = 0;
        while (i < 4) {
            PointLight l = new PointLight();
            l.position.set(MathUtils.random(6) - 3, 1 + MathUtils.random(6), MathUtils.random(6) - 3);
            l.color.r = MathUtils.random();
            l.color.b = MathUtils.random();
            l.color.g = MathUtils.random();
            l.intensity = 3.0f;
            this.lightManager.addLigth(l);
            ++i;
        }
        this.lightManager.dirLight = new DirectionalLight();
        this.lightManager.dirLight.color.set(0.1f, 0.1f, 0.1f, 1.0f);
        this.lightManager.dirLight.direction.set(-0.4f, -1.0f, 0.03f).nor();
        this.lightManager.ambientLight.set(0.01f, 0.01f, 0.03f, 0.0f);
        this.cam = new PerspectiveCamera(45.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.near = 0.1f;
        this.cam.far = 64.0f;
        this.cam.position.set(-2.0f, 1.75f, -2.0f);
        this.cam.update();
        this.camController = new PerspectiveCamController(this.cam);
        Gdx.input.setInputProcessor(this.camController);
        this.texture = new Texture(Gdx.files.internal("data/multipleuvs_1.png"), Pixmap.Format.RGB565, true);
        this.texture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        this.texture2 = new Texture(Gdx.files.internal("data/texture2UV1N.png"), Pixmap.Format.RGB565, true);
        this.texture2.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        this.model = ModelLoaderRegistry.loadStillModel(Gdx.files.internal("data/models/sphere.obj"));
        this.model2 = ModelLoaderRegistry.loadStillModel(Gdx.files.internal("data/models/basicscene.obj"));
        this.instance = new StillModelNode();
        this.instance.getTransform().translate(2.0f, 0.0f, -5.0f);
        this.instance2 = new StillModelNode();
        BoundingBox box = new BoundingBox();
        this.model.getBoundingBox(box);
        this.instance.radius = box.getDimensions().len() / 2.0f;
        this.model2.getBoundingBox(box);
        this.instance2.radius = box.getDimensions().len() / 2.0f;
        this.instance2.matrix.scale(2.0f, 1.0f, 2.0f);
        this.protoRenderer = new PrototypeRendererGL20(this.lightManager);
        this.protoRenderer.cam = this.cam;
        ColorAttribute c1 = new ColorAttribute(new Color(0.75f, 0.75f, 0.75f, 0.3f), "diffuseColor");
        ColorAttribute c2 = new ColorAttribute(new Color(0.35f, 0.35f, 0.35f, 0.35f), "specularColor");
        ColorAttribute c3 = new ColorAttribute(new Color(0.2f, 1.0f, 0.15f, 1.0f), "rimColor");
        TextureAttribute t1 = new TextureAttribute(this.texture, 0, "diffuseTexture");
        TextureAttribute t2 = new TextureAttribute(this.texture2, 1, "specularTexture");
        ColorAttribute c4 = new ColorAttribute(new Color(0.0f, 0.0f, 0.0f, 0.35f), "fogColor");
        BlendingAttribute b = new BlendingAttribute("translucent");
        Material material2 = new Material("basic", c2, t1, c4);
        this.model2.setMaterial(material2);
        Material material = new Material("shiningBall", c1, c2, c4);
        this.model.setMaterial(material);
        this.model3 = ModelLoaderRegistry.loadKeyframedModel(Gdx.files.internal("data/models/knight.md2"));
        this.animInstance = new AnimatedModelNode();
        this.animInstance.animation = this.model3.getAnimations()[0].name;
        this.animInstance.looping = true;
        this.model3.getBoundingBox(box);
        this.animInstance.matrix.trn(-1.75f, 0.0f, -5.5f);
        this.animInstance.matrix.scale(0.05f, 0.05f, 0.05f);
        box.mul(this.animInstance.matrix);
        this.animInstance.radius = box.getDimensions().len() / 2.0f;
        this.texture3 = new Texture(Gdx.files.internal("data/models/knight.jpg"), Pixmap.Format.RGB565, true);
        this.texture3.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        TextureAttribute t3 = new TextureAttribute(this.texture3, 0, "diffuseTexture");
        Material material3 = new Material("s", t2, t3, c4);
        this.model3.setMaterial(material3);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void dispose() {
        this.model.dispose();
        this.model2.dispose();
        this.model3.dispose();
        this.texture.dispose();
        this.texture2.dispose();
        this.texture3.dispose();
    }

    @Override
    public void resume() {
    }

    public static void main(String[] argv) {
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.title = "Hybrid Light";
        config.width = 800;
        config.height = 480;
        config.samples = 8;
        config.vSyncEnabled = false;
        config.useGL20 = true;
        new LwjglApplication(new HybridLightTest(), config);
    }
}

