struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};
float V_InvH : INVSCREENH;
float V_InvW : INVSCREENW;
float V_Time : TIME;
float V_Alpha : ALPHA;
float V_Var1 : VAR1;
float V_Var2 : VAR2;
float V_Var3 : VAR3;
float V_Var4 : VAR4;
float V_Var5 : VAR5;
float V_Var6 : VAR6;
float V_Var7 : VAR7;
float V_Var8 : VAR8;
float V_Var9 : VAR9;
float4 PS(VS_OUTPUT In) : COLOR0
{ 
  float ox=0.5;
  float oy=0.5;
  float4 color; 
  float2 xy=In.Tex0.xy;
  V_Var4=V_Var4-0.5;
  V_Var9=V_Var9*0.65*sin(V_Var4*V_Var4*16*V_Time*float2(1,1.2));


  xy-=pow(0.25+0.85*distance(float2(1,0.75)*(xy-0.5)+0.5,0.5),0.35)*V_Var9;
  //xy+=0.125;
  float deg=0.5*atan((xy.y-oy)*0.75/(xy.x-ox));

  deg=3.14/4+(deg+1.57*(xy.x>ox*0.9999));
  deg=deg/3.1415;


  V_Var1=int(1/(1-pow(V_Var1*0.87+0.1,0.35)));
  deg=deg*V_Var1;
  float widthf=2*abs(V_Var2-0.5);
  V_Var2=(1-widthf)/V_Var1+V_Var2*widthf;

  deg=V_Var2*1.86*abs(frac(deg)-0.5)+0.05+V_Var7*0.86*2*(1-V_Var2)-(V_Var5-0.5)*(V_Var5-0.5)*(V_Var5-0.5)*16*V_Time;
  float di=1-distance(float2(xy.x,xy.y*0.75),float2(ox,oy*0.75));
  //deg=1-2*abs(deg-int(deg)-0.5);
  V_Var8=1-V_Var8;
  V_Var8=V_Var8*V_Var8*V_Var8;

  di=1-pow(di,64*V_Var8);//*di*di*di*di*di*di*di*di*di*di;
  di=di-V_Var4*V_Var4*V_Var4*64*V_Time+V_Var6*4;
  di=(1-di*(V_Var3*V_Var3*8*(1-V_Var8)));

  di=2*abs(frac(di)-0.5);
  
  color=tex2D(Sampler, frac(float2(di,deg)));
  color=color;

  color.a = V_Alpha * color.a;
  return color;
}

technique PlrKaleidoscope
{
  pass PassKld
  {
    VertexShader = null;
    PixelShader  = compile ps_2_a PS();
  }
}
