

struct VS_OUTPUT {  float4 Position: POSITION;  float4 Tex0:     TEXCOORD0;};

sampler t0 = sampler_state{  MipFilter = LINEAR;  MinFilter = LINEAR;  MagFilter = LINEAR;};
sampler t1 = sampler_state{  MipFilter = LINEAR;  MinFilter = LINEAR;  MagFilter = LINEAR;};

float V_Alpha : ALPHA;
float V_Time : TIME;
float V_InvH : INVSCREENH;
float V_InvW : INVSCREENW;
float V_Var1 : VAR1;
float V_Var2 : VAR2;
float V_Var3 : VAR3;
float V_Var4 : VAR4;
float V_Var5 : VAR5;
float V_Var6 : VAR6;
float V_Var7 : VAR7;
float V_Var8 : VAR8;
float V_Var9 : VAR9;
float V_Var10 : VAR10;
float V_Var11 : VAR11;
float V_Var12 : VAR12;
float V_Var13 : VAR13;
float V_Var14 : VAR14;
float V_Var15 : VAR15;
float V_Rand1 : RAND1;
float V_Rand2 : RAND2;
VS_OUTPUT VS(float4 In : POSITION0){VS_OUTPUT Out;Out.Position = Out.Tex0 = sign(In);Out.Tex0*=float4(1.0,-1.0,1.0,1.0);Out.Tex0.xy=Out.Tex0.xy*0.5+0.5;return Out;}
float2 r(float a,float2 xy,float2 pv){xy-=pv;return float2(xy.x*cos(a)-xy.y*sin(a)+pv.x,xy.x*sin(a)+xy.y*cos(a)+pv.y);}
float4 PS(VS_OUTPUT In) : COLOR0
{  
  float2 xy=In.Tex0.xy+.5*float2(V_InvW,V_InvH);
  float2 aspect=float2(V_InvH/V_InvW,1.0);
  float2 rxy=step(abs(sin(3.1416*0.5*xy/float2(V_InvW,V_InvH))),0.1);
  float4 color = 0.0;
  color=tex2D(t0,xy);
  float2 w=float2(V_InvW,V_InvH)*2.0*V_Var1;
  float4 _11 = tex2D(t0, xy + w*float2(-1.0, -1.0));
  float4 _12 = tex2D(t0, xy + w*float2( 0.0, -1.0));
  float4 _13 = tex2D(t0, xy + w*float2( 1.0, -1.0));
  float4 _21 = tex2D(t0, xy + w*float2(-1.0,  0.0));
  float4 _23 = tex2D(t0, xy + w*float2( 1.0,  0.0));
  float4 _31 = tex2D(t0, xy + w*float2(-1.0,  1.0));
  float4 _32 = tex2D(t0, xy + w*float2( 0.0,  1.0));
  float4 _33 = tex2D(t0, xy + w*float2( 1.0,  1.0));
  
  float4 x = -_11 - (2*_21) - _31 + _13 + (2*_23) + _33;
  float4 y = +_11 + (2*_12) + _13 - _31 - (2*_32) - _33;

  float4 c = sqrt((x*x)+(y*y));
  c=lerp(c,max(c.r,max(c.g,c.b)),(V_Var2-0.5)*4.0+0.5);
  //float4 h=pow(color,V_Var2/(1.0-V_Var2));
  float4 h=color/max(color.r,max(color.g,color.b));
  h=h*smoothstep(0.0,0.2,length(color.rgb-dot(color.rgb,0.333)));
  h=pow(h*0.999,8.0);
  color=c*V_Var4/(1.0-V_Var4)+h*V_Var3/(1.0-V_Var3);
  color=pow(color,V_Var5/(1.0-V_Var5));
  color.a=V_Alpha;  
  //color+=step(xy.x,V_Var5);
  return color;
}

technique t
{
  pass p0
  {
    VertexShader = compile vs_3_0 VS();
    PixelShader = compile ps_3_0 PS();
  }
}

