/*
 * Sprite.h
 *
 *  Created on: 12 dec 2011
 *      Author: Reii
 */

#ifndef SPRITE_H_
#define SPRITE_H_

#include <SDL/SDL.h>
#include "Image.h"
#include <string>
#include <vector>

class Sprite{

public:
	virtual void tick(std::vector<Sprite*>& gameobjects)=0;
	virtual void draw() =0;
	virtual void mouseDown(int x, int y);
	virtual void mouseUp(int x, int y);
	virtual void mouseMoved(int x, int y);
	virtual void keyDown(SDLKey key);
	virtual void keyUp(SDLKey key);
	virtual bool hasCollided(const Sprite* other);
	virtual void detectBorderCollision();
	virtual ~Sprite();
	void moveSprite(int x, int y);
	void setXspeed(int speed);
	void setYspeed(int speed);
	int getXspeed();
	int getYspeed();
	int getX();
	int getY();
	Image* getImage()const;
	SDL_Rect getRect()const;
protected:
	Sprite(std::string filename, bool transparent, bool multi, int x, int y);
	Sprite(Image* img, bool multi, int x, int y);
private:
	Image* img;
	SDL_Rect collisionBox;
	int xSpeed, ySpeed;
	Sprite(const Sprite&);
	const Sprite& operator=(const Sprite&);
};

#endif /* SPRITE_H_ */
