#import "DisplayViewController.h"
BOOL camMode = NO;
BOOL shutting = NO;

@interface DisplayViewController ()

@end

@implementation DisplayViewController

CGSize mySize;
GPUImageView *primaryView;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    

    return self;
}

- (void)dealloc
{
    [renderer release];
    
    [super dealloc];
}

- (void)initRenderer
{
    renderer = [[ES2Renderer alloc] initWithSize:mySize];
    
    textureInput = [[GPUImageTextureInput alloc] initWithTexture:renderer.outputTexture size:mySize];
    //    filter = [[GPUImagePixellateFilter alloc] init];
    //    [(GPUImagePixellateFilter *)filter setFractionalWidthOfAPixel:0.01];
    
    filter = [[GPUImageThresholdEdgeDetection alloc] init];
    
    [textureInput addTarget:filter];
    [textureInput addTarget:(GPUImageView*)self.view];
    
    [filter addTarget:(GPUImageView*)self.view];
    
    [renderer setNewFrameAvailableBlock:^{
        float currentTimeInMilliseconds = [[NSDate date] timeIntervalSinceDate:startTime] * 1000.0;
        
        [textureInput processTextureWithFrameTime:CMTimeMake((int)currentTimeInMilliseconds, 1000)];
    }];
}

- (void)initRenderer_cam
{
    
    renderer = [[ES2Renderer alloc] initWithSize_cam:mySize];
    
    [textureInput dealloc];
    
    textureInput = [[GPUImageTextureInput alloc] initWithTexture:renderer.outputTexture size:mySize];
    //    filter = [[GPUImagePixellateFilter alloc] init];
    //    [(GPUImagePixellateFilter *)filter setFractionalWidthOfAPixel:0.01];
    
    filter = [[GPUImageThresholdEdgeDetection alloc] init];
    
    [textureInput addTarget:filter];
    [textureInput addTarget:(GPUImageView*)self.view];
    
    [filter addTarget:(GPUImageView*)self.view];
    
    shutting = NO;
    
    [renderer setNewFrameAvailableBlock:^{
        float currentTimeInMilliseconds = [[NSDate date] timeIntervalSinceDate:startTime] * 1000.0;
        
        [textureInput processTextureWithFrameTime:CMTimeMake((int)currentTimeInMilliseconds, 1000)];
    }];
}


- (void)loadView
{    
    
    CGRect mainScreenFrame = [[UIScreen mainScreen] applicationFrame];	
	primaryView = [[GPUImageView alloc] initWithFrame:mainScreenFrame];
	self.view = primaryView;
    mySize = [primaryView sizeInPixels];

    [self initRenderer];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

- (void)drawView:(id)sender
{
}

#pragma mark -
#pragma mark Touch-handling methods

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSMutableSet *currentTouches = [[[event touchesForView:self.view] mutableCopy] autorelease];
    [currentTouches minusSet:touches];
	
	// New touches are not yet included in the current touches for the view
	lastMovementPosition = [[touches anyObject] locationInView:self.view];

    if (lastMovementPosition.x < 100 && camMode == NO) {
        shutting = YES;
        camMode = YES;
        [renderer setNewFrameAvailableBlock:^{
        }];

        
        [self initRenderer_cam];
    }
}


@end
