;SID-WIZARD SID-Maker (makes PRG/SID from SWM workfile)
;----------------------------------------------------------

;=====================================CONSTANTS==========================================
;CAUTION: SEQUENCE/PATTERN/TABLE DELIMITERS ($FE/$FF/$7E/$7F,TEMPOTABLE BIT7) ARE HARDWIRED, NEVER EVER MODIFY THEM!!!

CHEATRASTERTIME=0 ;DON'T CHEAT WITH RASTERTIME (ONLY IN EDITOR!!! COMPENSATED CPU-CYCLES STOLEN BY ORDERLIST-SPRITES)

;================================= BASIC area start ===============================================================
*=$0801
		.word ss,2005
		.null $9e,^2064 ;Sys 2064
ss		.word 0

;================================= Code part 1 ================================
*=$0810      ;INITIALIZATION AT PROGRAM START - set IRQ handlers, screen, and main VIC registers
		sei
		lda $ba ;the default device might be where SID-Maker was loaded from
		cmp #14 ;if above 13, force 8 as default
		bcs +
		cmp #8 
		bcs ++ ;if below 16 and greater than / equal to 8, no forcing, leave as it is 
+		lda #8 ;default device number if exporter was loaded from non-disk drive 
+		sta devicen+1
		lda #$35
		sta banksel
imports	lda #$ff ;initialize output-format to a unique value
		sta outputformat
		lda #>PLAYERADDR
		sta relocaddr ;reset reloc.address (to be safe about next tune being in range
		ldx #2 ;set SID-Wizard module extension to import
-		lda SWMext,x
		sta swftype+1,x
		dex
		bpl -
		lda #2
		sta defawin+1 ;file-selector is preferred default subwindow in filer (but changeable with TAB)
		jsr reredir ;read directory, typing filename, return filename in 'namebuf'
		bcs imports ;if Carry=1 on exit, restart file-handler (no returning to anywhere, like in tracker)
;load tune (notify if unsuccessful) - fastloader may fit in memory (and could be selected with Shift+Return)
		jsr iniwfn  ;(secondary address inside = 0 ensures load-address forcing)
		jsr OPEN ;open file for checking version in its beginning
		jsr READST ;read drive status
		cmp #0 ;if status is 0, no error
		beq chSWVer ;check if file exists, if exists, go to check filetype/version
		jsr clsfile ;in case of error, close to allow further trials
		jmp fnotfnd
ChSWVer	jsr CheckSWM ;check filetype version of SWM module in 1st 4 bytes, if different version, refuse the tune and init SWM1 
		bcc SWverOK ;if carry is 0, no version mismatch, go to loader
		jsr clsfile ;in case of version-mismatch, close to allow further trials
		ldy #28 ;if carry was 1, filetype or version is not OK!
-		lda vermismatch,y
		sta lowvidram+40*24,y
		dey
		bpl -
		lda readver ;display selected file's version or 1st mismatching character
		sta lowvidram+40*24+14
		jmp wtspace
SWverOK	jsr clsfile ;quit testing, start fresh loading
		jsr iniwfn  ;(secondary address inside = 0 ensures load-address forcing)
+		ldx #<MUSICDATA ;set musicfata base load-address just after player-code
        ldy #>MUSICDATA
        lda #$00      ; $00 means: load to memory (not verify)
        jsr LOAD      ; call LOAD, outputs last loaded address to X/Y in case of success
        bcc +         ; if carry set, a load error has happened
fnotfnd	ldy #28 ;Display 'file not found' message and wait for SPACE
-		lda fnotfound,y
		sta lowvidram+40*24,y
		dey
		bpl -
wtspace	jsr waitspace
		jmp imports
+		stx compzptr  ;end of data is important info for depacker to start in-place backwards-decompression
		sty compzptr+1
		
;prepare tunedata (crop unneeded module-data) and set player absolute addresses accordingly, set SID header
preptune ;tune-data loaded, compzptr was set to end of loaded data
		sei
		lda #$35
		sta banksel ;ensure consistent variable and tune-data area
jsr preparetunedata ;exits with compzptr pointing to end of data
		
jsr SetSIDt ;set SID-text
		
jsr setplayer ;adjust player routine's absolute addresses 
		
		;lda #>PLAYERADDR ;init relocation-address
		;sta relocaddr
jsr setexport ;ask user for input (tune-type and reloc.address) needed for exporting
		
		lda outputformat
		cmp #2 ;if EXEcutable, no need for tune-relocation
		beq +
		lda relocaddr ;if no relocation needed
		cmp #>PLAYERADDR
		beq +
jsr relocator ;RELOCATE logical address of player!!! (in relocator.inc)
		+
		
exporter  ;convert/export (save) tune
		lda outputformat ;set extension for output-format
		asl
		adc outputformat
		tax ;accu multiplied by 3
		ldy #0 
-		lda exportext,x
		sta swftype+1,y
		inx
		iny
		cpy #3 ;extension-length is 3
		bne -
		
;----------------------------------------
savexpo	sei
		;lda #$35
		;sta banksel
		lda #0
		sta defawin+1 ;filename-typer is default subwindow in filer (but changeable with TAB)
-		jsr reredir ;read directory, typing filename, return filename in 'namebuf'
		bcc ++ ;if user is exiting from export-filedialog
		lda relocaddr ;check if there was no relocation
		cmp #>PLAYERADDR
		beq + ;if it was normal save
		jsr unrelocate ;correct player by reverting relocation
+		jmp imports ;start all over again (importing) if user exits exporter
		+
;save tune (check and ask about existing file or any saving error?)
setsaveparam ;set saving range and filetype
		lda outputformat
		bne + ;C64 native code?

;0.Saving in native C64 PRG format (with load-address)
ExpoC64	lda relocaddr ;if no relocation needed
		cmp #>PLAYERADDR
		bne reloced ;if tune is to be relocated
		jmp NorSave ;normal save (compatible mode for saving - without relocation
reloced	jsr appendPRGW ;append PRG file Writing string to filename
		lda #<PLAYERADDR ;Set Start Address
		ldx #>PLAYERADDR
		jmp SaveExp

+		cmp #1 ;Binary native code without 2-byte load-address?
		bne +
;1.Saving in native C64 RAW (BIN) binary format (raw file without load-address)
ExpoBIN	jsr appendSEQW ;append SEQ file Writing string to filename
		lda #<PLAYERADDR ;Set Start Address
		ldx #>PLAYERADDR
		jmp SaveExp

+		cmp #2 ;Executable file for C64 command prompt?
		bne +
;2.Saving in runnable C64 PRG file format
ExpoEXE	lda expoendadd+0 ;set EXEcutable code's pointers for copying tune-data
		sta (EXEtgtL+1-BASICbe)+EXEstarter
		sec
		sbc #<(SIDHEADER-(BASICbe+EXEstarterSize))
		sta (EXEsrcL+1-BASICbe)+EXEstarter
		lda expoendadd+1
		sta (EXEtgtH+1-BASICbe)+EXEstarter
		sbc #>(SIDHEADER-(BASICbe+EXEstarterSize)) ;involve Carry-flag
		sta (EXEsrcH+1-BASICbe)+EXEstarter
		ldy TUNEHEADER+FSPEEDPOS ;framespeed of loaded tune (in header)
		lda frmspds,y ;check framespeed-program lookup table in datatables.inc
		sta fspdsto+1
		dey
		beq appendn ;if 1x single-speed, don't disturb table
-		tya
		clc
fspdsto	adc #0  ;silf-written - add base-position of actual rasterspeed 
		tax
		lda framers,x  ;get actual frameraster from table
		sta (EXEframes-BASICbe)+EXEstarter,y ;graving into the executable-code
		dey
		bne - ;place 0 never changes (basic position of single-speed player routine)
appendn	jsr appendPRGW ;append PRG file Writing string to filename
		lda #<EXEstarter ;Set Start Address
		ldx #>EXEstarter
		jmp SaveExp

+		cmp #3 ;SID binary file? With/without load-address?
		bne +
;3.Saving in SID binary (SEQ) format
ExpoSID	jsr appendSEQW ;append SEQ file Writing string to filename
		lda #<SIDHEADER ;Set Start Address
		ldx #>SIDHEADER
		jmp SaveExp

+		jmp imports ;if illegal format might be selected somehow

;Common point for saving
SaveExp	jsr inidptr ;set decozptr as startaddress (by A and X)
		;init workfile name pointer and length, bank, and device,file,channel
		lda #$36 ;init workfile name pointer and length, bank, and device,file,channel
		sta banksel
		lda bufnln2 ;appended filename-length
		ldx #<namebuf ;point to appended (,S,W or ,P,W) filename
		ldy #>namebuf
		jsr SETNAM   ;init filename pointer and length, and device,file,channel
		lda #1                  ;   file # 1
		ldx #ddevice  ;self-written, device # 8 is default (modifiable by user)
		ldy #2                  ;   channel # 2 ;this can be used for SEQ file formats
		jsr SETLFS              ; - call setlfs
		jsr OPEN ;open the file for writing
		bcc OKtoSav ;check if file exists, if exists, go forward with saving
SavErr	lda outputformat
		bne + ;if native output, try normal SAVE to keep compatibility
		jsr clsfile ;need a fresh start
		jmp NorSave ;compatible saving mode
+		cmp #3 ;if SID-saving, tolarate error by saving SID with load-address
		bne +
		jsr clsfile ;need a fresh start
		jsr iniwfn ;init workfile name pointer and length, bank, and device,file,channel
		lda #<SIDHEADER ;Set Start Address
		ldx #>SIDHEADER
		jmp NorSav2 ;try with compatible SAVE
+		ldy #28 ;Display 'file not found' message and wait for SPACE
-		lda saveerror,y
		sta lowvidram+40*24,y
		dey
		bpl -
		jsr READST ;read status error-code
		clc
		adc #"0" ;shift numbering for status-number display to be PETSCII compatible
		sta lowvidram+40*24+14 ;display status error-code
		jsr waitspace ;wait for SPACE key press/release 
		jsr clsfile ;in case of error, close to allow further trials
		jmp savexpo ;try again when saving error occurs
		;perform the saving if device is present and file could be opened for writing
OKtoSav	ldx #$01                ;   file #1
		jsr CHKOUT               ; - call chkout to set output file #.
		
		lda outputformat ;check if load-address should be written into the file (PRG)
		bne + ;C64.PRG?
		lda #<PLAYERADDR
		jsr CHROUT
		lda relocaddr
		jsr CHROUT
		jmp SaveDat
+		cmp #2 ;EXE.PRG?
		bne SaveDat
		lda #$01 ;set C64 BASIC-program start address $0801 to run standalone
		jsr CHROUT
		lda #$08
		jsr CHROUT
		
SaveDat	ldy #0 ;reset Y to always be 0 while saving
saveloop ;save effective file-content byte-by-byte
		jsr READST 
		bne SavErr ;if inbetween error occurs, handle it
		lda (decozptr),y
		jsr CHROUT ;write byte to disk
		inc decozptr+0
		bne +
		inc decozptr+1
+		lda decozptr+0 ;check if end of file
		cmp expoendadd+0
		lda decozptr+1
		sbc expoendadd+1
		bcc saveloop
		ldx #$00      ; filenumber 0
		JSR CHKOUT     ; call CHKOUT (reset output device to prevent typings being written to disk)
		
		jsr clsfile ;close file #1
		
expdone	jmp savexpo ;export done, return back to importer (or export-setter?)
;		sei ;internally test/debug tune
;		lda #0
;		jsr inisub
;-		lda #$80
;		cmp $d012
;		bne *-3
;		dec $d020
;		jsr playsub
;		inc $d020
;		jmp - ;*


SWMext .text "SWM" ;importable SID-Wizard module extension
filetyp .text "SWM" ;3 BYTE FILETYPE-DESCRIPTION - abbreviation of 'SID-WIZARD MODULE'
version .text SWversion ; VERSION 1 of the module format
outputformat .byte 0 ;the desired exporting output format (PRG/SEQ/EXE/SID)
exportext ;extensions for export-types
.text "C64" ;0
.text "BIN" ;1
.text "EXE" ;2
.text "SID" ;3


;=======================================================================================
NorSave ;normal save (compatible mode for saving - without relocation
		jsr iniwfn ;init workfile name pointer and length, bank, and device,file,channel
		lda #<PLAYERADDR ;Set Start Address
		ldx #>PLAYERADDR
NorSav2	jsr inidptr ;set decozptr as startaddress (by A and X)
		lda #<decozptr ;pointer of start-address
		ldx expoendadd+0  ;Get End Address of tunedata to export/save
		ldy expoendadd+1
		jsr SAVE
		bcs fexists ;if error
		jmp expdone ;if no error, export is finished
fexists ldy #28 ;display 'file exists'  (and later ask for overwrite-confirmation)
-		lda filexists,y
		sta lowvidram+40*24,y
		dey
		bpl -
		jsr YesOrNo ;wait for Y/N and set Carry accordingly (1 if Y) 
		bcs + ;if yes, try other name (maybe better not to start all over again if mistake by user)
		jmp imports ;if answered NO, return to importers
+		jmp savexpo
		
;-------------------------------some subroutines------------------------
appendSEQW ;append SEQ file Writing string to filename
		ldx bufnlen+1 ;length of selected/typed filename with extension
		ldy #0
-		lda SEQwriTxt,y
		beq + ;end of string?
		sta namebuf,x
		sta $8000,x
		inx
		iny
		cpy #8 ;safety-check
		bne -
+		stx bufnln2 ;adjust filename-length to be expanded with ",S,W"
		rts
		
appendPRGW ;append PRG file Writing string to filename
		ldx bufnlen+1 ;length of selected/typed filename with extension
		ldy #0
-		lda PRGwriTxt,y
		beq + ;end of string?
		sta namebuf,x
		sta $8000,x
		inx
		iny
		cpy #8 ;safety-check
		bne -
+		stx bufnln2 ;adjust filename-length to be expanded with ",P,W"
		rts

;--------------------------
makertxt1 
.if LIGHTVERSION=0
		.text "*** SID-MAKER  FOR HERMIT SID-WIZARD ***"
.else
		.text "* SID-MAKER-LIGHT FOR SID-WIZARD-LIGHT *"		
.fi
makertxt2 .text "----------------------------------------"
makertxt3 .text "PLEASE SELECT OUTPUT FORMAT WITH CURSOR:"
makertxt4 .text " C64/PRG   BIN/SEQ    EXE/PRG   SID/SEQ "
makertxt5 .text " (NORMAL) (RAW DATA) (RUNNABLE) (PC-SID)"
makertxt6 .text "PLEASE SELECT RELOCATION ADDRESS VIA +/-"
makertxt7 .text "    RELOC. TARGET ADDRESS IS: $0000     "
makertxt8 .text "SELECT SID-MODEL WITH CURSOR: DETECTING!"
OldSIDtxt .text "6581 (OLD)"
NewSIDtxt .text "8580 (NEW)"
blockdelim   .byte 1,10,21,32
blockdeli2	 .byte 9,20,31,40


;---------------------------------some routines -------------------------------
relozptr	;add 16 bit 2's complement 'relative' value (in relocamount) to zeropage-pointer assigned in Y register
		lda relocamount+0
		clc
		adc $00,Y
		sta $00,Y
		iny ;to point to hi-byte of zeropage-pointer
		lda relocamount+1
		adc $00,Y
		sta $00,Y
		rts

inveblk	;invert bisplay-block 
		ldx outputformat
		lda blockdelim,x
		sta compzptr 
		lda blockdeli2,x
		sta compzptr+1
		ldy #$27
-		lda $04c8,y
		and #$7f
		cpy compzptr
		bmi +
		cpy compzptr+1
		bpl +
		ora #$80
+		sta $04c8,y
		dey
		bpl -
		rts
		
keyrele	lda #$fe 
		sta $dc00
keyrelp	lda $dc01 ;wait for key-releasing
		cmp #$ff
		bne keyrelp
		rts

disrelo	lda relocaddr ;display hexa relocation target address
		jsr hexdisp 
		tay
		lda hexchar,y
		sta $05d7
		lda hexchar,x
		sta $05d8
		;handle if player-address is not on boundaries
		lda #<PLAYERADDR
		jsr hexdisp
		tay
		lda hexchar,y
		sta $05d9
		lda hexchar,x
		sta $05da
		rts

hexdisp	pha   ;input:accu, output: nybbles in Accu and X-register 
		and #$0f
		tax
		pla
div16	lsr
		lsr
		lsr
		lsr
		rts
		
waitspace ;wait for SPACE press and release
		lda #$7f 
		sta $dc00
-		lda $dc01 ;wait for pressing SPACE
		cmp #$ff
		beq -
-		lda $dc01 ;wait to release SPACE
		cmp #$ff
		bne -
		rts
		
;set SID text (author name and tune-title)
SetSIDt	ldx #0 ;will show the position of ':' - if no separator, value will stay 0
		ldy #39
-		lda authorinfo,y
		cmp #":" ;if there's a ':' separator, the string before will be handled as author-name
		bne +
		tya ;only the 1st ':' will be used as split-separator
		tax
+		dey
		bpl -
		cpx #0
		bne splitTX ;if ':' was found 
noSplit	ldy #31 ;SID-header text field max. size
-		lda #0 ;reset author-info text
		sta SIDauthrtx,y
		lda authorinfo,y
		sta SIDtitletx,y
		dey
		bpl -
		rts
splitTX	cpx #32-1
		bpl noSplit ;if the separator is at illegal place (authorname would be longer than allowed 32  
		lda #0
		sta SIDauthrtx,x ;put '0' string-termination
		txa
		tay
-		lda authorinfo-1,y ;right before ':'
		sta SIDauthrtx-1,y
		dey
		bne -
		ldy #0
-		lda authorinfo+1,x ;right after ':'
		sta SIDtitletx,y
		iny
		cpy #32-1 ;max text field-length in SID-header
		beq +
		inx
		cpx #40
		bne -
+		lda #0 ;put '0' string-termination
		sta SIDtitletx,y
		rts

;------------------------------------------------------------------
;SID DETECTION ROUTINE ;By SounDemon - Based on a tip from Dag Lem.
;Put together by FTC after SounDemons instructions ;...and tested by Rambones and Jeff.
;Idea: there is a one cycle delay in the oscillator on 8580 compared to 6581 when turned on.
; - Won't work in VICE (always detects 6581) unless resid-fp emulation is enabled
detectSIDtype ;X is 0 at return if 6581, 1 if 8580
	sei		;No disturbing interrupts
	lda #$ff
	cmp $d012	;Don't run it on a badline.
	bne *-3
	lda #$ff	;Set frequency in voice 3 to $ffff 
	sta SIDBASE+$12	;...and set testbit (other bits doesn't matter) in $d012 to disable oscillator
	sta SIDBASE+$0e
	sta SIDBASE+$0f
	lda #$20	;Sawtooth wave and gatebit OFF to start oscillator again.
	sta SIDBASE+$12
	lda SIDBASE+$1b	;Accu now has different value depending on sid model (6581=3/8580=2)
	lsr		;...that is: Carry flag is set for 6581, and clear for 8580.
	ldx #1 ;transfer Carry-flag to X
	bcc +
	dex ;X=0
+	jsr dispMod ;display and set SID-Model in SID header, based on X register
	rts

dispMod	ldy #9 ;display and set SID-model based on X register
-		lda NewSIDtxt,y
		cpx #1 ;check if 8580
		beq + ;branch if 8580
		lda OldSIDtxt,y
+		sta $0676,y
		lda SIDflags+1
		and #%11001111
		ora ModelFlag,x ;SID-model 
		sta SIDflags+1
		dey
		bpl -
		rts
ModelFlag .byte $10,$20 ;SID-model bits to SIDflags

;===============================================================================================================
;variables
;---------
namemode .byte 2 ;if value is 2, filename-typing/selection mode
menumode .byte 0 ;if value is nonzero, the menu appears above music editor (display of musicdata stops)
ptrdysi  .byte 0 ;signal that notifies key-repeater to wait for pattern-redraw

importxt
.if LIGHTVERSION=0
		.text " SELECT A SW-MODULE TO CONVERT TO SID.. "
.else
		.text " SELECT A SW-LIGHT MODULE TO CONVERT .. "
.fi
bufnln2  .byte 0 ;the length of the appended filename

;===============================================================================================================
.cerror *>EXEstarter,"TOO MUCH CODE BEFORE PLAYER DOESN'T FIT IN MEMORY. MOVE SOME CODE TO UPPER FREE AREAS!"

;FROM HERE TILL END OF PLAYER DATA DO NOT INSERT ANY CODE!!! ALL SPACE IS KEPT FOR SID TUNE ITSELF
;================================= BASIC-starter for executable export ==========================================
EXEstarterSize=$100 
*=SIDHEADER-EXEstarterSize
EXEstarter ;executable-SID startercode
.logical $0801 ;set logical compilation address
BASICbe	.word ss2,2005
		.null $9e,^2064 ;Sys 2064
ss2		.word 0
		.byte 0,0,0 ;to align to $0810
;address 2064 ($0810) - INITIALIZATION AT PROGRAM START - set IRQ handlers, screen, and main VIC registers
		sei
		lda #$35
		sta 1
		lda #EXEBGROUND ;init screen
		sta $d021
		lda #$17 ;small character set
		sta $d018
		ldy #0
-		lda #$20 ;clear screen
		sta $0400,y
		sta $0500,y
		sta $0600,y
		sta $0700,y
		lda #EXETEXTCOL
		sta $d800,y
		sta $d900,y
		sta $da00,y
		sta $db00,y
		iny
		bne -
		;copy SID-tune to correct location
EXEsrcL	lda #0 ;set source-address  -self-written code
		sta compzptr
EXEsrcH	lda #0 ;self-written code
		sta compzptr+1
EXEtgtL	lda #0 ;set target-address  -self-written code
		sta decozptr
EXEtgtH	lda #0 ;self-written code
		sta decozptr+1
		ldy #0
EXEcopy	lda (compzptr),y ;read data from source
		sta (decozptr),y ;write data to destination
		lda compzptr+0
		bne +
		dec compzptr+1
+		dec compzptr+0
		lda decozptr+0
		bne +
		dec decozptr+1
+		dec decozptr+0
		lda compzptr+0
		cmp #<(BASICbe+EXEstarterSize)
		lda compzptr+1
		sbc #>(BASICbe+EXEstarterSize)
		bcs EXEcopy
;play the tune
		sei
		ldy #39 ;display author-info
-		lda authorinfo,y ;SIDtitletx,y
		sta $0400+10*40,y
		lda madewith,y 
		cmp #$60
		bcc +  ;handle lowercase
		and #$1f
+		sta $0400+24*40,y
		dey
		bpl -
		lda #0
		jsr inisub
rast1st	lda #0
		sta fspdctr+1 ;reset framespeed-counter
		lda EXEframes+0
		cmp $d012
		bne *-3
		lda #EXEBARCOL1
		sta $d020
		jsr playsub
		lda #EXEBORDCOL
		sta $d020
		lda $d012 ;wait for bit9 of raster-counter to be reset (arrive to lower rasterline-area)
		bne *-3
fsploop	inc fspdctr+1 ;go to next multispeed frame
fspdctr	ldy #0 ;self-written - framespeed-counter
		cpy TUNEHEADER+FSPEEDPOS ;check if reached actual framespeed
		beq rast1st 
		lda EXEframes,y
		cmp $d012
		bne *-3
		lda #EXEBARCOL2
		sta $d020
		jsr mulpsub ;multiplay part of the player routine ($1006)
		lda #EXEBORDCOL 
		sta $d020
		jmp fsploop

madewith
.if LIGHTVERSION=0
		.text "      -- Composed with SID-Wizard v"
.else
		.text "-- Composed with SID-Wizard-light v"		
.fi
		 .BYTE SWversion
		 .text " -- "
		 
;framespeed-program - overwritten/generated by exporter for specific rasterspeeds
EXEframes .byte $fe,dist8-subrast, 2*dist8-subrast, 3*dist8-subrast, 4*dist8-subrast-1, 5*dist8-subrast-1, 6*dist8-subrast-2, 7*dist8-subrast-3 

.here ;restore physical address
.cerror *>(EXEstarter+EXEstarterSize),"YOU MUST ENSURE MORE PLACE ('EXESTARTERSIZE') FOR RUNNABLE-SID STARTER CODE!"
;-------------------------------------------------------------------------------

SIDHEADERSIZE=$7c
*=CIAADDR-SIDHEADERSIZE ;...SID file-format header
SIDHEADER
;SID v1 header - big endian (!!!) WORD (byte-pair) values most of the time
;--------------
.TEXT "PSID" ;+00 magicID: 'PSID' or 'RSID'  (RSID stands for strict SID that requires full, real C64 environment or full emulation
.BYTE $00,$02 ;+04 version ;can either be 0001 or 0002. Headers of version 2 provide additional fields. RSID and PSID v2NG files must have 0002 here.
.BYTE $00,$7C ;+06 dataOffset ;offset from the start of the file to the C64 binary data area. fixed size of the header, this is either 0x0076 for version 1 and 0x007C for version 2.
.BYTE $00,$00 ;+08 loadAddress ;C64 memory location where to put the C64 data. 0 means the data are in original C64 binary file format, must NOT be less than $07E8 in RSID files.
SIDinitadd .BYTE >CIAINIT,<CIAINIT ;+0A initAddress ;start address of the machine code subroutine that initializes a song,accepting the contents of the 8-bit 6510 Accumulator as the song number parameter. 0 means the address is equal to the effective load address.
SIDplayadd .BYTE >CIAPLAY,<CIAPLAY ;+0C playAddress ;start address of the machine code subroutine that can be called frequently to produce a continuous sound. 0 means the initialization subroutine is expected to install an interrupt handler, which then calls the music player at some place. This must always be true for RSID files.
SIDstamount .BYTE $00,$01 ;+0E songs ;The number of songs (or sound effects) that can be initialized by calling the init address. The minimum is 1. The maximum is 256.
SIDdefasubt .BYTE $00,$01 ;+10 startSong ;The song number to be played by default. This value is optional. It often specifies the first song you would hear upon starting the program is has been taken from. It has a default of 1.
.BYTE $FF,$FF,$FF,$FF ;+12 LONGWORD speed ;32 bit big endian number. Each bit in 'speed' specifies the speed for the corresponding tune number, i.e. bit 0 specifies the speed for tune 1. 0 bit specifies vertical blank interrupt (50Hz PAL, 60Hz NTSC), and a 1 bit specifies CIA 1 timer interrupt (default 60Hz).
SIDtitletx .FILL $20,0 ;+16 <title> ;32 byte long zero terminated ISO 8859-1 ASCII character strings. zero byte will always be put into the last byte of each string. So the maximum number of available free characters is 31.
SIDauthrtx .FILL $20,0 ;+36 <author>
SIDreleatx .FILL $20,0 ;+56 <released> (also known as <copyright>)
;SID v2 header extensions:
;-------------------------
SIDflags .BYTE %00000000, %00100100 ;+76 flags ;16 bit big endian number containing the following bitfields: bit0-binary data format (0-built-in player,1-Compute MUS player must be merged), bit1-(0-C64 compatible,1-PlySID specific/C64 BASIC flag for RSID), bit2..3-video standard(01-PAL,10-NTSC), bit4..5-SID model (00-?,01-6581,10-8580,11-both), other bits:0.
.BYTE $00 ;+78 startPage (relocStartPage) ;8 bit number. If 'startPage' is 0, the SID file is clean, i.e. it does not write outside its data range within the driver ranges. If 'startPage' is 0xFF, there is not even a single free page, and driver relocation is impossible.if 'startPage' is 0x1E, this free memory range starts at $1E00.
.BYTE $00 ;+79 pageLength (relocPages) ;8 bit number indicating the number of free pages after 'startPage'. If 'startPage' is not 0 or 0xFF, 'pageLength' is set to the number of free pages starting at 'startPage'. If 'startPage' is 0 or 0xFF, 'pageLength' must be set to 0.
.BYTE $00,$00 ;+7A reserved ;This is a 16 bit number and is reserved and should be set to 0.
;--------------------------------------------------------------------------------------------------------
;+7C    <data> ;Version 2 of the SID header ends here. This offset is the start of the binary C64 data.
;---------------------------------------
*=CIAINIT-2 ;load-address of the tune - will be modified by relocator
CIAADDR	.byte <CIAINIT,>CIAINIT ;relocator won't modify this
;------ Multispeed SID CIA-based player routine
*=PLAYERADDR-$48
CIAINIT	ldy TUNEHEADER+FSPEEDPOS
		lda #$35 ;enable SID-playing in ROMs too
		sta banksel 
p_SIDa1	ldx CiaFrameHi,y ;$13 for 4X  - SID CIA playing initialization
		stx $dc05
p_SIDa2	ldx CiaFrameLo,y ;$31 for 4X
		stx $dc04
		ldx #$00
p_SIDa3	stx frCount+1
p_SIDa4	jmp inisub
CIAPLAY	inc frCount+1  ;SID CIA playing routine called by IRQ in player
frCount	lda #0 ;self-written
p_SIDa5	cmp TUNEHEADER+FSPEEDPOS ;framespeed
		beq + 
p_SIDa6	jmp mulpsub
+		lda #0
p_SIDa7	sta frCount+1
p_SIDa8	jmp playsub
CiaFrameHi .byte $4c, $4c,$26,$19,$13, $0f,$0c,$0a,$09
CiaFrameLo .byte $c4, $c4,$62,$96,$31, $5a,$cb,$f7,$98
.cerror *>LOADADDR,"YOU MUST ENSURE MORE PLACE FOR CIA-BASED SID INIT/PLAY CODE!"
;************************ MUSICAL CODE AND DATA *****************************************************************
*=PLAYERADDR-2
LOADADDR .byte <PLAYERADDR,>PLAYERADDR ;relocator will modify this
;-------------------------------
*=PLAYERADDR ;($1000)
.include "include/player.asm"  ;the player/driver routine to produce the SIDDY sound
;----------------------
MUSICDATA
;.........

;====================================Code part 2 =========================================================
*=$C000 ;?
;subroutines to create PRG/SID tune
;-----------------------------------
.include "include/packdepack.inc" ;only altered depacker is used for SID-Maker

preparetunedata ;preparing tune-data for the player from saved workfile
;!!order of these calls is important!! don't modify!
		jsr depktempo ;depack/init sudtune-tempos and tempotable
		ldy #1
		lda #9-1 ;-1 to compensate missing tempoprogram 0
		sta (tempoptadd),y ;set tempo 1 pointer (not done by depacker)
		inx ;make 1 byte free after tempoprogram (for pointer of chord 1)
		txa ;X is amount of tempoprograms, depktempo exited with this result in X
		clc
		adc tempoptadd+0 ;calculate chord-pointer table base address
		sta chordptadd+0
		php
		adc #1
		sta chdptad+1
		lda tempoptadd+1
		adc #0 ;add Carry flag
		sta chdptad+2
		plp
		lda tempoptadd+1
		adc #0 ;add Carry flag
		sta chordptadd+1
		
		ldy TUNEHEADER+TMPLENPOS ;SHIFT TEMPOTBLE FORWARD BY 8
		beq +
		dey
		tya
		sta compzvar2
		clc
		adc #(RESTEMP-TEMPOTBL)
		sta compzvar3
-		ldy compzvar2
		lda (tempotbadd),y
		ldy compzvar3
		sta (tempotbadd),y
		dec compzvar3
		dec compzvar2
		bpl -
		+
;------------------------------------------------------------------
		jsr depkinsch ;depack/init chords and instruments 
		jsr ctotmpz ;store actual compzptr (pointing just after patterndata)
		;decozptr now points to beginning of 1st 'unnamed' instrument
		
		;set end-pointer for the moving in ptnptloadd
		lda TUNEHEADER+INSTAMPOS ;amount of instruments
		clc
		adc inspthiadd+0 ;set pattern lo-pointer table base address, also signs end of data to move
		sta ptnptloadd+0
		lda inspthiadd+1
		adc #0 ;add Carry flag
		sta ptnptloadd+1
		
;---------------------
;calculate the amount of move, the difference to be set in 'relocamount'
		lda compzptr+0
		sec
		sbc decozptr+0
		sta relocamount+0
		lda compzptr+1
		sbc decozptr+1
		sta relocamount+1
		
;move all previously processed data to end of patterns to crop space freed by instrument-name omission
		;and then adjust all necessary table-/instrument-pointers to this move (difference of compzptr-decozptr)
		ldy #0
-		lda (decozptr),y
		sta (compzptr),y
		iny
		bne -
		inc decozptr+1 ;increase page
		inc compzptr+1
		ldx decozptr+1
		dex ;to check at $100 bytes until end of musicdata, makes sure all $100 pages get copied
		cpx ptnptloadd+1 ;until end of musicdata is reached
		bne -
;adjust table-pointers: subtuneadd,tempoptadd,tempotbadd,chordptadd,chordtbadd,insptloadd,inspthiadd,ptnploadd,
		ldy #subtuneadd
		jsr relozptr
		ldy #tempoptadd
		jsr relozptr
		ldy #tempotbadd
		jsr relozptr
		ldy #chordptadd
		jsr relozptr
		ldy #chordtbadd
		jsr relozptr
		ldy #insptloadd
		jsr relozptr
		ldy #inspthiadd
		jsr relozptr
		ldy #ptnptloadd
		jsr relozptr
;adjust pointers in pointer-tables: insptloadd, inspthiadd
		ldy TUNEHEADER+INSTAMPOS ;amount of instruments
-		lda (insptloadd),y
		clc
		adc relocamount+0
		sta (insptloadd),y
		lda (inspthiadd),y
		adc relocamount+1
		sta (inspthiadd),y
		dey
		bne -
		
		jsr ctempzp ;restore value of compzptr to end of patterndata
;------------------------
		
;-----------------------------------------------------------------------------
		lda ptnptloadd+0
		clc
		adc TUNEHEADER+PTAMOUPOS
		sta ptnpthiadd+0
		lda ptnptloadd+1
		adc #0 ;add carry bit
		sta ptnpthiadd+1
		
		jsr depkptseq ;depack patterns and set sequence-pointers at generated 'subtunes' section (subtuneadd)

;set end-of-data pointer
		ldy TUNEHEADER+PTAMOUPOS
		iny ;point after last byte
		tya
		clc
		adc ptnpthiadd+0
		sta expoendadd+0
		lda ptnpthiadd+1
		adc #0 ;add carry
		sta expoendadd+1

		rts
		

;===================================================================================================================
setplayer ;adjust player routine's absolute addresses 
		;set subtune-related addresses
		lda subtuneadd+0
		ldx subtuneadd+1
		sta p_subt1+1
		stx p_subt1+2
		sta p_subt2+1
		stx p_subt2+2
		sta p_subt3+1
		stx p_subt3+2
		clc
		adc #1
		sta p_subt4+1
		txa
		adc #0 ;add carry
		sta p_subt4+2
		
		;set pattern-related addresses
		lda ptnptloadd+0
		ldx ptnptloadd+1
		sta p_ptnl1+1
		stx p_ptnl1+2
		sta p_ptnl2+1
		stx p_ptnl2+2
		lda ptnpthiadd+0
		ldx ptnpthiadd+1
		sta p_ptnh1+1
		stx p_ptnh1+2
		sta p_ptnh2+1
		stx p_ptnh2+2
		
		;set instrument-related addresses
		lda insptloadd+0
		ldx insptloadd+1
		sta p_insl1+1
		stx p_insl1+2
.if HARDRESTYPES_ON
		sta p_insl2+1
		stx p_insl2+2 
		sta p_insl3+1		
		stx p_insl3+2
.fi		
		sta p_insl4+1
		stx p_insl4+2
		sta p_insl5+1
		stx p_insl5+2
		lda inspthiadd+0
		ldx inspthiadd+1
		sta p_insh1+1
		stx p_insh1+2
.if HARDRESTYPES_ON
		sta p_insh2+1
		stx p_insh2+2		
		sta p_insh3+1
		stx p_insh3+2
.fi		
		sta p_insh4+1
		stx p_insh4+2
		sta p_insh5+1
		stx p_insh5+2
		
		;set tempo-table related addresses
		lda tempotbadd+0
		ldx tempotbadd+1
.if FASTSPEEDBIND_ON
		sta p_tmpt2+1
		stx p_tmpt2+2
		sta p_tmpt3+1
		stx p_tmpt3+2
.fi		
		sta p_tmpt4+1
		stx p_tmpt4+2
		sta p_tmpt6+1
		stx p_tmpt6+2
.if TEMPOPRGSUPP_ON		
		sta P_TMPT7+1
		stx P_TMPT7+2
		sta P_TMPT8+1
		stx P_TMPT8+2
.fi		
.if TEMPOPRGSUPP_ON		
		sec
		sbc #1
		sta p_tmpt1+1
		txa
		sbc #0 ;substract carry
		sta p_tmpt1+2
.else	
		sta p_tmpt1+1
		stx p_tmpt1+2
.fi		
		lda p_tmpt4+1
		clc
		adc #1
		sta p_tmpt5+1
.if TEMPOPRGSUPP_ON			
		sta p_tmpt9+1
.fi		
		lda p_tmpt4+2
		adc #0 ;add Carry
		sta p_tmpt5+2
.if TEMPOPRGSUPP_ON		
		sta p_tmpt9+2
.fi		
		
.if TEMPOPRGSUPP_ON		
		lda tempoptadd+0 ;tempo-pointer table
		ldx tempoptadd+1
		sta P_TMPP1+1
		stx P_TMPP1+2
		sta P_TMPP2+1
		stx P_TMPP2+2
.fi		

		;set chord-table related addresses
.if CHORDSUPPORT_ON
		lda chordtbadd+0
		ldx chordtbadd+1
		sta p_chdt1+1
		stx p_chdt1+2
		sta p_chdt2+1
		stx p_chdt2+2
		
		lda chordptadd+0
		ldx chordptadd+1
		sta p_chdp1+1
		stx p_chdp1+2
		sta p_chdp2+1
		stx p_chdp2+2
		sta p_chdp3+1
		stx p_chdp3+2
		sta p_chdp4+1
		stx p_chdp4+2
.fi		;
		rts

;-----------------------------------------------------------------------------
setexport ;ask user for inpot (tune-type and reloc.address) needed for exporting
initscr	lda #0
		sta $d020
		sta $d021
		ldy #0
-		lda #$20 ;clear screen
		sta $0400,y
		sta $0500,y
		sta $0600,y
		sta $0700,y
		lda #3 ;reset color
		sta $d800,y
		sta $d900,y
		sta $da00,y
		sta $db00,y
		iny
		bne -
		
txtout1	ldy #$27 ;print text out
-		lda makertxt1,y
		sta $0400,y
		lda makertxt2,y
		sta $0428,y
		lda makertxt3,y
		sta $0478,y
		lda makertxt4,y
		sta $04C8,y
		lda makertxt5,y
		sta $04F0,y
		dey
		bpl -
		
		lda #0
		sta outputformat
		jsr inveblk ;invert corresponding text-block
		jsr keyrele ;wait to release possibly still pressed return-key
seloutp	lda #$fe ;select output format (PRG/SEQ/EXE/SID)
		sta $dc00
		lda $dc01
chright	cmp #$fb ;cursor-right key? 
		bne chkretu
		jsr shcbget ;check shift/cbm keys
		lda shiftsi
		beq + ;IF shift not pressed
		lda outputformat
		beq ++
		dec outputformat
		jmp ++
+		lda outputformat
		cmp #3
		beq +
		inc outputformat
+		jsr inveblk ;invert corresponding text-block
		jsr keyrele ;wait to release key
		jmp seloutp
chkretu	cmp #$fd ;return key?
		beq selected
		jmp seloutp
selected ;output format is selected here
		jsr keyrele ;wait to release possibly still pressed return-key
		
		lda outputformat
		cmp #2 ;EXEcutable format? no need for relocation
		beq relocset ;skip relocation-setting
txtout2	ldy #$27
-		lda makertxt6,y
		sta $0568,y
		lda makertxt7,y
		sta $05b8,y
		dey
		bpl -
		jsr disrelo ;display hexa relocation target address
setrelo	lda #$80
		cmp $d012 ;wait for retrace
		bne *-3
		lda #$df
		sta $dc00
		lda $dc01
chkplus	cmp #$fe ;plus-key?
		bne chminus
		jsr repeat
		bne setrelo
		lda expoendadd+1 ;end of area to be exported - hi-byte
		clc
		adc #1 ;add 1 for safety to be in range
		adc relocaddr
		bcs direloc ;if range passes over top of memory, don't allow further change
		;cmp #$e0 ;max relocation-address - check tunelength!!!
		;beq direloc
		inc relocaddr
		jmp direloc
chminus	cmp #$f7 ;minus-key?
		bne chkret2
		jsr repeat
		bne setrelo
		lda relocaddr
		cmp #$08 ;min. reloc. address 
		beq direloc
		dec relocaddr
direloc	jsr disrelo ;display hexa relocation target address
		jmp setrelo
chkret2	lda #$fe
		sta $dc00
		lda $dc01
		cmp #$fd
		beq relocset
nokeypr	lda #respd1 ;no pressed key, repeatcounter resets
		sta repecnt	
		jmp setrelo
relocset ;relocation address is set here
		jsr keyrele ;now wait to release RETURN key

;detect and set SID-type (old/new) in SID format
		lda outputformat
		cmp #3 ;SID-format?
		bne endSIDset ;if not, no SID-model setting supported
txtout3	ldy #$27 
-		lda makertxt8,y
		sta $0658,y
		dey
		bpl -
		jsr detectSIDtype ;X is 0 at return if 6581, 1 if 8580 - display included
selSIDm	;$dc00 was set previously
		lda $dc01
		cmp #$fb ;cursor-right key? 
		bne chkret3
		txa
		eor #1
		tax
		jsr dispMod ;display and set SID-Model in SID header, based on X register
		jsr keyrele ;wait to release key
		jmp selSIDm
chkret3	cmp #$fd ;return key?
		beq endSIDset
		jmp selSIDm
endSIDset ;SID-model is selected here and set in SID
		
		jsr keyrele ;now wait to release RETURN key
		rts

;------------------------------------------------------------------------------------------------
.include "include/relocator.inc" ;relocator subroutine and relocation-data for player		
.include "include/datatables.inc" ;tables/variables being displayed and used
.include "include/keyhandler.inc"  ;handle the keypresses - the subroutine-names are found in the datatables.inc file ;callback subroutines for keypresses
.include "include/menu.inc" ;for SID-Maker only file-dialog used.
;==================================================================================================================
.cerror *>$d000,"TOO MUCH CODE BEFORE $D000! MOVE THE CODE BACK A BIT!"
