
#version 150 compatibility 

#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_draw_instanced : enable

uniform mat4 mat_view ;
uniform mat4 mat_proj ;
uniform mat4 mat_world ;

out vec4 color ;
out vec2 tex_coord ;

/// the time in [0,1]
out float vf_time ;

mat3 mat_cam = mat3(
	mat_view[0][0],mat_view[1][0],mat_view[2][0],
	mat_view[0][1],mat_view[1][1],mat_view[2][1],
	mat_view[0][2],mat_view[1][2],mat_view[2][2]
) ;

/// The particle data passed via a texture buffer.
/// It should be indexed via the vertex id.
/// The layout of the buffer in this sample is:
/// Position(vec3), Velocity(vec3)
uniform samplerBuffer particle_data_buffer ;

const float div = (1.0/6.0) ;

/// The quaternion rotation operator rotates an input vector by the specified angle
/// @param vector [in] The vector to be rotated
/// @param angle [in] The angle specified in the quaternion
/// @param axis [in] The quaterion rotation vector
/// @return the rotated vector
vec3 Lq( float angle, vec3 axis, vec3 vector )
{
	return ((2.0*angle*angle)-1.0)*vector + 2.0*dot(axis,vector)*axis + 2.0 * angle * cross(axis,vector) ;
}

void main()
{
	// access the particle's data through the instance id.
	vec4 position = texelFetch( particle_data_buffer, (gl_InstanceID*3) ) ;
	vec4 velocity = texelFetch( particle_data_buffer, (gl_InstanceID*3)+1) ;
	vec4 quaternion = texelFetch( particle_data_buffer, (gl_InstanceID*3)+2 ) ;

	vec4 vertex = gl_Vertex ;

	vertex.xyz = Lq(quaternion.w*smoothstep(0.0,1.0, velocity.w), quaternion.xyz, vertex.xyz) ;
	vertex = vec4(mat_cam * vec3(vertex.x*2.0,vertex.y*2.0,vertex.z),gl_Vertex.w) ;
	
	position = vertex + position ;

	vf_time = velocity.w ;

	position.w = 1.0 ;
	//position.xyz += vec3(float(gl_VertexID)) ;
	
	//position.x += float(gl_VertexID) ;

	// transform to projection space.
	// need camera rotation matrix and projection matrix.
	position = mat_proj * mat_view * position ;
	

	
	color = position ;

	//gl_PointSize = 2.0 ;
	//gl_Position = vec4(float(gl_VertexID)*0.001,float(gl_VertexID)*0.001,0.0,1.0) ;
	gl_Position = position ;


	tex_coord = sign(gl_Vertex.xy)*0.5+0.5 ;
}