﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace Wally
{
	public class Collision
	{
		public double time1;
		public double time2;
		public double vaporChange;
		public Vector escape;

		public static Collision getCollision(Cloud me, Cloud cloud)
		{
			return getCollision(me, me.Velocity, cloud);
		}

		public static Collision getCollision(Cloud me, Vector velocity, Cloud cloud)
		{
			var ds = me.Position - cloud.Position;
			var dv = 10 * (velocity - cloud.Velocity);
			double r = me.Radius + cloud.Radius;
			double a = dv.X * dv.X + dv.Y * dv.Y;
			double b = ds.X * dv.X + ds.Y * dv.Y;
			double c = ds.X * ds.X + ds.Y * ds.Y - r * r;
			double discr = b * b - a * c;
			if (discr < 0) return null;
			var collisionInfo = new Collision();
			collisionInfo.time1 = (-b - Math.Sqrt(discr)) / a;
			collisionInfo.time2 = (-b + Math.Sqrt(discr)) / a;

			double time = -b / a;
			var collisionCenter = ds + dv * time;
			double distance = collisionCenter.Length;
			double overlap = r - distance;
			collisionInfo.vaporChange = Math.Sqrt(overlap / r) * (me.Vapor > cloud.Vapor ? cloud.Vapor : -me.Vapor);

			var direction = collisionCenter;
			if (direction.Length < 1)
				direction = new Vector(dv.Y, -dv.X);
			direction.Normalize();
			collisionInfo.escape = direction * overlap / time;
			return collisionInfo;
		}

		public static List<Collision> getCollisions(Cloud me, Vector velocity, GameState state)
		{
			var collisions = new List<Collision>();
			foreach (Cloud cloud in state.AllClouds)
			{
				var collision = getCollision(me, velocity, cloud);
				if (collision != null && collision.time1 > 0) collisions.Add(collision);
			}
			collisions.Sort((c1, c2) => c1.time1.CompareTo(c2.time1));
			return collisions;
		}
	}
}
