#include "GameConnection.h"
#include "GameState.h"
#include "Graphics.h"
#include "ReplayConnection.h"

int main(int argc, char *argv[]) {
    if (argc != 2) {
        cout << "args plz" << endl;
        return 1;
    }

    //TTF_Init();
    //font = TTF_OpenFont("LiberationMono-Bold.ttf", 10);
    MyWindow *window;
    window = new MyWindow();


    ReplayConnection *replay = new ReplayConnection();
    replay->connect(argv[1], "lol");
    GameConnection<ReplayConnection> *conn = new GameConnection<ReplayConnection>(replay);
    printf("hello\n");

    vector<GameState*> states;

    try {
        while (replay->isConnected()) {
            GameState *state = conn->getState();
            states.push_back(state);
        }
    } catch (const ConnectException &e) {

    }
    cout << "Number of states: " << states.size() << endl;

    int current_state = 0;
    int play = 0;
    int done = 0;
    int speed = 1;
    int simulate = 0;
    while (!done) {
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        SDL_Event event;
        while (SDL_PollEvent(&event) > 0) {
            //if (this->HandleEvent(&event) == -1) { quit = 1; }
            switch(event.type) {
                case SDL_KEYDOWN:
                    switch (event.key.keysym.sym) {
                        case SDLK_ESCAPE: done = 1; break;
                        case SDLK_RIGHT: current_state++; break;
                        case SDLK_LEFT: current_state--; break;
                        case SDLK_SPACE: play = !play; break;
                        case SDLK_KP_PLUS:
                        case SDLK_PLUS: 
                                         speed++; break;
                                         cout << "speed " << speed << endl;
                        case SDLK_KP_MINUS:
                        case SDLK_MINUS: speed--; break;
                                         cout << "speed " << speed << endl;
                        
                        case SDLK_s:
                            simulate = 1;
                            break;
                        case SDLK_n:
                            states[current_state]->next_move(window);
                            break;
                        default: break;
                    }
                    break;
                case SDL_KEYUP:
                    switch (event.key.keysym.sym) {
                        case SDLK_s:
                            simulate = 0;
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }
        }

        if (play && current_state < states.size()-1) {
            current_state += speed;
        }
        if (current_state >= states.size())
            current_state = states.size()-1;

        if (simulate)
            states[current_state]->simulate();

        window->Render(states[current_state]);
        SDL_GL_SwapBuffers();
        usleep(100000);
    }

    return 0;
}
