/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public abstract class Client {
    private Socket client;
    private BufferedReader reader;
    private PrintWriter writer;
    private byte[] data = new byte[256];
    private InetSocketAddress endPoint;
    private boolean started = false;
    private int iteration = 0;

    public GameState GetState() {
        try {
            String line = "";
            if (!this.started) {
                line = this.reader.readLine();
                while (line == null || !line.equals("START")) {
                    line = this.reader.readLine();
                }
                this.started = true;
            }
            System.out.println("GET_STATE");
            this.writer.println("GET_STATE");
            this.writer.flush();
            GameState state = new GameState();
            boolean end = false;
            while (!end) {
                line = this.reader.readLine();
                if (line == null) continue;
                String[] msg = line.split("\\s+");
                String key = msg[0];
                if (key.equals("BEGIN_STATE")) {
                    this.iteration = Integer.parseInt(msg[1]);
                    System.out.print("Receiving state for iteration " + this.iteration);
                    continue;
                }
                if (key.equals("END_STATE")) {
                    System.out.println(" Done");
                    end = true;
                    continue;
                }
                if (key.equals("THUNDERSTORM")) {
                    state.Thunderstorms.add(new Cloud(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]), Float.parseFloat(msg[3]), Float.parseFloat(msg[4]), Float.parseFloat(msg[5])));
                    continue;
                }
                if (key.equals("RAINCLOUD")) {
                    state.Rainclouds.add(new Cloud(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]), Float.parseFloat(msg[3]), Float.parseFloat(msg[4]), Float.parseFloat(msg[5])));
                    continue;
                }
                if (!key.equals("YOU")) continue;
                state.MeIndex = Integer.parseInt(msg[1]);
            }
            return state;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void SetName(String name) {
        System.out.println("NAME " + name);
        this.writer.println("NAME " + name);
        this.writer.flush();
    }

    public boolean Wind(float x, float y) throws IOException {
        System.out.println("WIND " + x + " " + y);
        this.writer.println("WIND " + x + " " + y);
        this.writer.flush();
        String response = this.reader.readLine();
        boolean ok = response.equals("OK");
        return ok;
    }

    protected boolean Connected() {
        return this.client.isConnected() && !this.client.isClosed() && !this.writer.checkError();
    }

    public Client() throws IOException, InterruptedException {
        this.client = new Socket();
        this.endPoint = new InetSocketAddress("127.0.0.1", 1986);
        this.client.connect(this.endPoint);
        this.reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
        this.writer = new PrintWriter(this.client.getOutputStream(), true);
        this.RunAi();
    }

    public abstract void RunAi() throws IOException, InterruptedException;
}

