import java.util.ArrayList;
import java.util.List;

public class GameState {
	public static final int MAP_WIDTH = 1280;
	public static final int MAP_HEIGHT = 720;

	public ArrayList<Cloud> thunderstorms = new ArrayList<Cloud>();
	public ArrayList<Cloud> rainclouds = new ArrayList<Cloud>();
	public int meIndex;

	public Cloud me() {
		try {
			return thunderstorms.get(meIndex);
		} catch (Exception e) {
			return thunderstorms.get(0);
		}

	}

	public int iteration = 0;
	public int deltaIteration = 0;

	public double minVapor = Float.MAX_VALUE;

	public boolean imDead = false;
	public double bonus=1;

	public void iterate() {

		List<Cloud> all = new ArrayList<Cloud>();
		all.addAll(thunderstorms);
		all.addAll(rainclouds);

		for (Cloud a : all) {
			// Update position and velocity
			a.position.x += 0.1 * a.velocity.x;
			a.position.y += 0.1 * a.velocity.y;
			a.velocity.x *= 0.999;
			a.velocity.y *= 0.999;

			// Absorbing
			for (Cloud b : all) {
				if (a.equals(b) || a.vapor < 1 || b.vapor < 1)
					continue;

				
				if (a.distanceTo(b) < a.radius() + b.radius()) {
					if (a.vapor > b.vapor) {
						if (a.equals(me()) && a.vapor<b.vapor*1.05) {
							bonus-=0.05;
						}
					} else {
						if (b.equals(me()) && b.vapor <a.vapor*1.05) {
							bonus-=0.05;
						}
					}

				}

				// While intersecting
				while (a.distanceTo(b) < a.radius() + b.radius()) {
					if (a.vapor < b.vapor) {

						a.vapor -= 1;
						b.vapor += 1;
						if (a.vapor < 1) {// Dead!
							if (a.isThunder) {
								if (a.equals(me())) {
									imDead = true;
									return;
								}
								if (thunderstorms.indexOf(a) < meIndex)
									meIndex--;
								thunderstorms.remove(a);
								bonus+=0.1;
							} else
								rainclouds.remove(a);

							if (rainclouds.size() == 0 && thunderstorms.size() == 1)
								return;

							break;
						}
					} else {
						a.vapor += 1;
						b.vapor -= 1;
						if (b.vapor < 1) {// Dead!
							if (b.isThunder) {
								if (b.equals(me())) {
									imDead = true;
									return;
								}
								if (thunderstorms.indexOf(b) < meIndex)
									meIndex--;
								thunderstorms.remove(b);
								bonus+=0.1;
							} else
								rainclouds.remove(b);

							if (rainclouds.size() == 0 && thunderstorms.size() == 1)
								return;

							break;
						}
					}
				}
			}

			// Bouncing
			double rad = a.radius();
			if (a.position.x < rad) {
				a.position.x = rad;
				a.velocity.x =  (Math.abs(a.velocity.x) * 0.6);
			}
			if (a.position.y < rad) {
				a.position.y = rad;
				a.velocity.y =  (Math.abs(a.velocity.y) * 0.6);
			}
			if (a.position.x + rad > MAP_WIDTH) {
				a.position.x = MAP_WIDTH - rad;
				a.velocity.x = (-Math.abs(a.velocity.x) * 0.6);
			}
			if (a.position.y + rad > MAP_HEIGHT) {
				a.position.y = MAP_HEIGHT - rad;
				a.velocity.y = (-Math.abs(a.velocity.y) * 0.6);
			}

			// Keep track of lowest size or something
			// if(a.equals(me())){
			//
			// }
		}

		minVapor = Math.min(minVapor, me().vapor);

		iteration++;
		deltaIteration++;
	}

	public boolean amIBiggest() {
		double max = me().vapor;
		for (Cloud c : rainclouds) {
			if (c.vapor > max)
				return false;
		}

		for (Cloud c : thunderstorms) {
			if (!c.equals(me()))
				if (c.vapor > max)
					return false;
		}
		return true;
	}

	public GameState clone() {
		GameState s = new GameState();
		s.iteration = iteration;
		s.meIndex = meIndex;

		for (Cloud c : thunderstorms)
			s.thunderstorms.add(c.clone());

		for (Cloud c : rainclouds)
			s.rainclouds.add(c.clone());

		return s;
	}
}
