/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class GameState {
    public static final int MAP_WIDTH = 1280;
    public static final int MAP_HEIGHT = 720;
    public ArrayList<Cloud> thunderstorms = new ArrayList();
    public ArrayList<Cloud> rainclouds = new ArrayList();
    public int meIndex;
    public int iteration = 0;
    public int deltaIteration = 0;
    public double minVapor = 3.4028234663852886E38;
    public boolean imDead = false;
    public double bonus = 1.0;

    public Cloud me() {
        try {
            return this.thunderstorms.get(this.meIndex);
        }
        catch (Exception e) {
            return this.thunderstorms.get(0);
        }
    }

    public void iterate() {
        ArrayList<Cloud> all = new ArrayList<Cloud>();
        all.addAll(this.thunderstorms);
        all.addAll(this.rainclouds);
        for (Cloud a : all) {
            a.position.x += 0.1 * a.velocity.x;
            a.position.y += 0.1 * a.velocity.y;
            a.velocity.x *= 0.999;
            a.velocity.y *= 0.999;
            block1: for (Cloud b : all) {
                if (a.equals(b) || a.vapor < 1.0 || b.vapor < 1.0) continue;
                if (a.distanceTo(b) < a.radius() + b.radius()) {
                    if (a.vapor > b.vapor) {
                        if (a.equals(this.me()) && a.vapor < b.vapor * 1.05) {
                            this.bonus -= 0.05;
                        }
                    } else if (b.equals(this.me()) && b.vapor < a.vapor * 1.05) {
                        this.bonus -= 0.05;
                    }
                }
                while (a.distanceTo(b) < a.radius() + b.radius()) {
                    if (a.vapor < b.vapor) {
                        a.vapor -= 1.0;
                        b.vapor += 1.0;
                        if (!(a.vapor < 1.0)) continue;
                        if (a.isThunder) {
                            if (a.equals(this.me())) {
                                this.imDead = true;
                                return;
                            }
                            if (this.thunderstorms.indexOf(a) < this.meIndex) {
                                --this.meIndex;
                            }
                            this.thunderstorms.remove(a);
                            this.bonus += 0.1;
                        } else {
                            this.rainclouds.remove(a);
                        }
                        if (this.rainclouds.size() != 0 || this.thunderstorms.size() != 1) continue block1;
                        return;
                    }
                    a.vapor += 1.0;
                    b.vapor -= 1.0;
                    if (!(b.vapor < 1.0)) continue;
                    if (b.isThunder) {
                        if (b.equals(this.me())) {
                            this.imDead = true;
                            return;
                        }
                        if (this.thunderstorms.indexOf(b) < this.meIndex) {
                            --this.meIndex;
                        }
                        this.thunderstorms.remove(b);
                        this.bonus += 0.1;
                    } else {
                        this.rainclouds.remove(b);
                    }
                    if (this.rainclouds.size() != 0 || this.thunderstorms.size() != 1) continue block1;
                    return;
                }
            }
            double rad = a.radius();
            if (a.position.x < rad) {
                a.position.x = rad;
                a.velocity.x = Math.abs(a.velocity.x) * 0.6;
            }
            if (a.position.y < rad) {
                a.position.y = rad;
                a.velocity.y = Math.abs(a.velocity.y) * 0.6;
            }
            if (a.position.x + rad > 1280.0) {
                a.position.x = 1280.0 - rad;
                a.velocity.x = -Math.abs(a.velocity.x) * 0.6;
            }
            if (!(a.position.y + rad > 720.0)) continue;
            a.position.y = 720.0 - rad;
            a.velocity.y = -Math.abs(a.velocity.y) * 0.6;
        }
        this.minVapor = Math.min(this.minVapor, this.me().vapor);
        ++this.iteration;
        ++this.deltaIteration;
    }

    public boolean amIBiggest() {
        double max = this.me().vapor;
        for (Cloud c : this.rainclouds) {
            if (!(c.vapor > max)) continue;
            return false;
        }
        for (Cloud c : this.thunderstorms) {
            if (c.equals(this.me()) || !(c.vapor > max)) continue;
            return false;
        }
        return true;
    }

    public GameState clone() {
        GameState s = new GameState();
        s.iteration = this.iteration;
        s.meIndex = this.meIndex;
        for (Cloud c : this.thunderstorms) {
            s.thunderstorms.add(c.clone());
        }
        for (Cloud c : this.rainclouds) {
            s.rainclouds.add(c.clone());
        }
        return s;
    }
}

