#include "ga.h"
#include "viz.h"

volatile float frand() 
{
	static const uint p = 1<<15;
	return float(rand()&(p-1))/p; 
}

gene gene::random(int min_delay) { return gene(min_delay + rand()&511, unitlen(vec2(frand()*2-1, frand()*2-1))*100); }

genome genome::random()
{
	static const float Padd = 0.6;
	float fr;

	genome g;
	g._genes.reserve(8);
	while ( g._genes.size() < 4 || (fr=frand()) < Padd )
	{
		g._genes.push_back(gene::random(g._genes.size() ? 32 : 0));
		//printf("size = %5d, wind: [%g,%g] (%g,%d)\n", g._genes.size(), g._genes.back().wind.x, g._genes.back().wind.y, fr);
	}
	return g;
}

void genome::cut_front(int steps)
{
	if (steps > 0)
	{
		_fitness = -1;
		_ts = -1;
		if (!_genes.empty() && _genes.front().wait < steps)
		{
			steps -= _genes.front().wait;
			_genes.erase(_genes.begin());
		}
		if (!_genes.empty())
		{
			_genes.front().wait -= steps;
			if (_genes.front().wait < 0)
				_genes.front().wait = 0;
		}
	}
}

void update_score(const int time_used, const int dt, float& score, const state* s0, const state* s1)
{
	const float vap1 = s1->me.vap;
	const vec2  pos1 = s1->me.pos;
	/*for (auto it = s1->rc.begin(); it != s1->rc.end(); it++)
	{
		const float w = it->vap*dt/length(it->pos-pos1)*1000;
		if (it->vap < vap1)	score += w;
		else				score -= w;
	}
	for (auto it = s1->tc.begin(); it != s1->tc.end(); it++)
	{
		const float w = it->vap*dt/length(it->pos-pos1)*1200;
		if (it->vap*1.1 < vap1)	score += w;
		else					score -= w;
	}*/
	score += vap1*dt + length(s1->me.vel)*(dt*100);
	//if (s1->me.vap > s0->me.vap)
	//score += (s1->me.vap-s0->me.vap);///time_used;
	//auto it = s1->tc.begin();
	//auto jt = s0->tc.begin();
	//for ( ; it != s1->tc.end(); it++, jt++)
		//if (it->vap > jt->vap)
	//	score -= (it->vap - jt->vap)/time_used;
}

void fatten_thunder(state& s, int dt)
{
	for (auto it = s.tc.begin(); it != s.tc.end(); it++)
		it->vap *= (1 + dt/8000.0);
}

float genome::fitness_recalc() const
{
	int sim_c = 0;
	int skip;
	static const int post_steps = 300;

	int time_used = 0;
	state s = current_state;
	state ss;
	state* s0 = &s;
	state* s1 = &ss;

#ifdef _SAVE_PATH
	path.clear();
	path.push_back(s0->me.pos);
#endif
	float score = s0->me.vap;
	for (auto it = _genes.begin(); it != _genes.end(); it++)
	{
		int toff = 0;
		while (it->wait-toff > (skip=sim_max_skip(*s0)))
		{
			fatten_thunder(*s1 = look_ahead(*s0, skip), skip);
			if (s1->lose)		return _fitness = 30000;
			else if (s1->win)	return _fitness = time_used+1000;
			sim_c++;
			time_used += skip;
			update_score(time_used, skip, score, s0, s1);
#ifdef _SAVE_PATH
			path.push_back(s1->me.pos);
#endif
			toff += skip;
			std::swap(s0, s1);
		}
		fatten_thunder(*s1 = look_ahead(*s0, it->wait-toff), it->wait-toff);
		if (s1->lose)		return _fitness = 30000;
		else if (s1->win)	return _fitness = time_used+1000;
		sim_c++;
		time_used += it->wait-toff;
		update_score(time_used, it->wait-toff, score, s0, s1);
#ifdef _SAVE_PATH
		path.push_back(s1->me.pos);
#endif
		apply_wind(s, it->wind);
		std::swap(s0,s1);
	}
	for (uint i = 0; i < post_steps; i+= (skip=sim_max_skip(*s0)))
	{
		fatten_thunder(*s1 = look_ahead(*s0, skip), skip);
		if (s1->lose)		return _fitness = 30000;
		else if (s1->win)	return _fitness = time_used+1000;
		sim_c++;
		time_used += skip;
		update_score(time_used, skip, score, s0, s1);
#ifdef _SAVE_PATH
		path.push_back(s1->me.pos);
#endif
		std::swap(s0,s1);
	}

	score /= time_used;
	score += s0->me.vap*1.2;
	//score -= time_used*time_used/1000000;
	for (auto it = s0->tc.begin(); it != s0->tc.end(); it++)
		score -= it->vap*1.4;

	_fitness = 20000-score;//10000-s.me.vap;
	_ts = s.turn;
	return _fitness;
}

float genome::distance(const genome& gb) const
{
	const int N = _genes.size() < gb._genes.size() ? _genes.size() : gb._genes.size();
	float sum = 0;
	for (int i = 0; i < N; i++)
		sum += (_genes[i].wait-gb._genes[i].wait)*(_genes[i].wait-gb._genes[i].wait) + square(_genes[i].wind-gb._genes[i].wind);
	return sum/N;
}

genome& genome::mutate()
{
	const float Pdel = 0.1;
	const float Pins = _genes.size() < 8 ? 0.02*(8-_genes.size()) : 0.02;
	const float Pmut = 0.2;
	
	const float y = frand();
	if (y < Pdel && !_genes.empty())
	{
		const int i = rand()%_genes.size();
		if (_genes.size() > i+1)
			_genes[i+1].wait += _genes[i].wait;
		_genes.erase(_genes.begin()+i);
	}
	else if (y < Pdel+Pins)
		_genes.push_back(gene::random(32));

	for (int i = 0; i < _genes.size(); i++)
	{
		const float x = frand();
		if (x < Pmut)
		{
			_genes[i].wait += (rand()&63)-16;
			if (_genes[i].wait < 16 && i > 0)
				_genes[i].wait = 16;
		}
		else if (x < Pmut+Pmut)
		{
			_genes[i].wind.x += (frand()*2-1)*20;
			_genes[i].wind.y += (frand()*2-1)*20;
		}
		else if (x < Pmut+Pmut+Pmut)
		{
			const float phi = (2*frand()-1)*0.5;
			_genes[i].wind.x = _genes[i].wind.x*cos(phi) - _genes[i].wind.y*sin(phi);
			_genes[i].wind.y = _genes[i].wind.x*sin(phi) + _genes[i].wind.y*cos(phi);
		}
		else if (x < Pmut*4)
		{
			_genes[i].wind = _genes[i].wind*(1.5-frand())*0.5;
		}
	}
	_ts = -1;
	_fitness = -1;
	return *this;
}

void generation::init(int pop)
{
	for (int i = 0; i < pop; i++)
		genomes.push_back(genome::random());
	genomes.sort();
	printf("random generation with %d individuals,\n best: %g / worst: %g\n", pop, genomes.front().fitness(), genomes.back().fitness());
}

void generation::next(uint dt)
{
	const int pop = genomes.size();
	int c = 0;
	for (auto it = genomes.begin(); it != genomes.end(); c++)
	{
		bool bad = false;
		//for (auto jt = genomes.begin(); jt != it; jt++)
		//	if (it->distance(*jt) < 1)
		//	{
		//		bad = true;
		//		break;
		//	}
		if ( c < pop/4 )
			genomes.pop_back();

		if (bad)
			it = genomes.erase(it);
		else
		{
			if ( c < pop/3 )
				genomes.push_front(genome(*it).mutate());
			//genomes.push_back(genome(*it).mutate());
			it++;
		}
	}
	for (int i = 0; i < pop/4; i++)
		genomes.push_back(genome::random());
	if (dt > 0) for (auto it = genomes.begin(); it != genomes.end(); it++)
	{
		it->cut_front(dt);
		it->fitness_recalc();
	}
	genomes.sort();
	while (genomes.size() > pop)
		genomes.pop_back();
	set_solv(genomes.front());
	if (solv._fitness < 0)
		printf("OOPS ");
	//printf("mutation only next generation (dt: %d) with %d individuals, best: %g / worst %g\n", dt, genomes.size(), 
	//	genomes.front().fitness(), genomes.back().fitness());
}

