#version 120 
#extension GL_EXT_geometry_shader4 : enable

uniform float explotionProgress;

void main(void)
{
	int i;
	for(i=0; i< gl_VerticesIn; i++){
		gl_Position = gl_PositionIn[i];
		gl_Position.x = gl_Position.x-5.0f;
		gl_TexCoord[0] = gl_TexCoordIn[i][0];
		EmitVertex();
	}
	EndPrimitive();	
	
	for(i=0; i< gl_VerticesIn; i+=3){
	
		vec4 edgeA = gl_PositionIn[i+1] - gl_PositionIn[i];
        vec4 edgeB = gl_PositionIn[i+2] - gl_PositionIn[i];
        vec3 faceNormal = normalize( cross(edgeA.xyz, edgeB.xyz) );
              
		gl_Position = gl_PositionIn[i]+(vec4(faceNormal,0)*explotionProgress);
		gl_Position.x = gl_Position.x+5.0f;
		gl_TexCoord[0] = gl_TexCoordIn[i][0];
		EmitVertex();
		
		gl_Position = gl_PositionIn[i+1]+(vec4(faceNormal,0)*explotionProgress);
		gl_Position.x = gl_Position.x+5.0f;
		gl_TexCoord[0] = gl_TexCoordIn[i+1][0];
		EmitVertex();
		
		gl_Position = gl_PositionIn[i+2]+(vec4(faceNormal,0)*explotionProgress);
		gl_Position.x = gl_Position.x+5.0f;
		gl_TexCoord[0] = gl_TexCoordIn[i+2][0];
		EmitVertex();
	}
	EndPrimitive();	
																					
}
