#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

in vec2 POSITION;

out vec4 extinction;
out vec3 inscatter;
out vec2 uv;
out vec2 uv2;
out vec3 eyeDir;
out vec3 lightDir;

#include <gerstner_wave_model_include.vert>

#include <atmosphere_model_include.vert>

void main()
{
	const float waterDepth = 10.0;
	vec4 pos;
	vec3 t, b, n;
	calculateGerstnerWaterDepthVertexTBN(POSITION, waterDepth, pos, t, b, n);

	//pos.xz += EyePosition.xz;
	pos.xz = POSITION + EyePosition.xz;
	pos.y = -waterDepth;
	calculateGroundAtmosphere(pos.xyz, n, extinction, inscatter);

	lightDir.x = dot(SunDirection, t);
	lightDir.y = dot(SunDirection, b);
	lightDir.z = dot(SunDirection, n);

	vec3 eye = -vec3(ModelViewMatrix * pos);
	eyeDir.x = dot(eye, t);
	eyeDir.y = dot(eye, b);
	eyeDir.z = dot(eye, n);

	float angle = (pos.x + pos.z + GerstnerTime)*0.01;
	vec2 uv_offs = vec2(sin(angle), cos(angle));
	uv = pos.xz*(1.0/5.0) + uv_offs;
	uv2 = uv + pos.yy*(1.0/10.0) + uv_offs;

	gl_Position = ModelViewProjectionMatrix * pos;
}
