#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform float extrude;

in vec3 gs_normal[2];

out vec2 uv;

layout(lines) in;
layout(triangle_strip, max_vertices = 4) out;


#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	vec4 p0 = gl_in[0].gl_Position;
	vec3 n0 = gs_normal[0];
	vec4 p1 = gl_in[1].gl_Position;
	vec3 n1 = gs_normal[1];

	vec3 a = p0.xyz;
	vec3 b = p1.xyz;
	vec3 c = p1.xyz + n1*extrude;
	vec3 d = p0.xyz + n0*extrude;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
