#version 330 core

uniform mat4 ModelViewMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL; // velocity
in vec3 COLOR; // force
in vec3 TANGENT; // radius, energy, 1/mass

out vec4 gs_coords;
out vec3 gs_params; // radius, energy, 1/mass

void main()
{
	gs_coords = vec4(NORMAL.x, NORMAL.y, COLOR.x, COLOR.y);
	gs_params = TANGENT;
	gl_Position = vec4(POSITION, 1.0);
}
